# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""


class ApiRestV2MetadataTmlExportRequest(object):

    """Implementation of the 'Api Rest V2 Metadata Tml Export Request' model.

    TODO: type model description here.

    Attributes:
        id (list of string): A JSON array of GUIDs of the objects.
        format_type (FormatTypeEnum): The format in which to export the
            objects
        export_associated (bool): Specifies if you would like to export the
            associated objects. To export the objects associated with the
            objects specified in id, set the value to true. When set to true,
            the API exports any underlying worksheets, tables, or views for a
            given object. By default, the API does not export these underlying
            objects

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "format_type": 'formatType',
        "export_associated": 'exportAssociated'
    }

    def __init__(self,
                 id=None,
                 format_type='YAML',
                 export_associated=False):
        """Constructor for the ApiRestV2MetadataTmlExportRequest class"""

        # Initialize members of the class
        self.id = id
        self.format_type = format_type
        self.export_associated = export_associated

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get('id')
        format_type = dictionary.get("formatType") if dictionary.get("formatType") else 'YAML'
        export_associated = dictionary.get("exportAssociated") if dictionary.get("exportAssociated") else False

        # Return an object of this model
        return cls(id,
                   format_type,
                   export_associated)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
