# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_utils.ipynb.

# %% ../nbs/00_utils.ipynb 2
from __future__ import annotations
from fastcore.docments import *
from fastcore.test import *
from fastcore.utils import *

import pandas as pd
import numpy as np

# %% auto 0
__all__ = ['createLagFeatures', 'getWeekdayFeature', 'getMonthFeature', 'getDayIndex']

# %% ../nbs/00_utils.ipynb 5
def createLagFeatures(data, idFeature = 'id', lagDays = range(1, 8), lagDaysArithmetic = [7, 14, 21, 28]):

    IDs = data[idFeature].unique()

    yLagPerID = list()

    # Loop over all items
    for ID in IDs:
        dataID = data[data[idFeature] == ID]

        y = dataID.demand

        # Create lag features of y (demand) with time windows of 7 days
        lagDemands = [y.shift(i) for i in lagDays]
        yLag = pd.concat(lagDemands, axis = 1)

        yLag.columns = ['demand_lag_' + str(i) for i in range(1, 8)]

        #---

        yLagArithmeticList = list()
        # Create lagged mean, max, min, variance, sum of last 7, 14, 21 and 28 days without current day
        for i in lagDaysArithmetic:

            # remove current day
            yMod = y.shift(1)

            # Compute lagged mean, max, min, variance, sum
            yLagMean = yMod.rolling(i).mean()
            yLagMean.name = 'demand_lag_mean_' + str(i)

            yLagMax = yMod.rolling(i).max()
            yLagMax.name = 'demand_lag_max_' + str(i)

            yLagMin = yMod.rolling(i).min()
            yLagMin.name = 'demand_lag_min_' + str(i)

            yLagVar = yMod.rolling(i).var()
            yLagVar.name = 'demand_lag_var_' + str(i)

            yLagSum = yMod.rolling(i).sum()
            yLagSum.name = 'demand_lag_sum_' + str(i)

            yLagArithmetic = pd.concat([yLagMean, yLagMax, yLagMin, yLagVar, yLagSum], axis = 1)
            yLagArithmeticList.append(yLagArithmetic)

        yLagArithmeticAll = pd.concat(yLagArithmeticList, axis = 1)

        # Add lag features to list
        yLagAll = pd.concat([yLag, yLagArithmeticAll], axis = 1)
        yLagPerID.append(yLagAll)

    # Concatenate lag features of all items
    yLagAllIDs = pd.concat(yLagPerID, axis = 0)

    # Add lag features to data
    dataWithLags = pd.concat([data, yLagAllIDs], axis = 1)

    return dataWithLags


# %% ../nbs/00_utils.ipynb 7
def getWeekdayFeature(weekday):
    if weekday == 'MON':
        weekdayInt = 1
    elif weekday == 'TUE':
        weekdayInt = 2
    elif weekday == 'WED':
        weekdayInt = 3
    elif weekday == 'THU':
        weekdayInt = 4
    elif weekday == 'FRI':
        weekdayInt = 5
    elif weekday == 'SAT':
        weekdayInt = 6
    elif weekday == 'SUN':
        weekdayInt = 7
        
    return weekdayInt        

# %% ../nbs/00_utils.ipynb 8
def getMonthFeature(month):
    if month == 'JAN':
        monthInt = 1
    elif month == 'FEB':
        monthInt = 2
    elif month == 'MAR':
        monthInt = 3
    elif month == 'APR':
        monthInt = 4
    elif month == 'MAY':
        monthInt = 5
    elif month == 'JUN':
        monthInt = 6
    elif month == 'JUL':
        monthInt = 7
    elif month == 'AUG':
        monthInt = 8
    elif month == 'SEP':
        monthInt = 9
    elif month == 'OCT':
        monthInt = 10
    elif month == 'NOV':
        monthInt = 11
    elif month == 'DEC':
        monthInt = 12
    
    return monthInt

# %% ../nbs/00_utils.ipynb 9
def getDayIndex(date):
    year = date.timetuple().tm_year
    
    if year == 2016:
        yearCoefficient = 0
    elif year == 2017:
        yearCoefficient = 366
    elif year == 2018:
        yearCoefficient = 366 + 365
    elif year == 2019:
        yearCoefficient = 366 + 365 + 365
    elif year == 2020:
        yearCoefficient = 366 + 365 + 365 + 365
        
    dayIndex = date.timetuple().tm_yday + yearCoefficient
    
    return dayIndex
