# Generated by Django 4.0.5 on 2022-06-25 06:34

from django.db import migrations, models
import studies.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ExperimentConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(editable=False, help_text="The experiment's name set by the system.", max_length=100, unique=True, verbose_name='Name')),
                ('percent_enabled', models.SmallIntegerField(default=0, help_text='Set it to 0 (zero) if you want to disable the experiment.', validators=[studies.validators.validate_percent], verbose_name='Percent of users that will be impacted')),
                ('first_run', models.DateTimeField(auto_now_add=True, verbose_name='First run')),
                ('last_run', models.DateTimeField(default=None, editable=False, null=True, verbose_name='Last run')),
            ],
            options={
                'verbose_name': 'Experiment config',
                'verbose_name_plural': 'Experiment configs',
                'ordering': ['name'],
            },
        ),
    ]
