# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/distributed.forecast.ipynb (unless otherwise specified).

__all__ = ['DistributedForecast']

# Cell
from typing import Callable, Dict, Optional

import dask.dataframe as dd
from dask.distributed import Client, default_client

from ..core import preprocessing_flow
from .core import distributed_preprocess

# Cell
class DistributedForecast:

    def __init__(self, model, flow_config: Dict, client: Optional[Client] = None):
        self.model = model
        self.flow_config = flow_config
        self.client = client or default_client()

    def preprocess(self, data: dd.DataFrame, prep_fn: Callable = preprocessing_flow) -> dd.DataFrame:
        self.data_divisions = data.divisions
        self.ts, train_ddf = distributed_preprocess(data, self.flow_config, self.client, prep_fn)
        return train_ddf

    def fit(self, data: dd.DataFrame, **kwargs) -> 'DistributedForecast':
        train_ddf = self.preprocess(data)
        X, y = train_ddf.drop(columns=['ds', 'y']), train_ddf.y
        self.model.fit(X, y, **kwargs)
        return self

    def predict(self, horizon: int) -> dd.DataFrame:
        return self.model.predict(self.ts, horizon, self.data_divisions)

    def __repr__(self) -> str:
        return f'DistributedForecast(model={self.model}, flow_config={self.flow_config})'