import { Provider } from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
import { FunctionProps } from '.';
export * from './function';
export declare class CustomResourceProvider extends Construct {
    /**
     * The function construct containing all the Lambda functions, application logic,
     * roles and policies
     */
    private readonly functionConstruct;
    /**
     * The provider framework with the underlying Lambda function.
     */
    private readonly providerFramework;
    /**
     * The construct scope
     */
    private readonly scope;
    /**
     * The instance props
     */
    private readonly props;
    constructor(scope: Construct, id: string, props: FunctionProps);
    private createFunctionConstruct;
    private createProviderFramework;
    gProviderFramework(): Provider;
}
