import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
export interface FunctionProps {
    /**
     * The ARN of the role on the target account that the STS client on the Lambda function
     * assumes and has permissions to create, update and delete a parameter on that account.
     */
    readonly roleArn: string;
    /**
     * Optional: IAM role session name when STS client on the Lambda function assumes the
     * role on the target account. Default is `halloumi_cross_account_parameter_store`.
     */
    readonly roleSessionName?: string;
    /**
     * Optional: Information that you can use in an IAM role trust policy to designate who
     * can assume the role.
     */
    readonly roleExternalId?: string;
}
export declare class FunctionConstruct extends Construct {
    /**
     * The construct scope
     */
    private readonly scope;
    /**
     * The region in which the parent stack is deployed to
     */
    private readonly region;
    /**
     * The instance props
     */
    private readonly props;
    /**
     * The function code from a local directory.
     */
    private readonly functionCode;
    /**
     * The name of the method within your code that Lambda calls to execute your
     * function.Default is set to `main.on_event`
     */
    private readonly handler;
    /**
     * The runtime environment for the Lambda function that you are uploading.
     * Default is set to `Runtime.PYTHON_3_8`
     */
    private readonly runtime;
    /**
     * The IAM Role of the function.
     */
    private readonly functionRole;
    /**
     * The Lambda function
     */
    private readonly _function;
    constructor(scope: Construct, id: string, props: FunctionProps);
    /**
     * Try and load the Lambda function code assets
     */
    private loadFunctionCode;
    /**
     * Create the IAM role and its required policies to attach the the Lambda function
     */
    private createFunctionRole;
    /**
     * Create the Lambda function resource
     */
    private createFunction;
    /**
     * Get the IAM Role attached to the function
     */
    gFunctionRole(): iam.IRole;
    /**
     * Get the function
     */
    gFunction(): lambda.IFunction;
}
