import { CustomResource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { CustomResourceProvider } from './resources';
export interface ParameterManagerProps {
    /**
     * An instance of the `CustomResourceProvider`
     */
    readonly customResourceProvider: CustomResourceProvider;
    /**
     * The name of the parameter on the target account that is going to be managed.
     */
    readonly parameterName: string;
    /**
     * The value of the parameter on the target account.
     */
    readonly parameterValue: unknown;
    /**
     * A description for the parameter.
     */
    readonly parameterDescription: string;
}
export * from './resources/provider';
export declare class HalloumiCrossAccountParameterStore extends Construct {
    /**
     * The provider framework with the underlying Lambda function.
     */
    private readonly providerFramework;
    /**
     * The construct scope
     */
    private readonly scope;
    /**
     * The instance props
     */
    private readonly props;
    constructor(scope: Construct, id: string, props: ParameterManagerProps);
    createParameterManager(id: string): CustomResource;
}
