"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .zillowpricehistoryevent import (
    ZillowPriceHistoryEvent,
    ZillowPriceHistoryEventTypedDict,
)
from exfunc.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AddressTypedDict(TypedDict):
    r"""The physical address of the property"""

    street_address: NotRequired[str]
    r"""The street address of the building"""
    zipcode: NotRequired[str]
    r"""The zipcode of the building"""
    city: NotRequired[str]
    r"""The city of the building"""
    state: NotRequired[str]
    r"""The state of the building"""
    building_id: NotRequired[int]
    r"""The ID of the building"""


class Address(BaseModel):
    r"""The physical address of the property"""

    street_address: Annotated[Optional[str], pydantic.Field(alias="streetAddress")] = (
        None
    )
    r"""The street address of the building"""

    zipcode: Optional[str] = None
    r"""The zipcode of the building"""

    city: Optional[str] = None
    r"""The city of the building"""

    state: Optional[str] = None
    r"""The state of the building"""

    building_id: Annotated[Optional[int], pydantic.Field(alias="buildingId")] = None
    r"""The ID of the building"""


class ZillowPropertyTypedDict(TypedDict):
    property_id: NotRequired[int]
    r"""Unique identifier for the property"""
    address: NotRequired[AddressTypedDict]
    r"""The physical address of the property"""
    photos: NotRequired[List[str]]
    r"""List of photo URLs for the property"""
    bathrooms: NotRequired[Nullable[float]]
    r"""Number of bathrooms in the property"""
    bedrooms: NotRequired[Nullable[int]]
    r"""Number of bedrooms in the property"""
    living_area: NotRequired[Nullable[float]]
    r"""The living area of the property in square feet"""
    year_built: NotRequired[Nullable[int]]
    r"""The year the property was built"""
    property_type: NotRequired[str]
    r"""Type of the property (e.g. house, condo)"""
    listing_status: NotRequired[str]
    r"""Status of the listing (e.g. forSale, sold)"""
    days_on_zillow: NotRequired[Nullable[int]]
    r"""Number of days the property has been listed on Zillow"""
    price: NotRequired[float]
    r"""Listing price of the property"""
    zestimate: NotRequired[Nullable[float]]
    r"""Zillow's estimated value of the property"""
    rent_zestimate: NotRequired[Nullable[float]]
    r"""Zillow's estimated value of the rent for the property"""
    price_history: NotRequired[List[ZillowPriceHistoryEventTypedDict]]


class ZillowProperty(BaseModel):
    property_id: Optional[int] = None
    r"""Unique identifier for the property"""

    address: Optional[Address] = None
    r"""The physical address of the property"""

    photos: Optional[List[str]] = None
    r"""List of photo URLs for the property"""

    bathrooms: OptionalNullable[float] = UNSET
    r"""Number of bathrooms in the property"""

    bedrooms: OptionalNullable[int] = UNSET
    r"""Number of bedrooms in the property"""

    living_area: OptionalNullable[float] = UNSET
    r"""The living area of the property in square feet"""

    year_built: OptionalNullable[int] = UNSET
    r"""The year the property was built"""

    property_type: Optional[str] = None
    r"""Type of the property (e.g. house, condo)"""

    listing_status: Optional[str] = None
    r"""Status of the listing (e.g. forSale, sold)"""

    days_on_zillow: OptionalNullable[int] = UNSET
    r"""Number of days the property has been listed on Zillow"""

    price: Optional[float] = None
    r"""Listing price of the property"""

    zestimate: OptionalNullable[float] = UNSET
    r"""Zillow's estimated value of the property"""

    rent_zestimate: OptionalNullable[float] = UNSET
    r"""Zillow's estimated value of the rent for the property"""

    price_history: Optional[List[ZillowPriceHistoryEvent]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "property_id",
            "address",
            "photos",
            "bathrooms",
            "bedrooms",
            "living_area",
            "year_built",
            "property_type",
            "listing_status",
            "days_on_zillow",
            "price",
            "zestimate",
            "rent_zestimate",
            "price_history",
        ]
        nullable_fields = [
            "bathrooms",
            "bedrooms",
            "living_area",
            "year_built",
            "days_on_zillow",
            "zestimate",
            "rent_zestimate",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
