"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from exfunc.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ZillowPriceHistoryEventTypedDict(TypedDict):
    date_: NotRequired[str]
    r"""The date of the price change"""
    price: NotRequired[Nullable[float]]
    r"""The price of the property at the given date"""
    time_epoch: NotRequired[int]
    r"""Time of the price change in epoch format"""
    price_per_square_foot: NotRequired[Nullable[float]]
    r"""Price per square foot at the given date"""
    price_change_rate: NotRequired[float]
    r"""Rate of change in price over time"""
    event: NotRequired[str]
    r"""Description of the event (e.g., price increase, price decrease)"""
    source: NotRequired[str]
    r"""Source of the price history data"""
    is_rental: NotRequired[bool]
    r"""Indicates if the property is a rental"""


class ZillowPriceHistoryEvent(BaseModel):
    date_: Annotated[Optional[str], pydantic.Field(alias="date")] = None
    r"""The date of the price change"""

    price: OptionalNullable[float] = UNSET
    r"""The price of the property at the given date"""

    time_epoch: Optional[int] = None
    r"""Time of the price change in epoch format"""

    price_per_square_foot: OptionalNullable[float] = UNSET
    r"""Price per square foot at the given date"""

    price_change_rate: Optional[float] = None
    r"""Rate of change in price over time"""

    event: Optional[str] = None
    r"""Description of the event (e.g., price increase, price decrease)"""

    source: Optional[str] = None
    r"""Source of the price history data"""

    is_rental: Optional[bool] = None
    r"""Indicates if the property is a rental"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "date",
            "price",
            "time_epoch",
            "price_per_square_foot",
            "price_change_rate",
            "event",
            "source",
            "is_rental",
        ]
        nullable_fields = ["price", "price_per_square_foot"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
