"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from exfunc.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class FeedbackCountsTypedDict(TypedDict):
    useful: NotRequired[int]
    r"""Number of users who found the review useful"""
    funny: NotRequired[int]
    r"""Number of users who found the review funny"""
    cool: NotRequired[int]
    r"""Number of users who found the review cool"""


class FeedbackCounts(BaseModel):
    useful: Optional[int] = None
    r"""Number of users who found the review useful"""

    funny: Optional[int] = None
    r"""Number of users who found the review funny"""

    cool: Optional[int] = None
    r"""Number of users who found the review cool"""


class YelpReviewTypedDict(TypedDict):
    review_id: NotRequired[str]
    r"""Unique identifier for the review"""
    rating: NotRequired[float]
    r"""Rating given in the review"""
    photos: NotRequired[List[str]]
    r"""List of photo URLs associated with the review"""
    is_updated: NotRequired[bool]
    r"""Indicates if the review has been updated"""
    feedback_counts: NotRequired[FeedbackCountsTypedDict]
    created_time: NotRequired[datetime]
    r"""Timestamp when the review was created"""
    text: NotRequired[str]
    r"""The content of the review"""
    author_id: NotRequired[str]
    r"""Unique identifier for the review author"""
    author_name: NotRequired[str]
    r"""Name of the review author"""
    author_location: NotRequired[str]
    r"""Location of the review author"""
    author_link: NotRequired[str]
    r"""Link to the author's profile"""
    author_review_count: NotRequired[int]
    r"""Total number of reviews written by the author"""


class YelpReview(BaseModel):
    review_id: Optional[str] = None
    r"""Unique identifier for the review"""

    rating: Optional[float] = None
    r"""Rating given in the review"""

    photos: Optional[List[str]] = None
    r"""List of photo URLs associated with the review"""

    is_updated: Optional[bool] = None
    r"""Indicates if the review has been updated"""

    feedback_counts: Optional[FeedbackCounts] = None

    created_time: Optional[datetime] = None
    r"""Timestamp when the review was created"""

    text: Optional[str] = None
    r"""The content of the review"""

    author_id: Optional[str] = None
    r"""Unique identifier for the review author"""

    author_name: Optional[str] = None
    r"""Name of the review author"""

    author_location: Optional[str] = None
    r"""Location of the review author"""

    author_link: Optional[str] = None
    r"""Link to the author's profile"""

    author_review_count: Optional[int] = None
    r"""Total number of reviews written by the author"""
