"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from exfunc.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class TweetTypedDict(TypedDict):
    tweet_id: NotRequired[str]
    r"""Unique identifier for the tweet"""
    full_text: NotRequired[str]
    r"""The full text of the tweet"""
    created_at: NotRequired[str]
    r"""The timestamp when the tweet was created"""
    author_user_id: NotRequired[str]
    r"""The ID of the user who authored the tweet"""
    bookmark_count: NotRequired[int]
    r"""Number of times the tweet has been bookmarked"""
    reply_count: NotRequired[int]
    r"""Number of replies to the tweet"""
    retweet_count: NotRequired[int]
    r"""Number of times the tweet has been retweeted"""
    retweeted: NotRequired[bool]
    r"""Indicates if the tweet is a retweet"""
    urls: NotRequired[List[str]]
    r"""List of URLs included in the tweet"""


class Tweet(BaseModel):
    tweet_id: Optional[str] = None
    r"""Unique identifier for the tweet"""

    full_text: Optional[str] = None
    r"""The full text of the tweet"""

    created_at: Optional[str] = None
    r"""The timestamp when the tweet was created"""

    author_user_id: Optional[str] = None
    r"""The ID of the user who authored the tweet"""

    bookmark_count: Optional[int] = None
    r"""Number of times the tweet has been bookmarked"""

    reply_count: Optional[int] = None
    r"""Number of replies to the tweet"""

    retweet_count: Optional[int] = None
    r"""Number of times the tweet has been retweeted"""

    retweeted: Optional[bool] = None
    r"""Indicates if the tweet is a retweet"""

    urls: Optional[List[str]] = None
    r"""List of URLs included in the tweet"""
