"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .skyscannerairport import SkyScannerAirport, SkyScannerAirportTypedDict
from .skyscannersegment import SkyScannerSegment, SkyScannerSegmentTypedDict
from exfunc.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CarriersTypedDict(TypedDict):
    r"""The carrier information"""

    marketing: NotRequired[List[str]]
    r"""The list of marketing carriers (airlines)"""
    operating: NotRequired[List[str]]
    r"""The list of operating carriers (airlines)"""


class Carriers(BaseModel):
    r"""The carrier information"""

    marketing: Optional[List[str]] = None
    r"""The list of marketing carriers (airlines)"""

    operating: Optional[List[str]] = None
    r"""The list of operating carriers (airlines)"""


class SkyScannerLegTypedDict(TypedDict):
    origin: NotRequired[SkyScannerAirportTypedDict]
    r"""The airport information"""
    destination: NotRequired[SkyScannerAirportTypedDict]
    r"""The airport information"""
    duration_in_minutes: NotRequired[float]
    r"""Duration of the leg in minutes"""
    stop_count: NotRequired[float]
    r"""The number of stops for the leg"""
    departure_time: NotRequired[str]
    r"""The departure time of the leg"""
    arrival_time: NotRequired[str]
    r"""The arrival time of the leg"""
    time_delta_in_days: NotRequired[float]
    r"""The time delta in days between the departure and the arrival"""
    carriers: NotRequired[CarriersTypedDict]
    r"""The carrier information"""
    segments: NotRequired[List[SkyScannerSegmentTypedDict]]
    r"""The list of segments for the leg"""


class SkyScannerLeg(BaseModel):
    origin: Optional[SkyScannerAirport] = None
    r"""The airport information"""

    destination: Optional[SkyScannerAirport] = None
    r"""The airport information"""

    duration_in_minutes: Optional[float] = None
    r"""Duration of the leg in minutes"""

    stop_count: Optional[float] = None
    r"""The number of stops for the leg"""

    departure_time: Optional[str] = None
    r"""The departure time of the leg"""

    arrival_time: Optional[str] = None
    r"""The arrival time of the leg"""

    time_delta_in_days: Optional[float] = None
    r"""The time delta in days between the departure and the arrival"""

    carriers: Optional[Carriers] = None
    r"""The carrier information"""

    segments: Optional[List[SkyScannerSegment]] = None
    r"""The list of segments for the leg"""
