"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .zillowproperty import ZillowProperty, ZillowPropertyTypedDict
from enum import Enum
from exfunc.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ListingStatus(str, Enum):
    r"""The status of the listings (e.g., \"for_sale\", \"for_rent\")"""

    FOR_SALE = "for_sale"
    FOR_RENT = "for_rent"
    SOLD = "sold"


class SearchPropertiesSortBy(str, Enum):
    r"""The criteria to sort the results (e.g., \"newest\", \"lot_size\")"""

    HOMES_FOR_YOU = "homes_for_you"
    RENTAL_PRIORITY_SCORE = "rental_priority_score"
    PRICE_HIGH_TO_LOW = "price_high_to_low"
    PRICE_LOW_TO_HIGH = "price_low_to_high"
    NEWEST = "newest"
    BEDROOMS = "bedrooms"
    BATHROOMS = "bathrooms"
    SQUARE_FEET = "square_feet"
    LOT_SIZE = "lot_size"
    YEAR_BUILT = "year_built"


class MinNumBedrooms(str, Enum):
    r"""The minimum number of bedrooms"""

    ANY = "any"
    STUDIO = "studio"
    ONE = "1"
    TWO = "2"
    THREE = "3"
    FOUR = "4"
    FIVE = "5"


class MaxNumBedrooms(str, Enum):
    r"""The maximum number of bedrooms"""

    ANY = "any"
    STUDIO = "studio"
    ONE = "1"
    TWO = "2"
    THREE = "3"
    FOUR = "4"
    FIVE = "5"


class SearchPropertiesRequestBodyTypedDict(TypedDict):
    location: str
    r"""The location to search for properties"""
    listing_status: ListingStatus
    r"""The status of the listings (e.g., \"for_sale\", \"for_rent\")"""
    sort_by: NotRequired[SearchPropertiesSortBy]
    r"""The criteria to sort the results (e.g., \"newest\", \"lot_size\")"""
    page: NotRequired[int]
    r"""The page number of results to retrieve"""
    min_listing_price: NotRequired[float]
    r"""The minimum listing price for the properties"""
    max_listing_price: NotRequired[float]
    r"""The maximum listing price for the properties"""
    min_num_bedrooms: NotRequired[MinNumBedrooms]
    r"""The minimum number of bedrooms"""
    max_num_bedrooms: NotRequired[MaxNumBedrooms]
    r"""The maximum number of bedrooms"""


class SearchPropertiesRequestBody(BaseModel):
    location: str
    r"""The location to search for properties"""

    listing_status: ListingStatus
    r"""The status of the listings (e.g., \"for_sale\", \"for_rent\")"""

    sort_by: Optional[SearchPropertiesSortBy] = None
    r"""The criteria to sort the results (e.g., \"newest\", \"lot_size\")"""

    page: Optional[int] = None
    r"""The page number of results to retrieve"""

    min_listing_price: Optional[float] = None
    r"""The minimum listing price for the properties"""

    max_listing_price: Optional[float] = None
    r"""The maximum listing price for the properties"""

    min_num_bedrooms: Optional[MinNumBedrooms] = None
    r"""The minimum number of bedrooms"""

    max_num_bedrooms: Optional[MaxNumBedrooms] = None
    r"""The maximum number of bedrooms"""


class SearchPropertiesResponseBodyTypedDict(TypedDict):
    r"""SearchProperties API successful response"""

    properties: NotRequired[List[ZillowPropertyTypedDict]]


class SearchPropertiesResponseBody(BaseModel):
    r"""SearchProperties API successful response"""

    properties: Optional[List[ZillowProperty]] = None
