"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .linkedincompanyindustry import LinkedInCompanyIndustry
from .linkedincompanysize import LinkedInCompanySize
from .linkedinperson import LinkedInPerson, LinkedInPersonTypedDict
from enum import Enum
from exfunc.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class Seniorities(str, Enum):
    OWNER = "owner"
    FOUNDER = "founder"
    C_SUITE = "c_suite"
    PARTNER = "partner"
    VP = "vp"
    HEAD = "head"
    DIRECTOR = "director"
    MANAGER = "manager"
    SENIOR = "senior"
    ENTRY = "entry"
    INTERN = "intern"


class SearchPeopleRequestBodyTypedDict(TypedDict):
    keywords: NotRequired[str]
    r"""Keywords to search for in people profiles"""
    locations: NotRequired[List[str]]
    r"""List of locations to filter the search"""
    titles: NotRequired[List[str]]
    r"""List of job titles to filter the search"""
    seniorities: NotRequired[List[Seniorities]]
    r"""List of seniority levels to filter the search"""
    company_sizes: NotRequired[List[LinkedInCompanySize]]
    r"""List of company size ranges to filter the search"""
    company_industries: NotRequired[List[LinkedInCompanyIndustry]]
    r"""List of company industry tags to filter the search"""
    company_domains: NotRequired[List[str]]
    r"""List of company domains to filter the search"""
    page: NotRequired[int]
    r"""Page number for pagination (default is 1)"""


class SearchPeopleRequestBody(BaseModel):
    keywords: Optional[str] = None
    r"""Keywords to search for in people profiles"""

    locations: Optional[List[str]] = None
    r"""List of locations to filter the search"""

    titles: Optional[List[str]] = None
    r"""List of job titles to filter the search"""

    seniorities: Optional[List[Seniorities]] = None
    r"""List of seniority levels to filter the search"""

    company_sizes: Optional[List[LinkedInCompanySize]] = None
    r"""List of company size ranges to filter the search"""

    company_industries: Optional[List[LinkedInCompanyIndustry]] = None
    r"""List of company industry tags to filter the search"""

    company_domains: Optional[List[str]] = None
    r"""List of company domains to filter the search"""

    page: Optional[int] = None
    r"""Page number for pagination (default is 1)"""


class SearchPeopleResponseBodyTypedDict(TypedDict):
    r"""SearchPeople API successful response"""

    people: NotRequired[List[LinkedInPersonTypedDict]]


class SearchPeopleResponseBody(BaseModel):
    r"""SearchPeople API successful response"""

    people: Optional[List[LinkedInPerson]] = None
