"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .linkedincompanyindustry import LinkedInCompanyIndustry
from .linkedincompanysize import LinkedInCompanySize
from exfunc.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class SearchCompaniesRequestBodyTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The name of the company to search for"""
    locations: NotRequired[List[str]]
    r"""List of locations to filter the search"""
    sizes: NotRequired[List[LinkedInCompanySize]]
    r"""List of company sizes to filter the search"""
    industries: NotRequired[List[LinkedInCompanyIndustry]]
    r"""List of industry tags to filter the search"""
    page: NotRequired[int]
    r"""Page number for pagination (default is 1)"""


class SearchCompaniesRequestBody(BaseModel):
    name: Optional[str] = None
    r"""The name of the company to search for"""

    locations: Optional[List[str]] = None
    r"""List of locations to filter the search"""

    sizes: Optional[List[LinkedInCompanySize]] = None
    r"""List of company sizes to filter the search"""

    industries: Optional[List[LinkedInCompanyIndustry]] = None
    r"""List of industry tags to filter the search"""

    page: Optional[int] = None
    r"""Page number for pagination (default is 1)"""


class CompaniesTypedDict(TypedDict):
    url: NotRequired[Nullable[str]]
    r"""URL to the company's profile"""
    uid: NotRequired[Nullable[str]]
    r"""LinkedIn uid"""
    name: NotRequired[str]
    r"""Name of the company"""
    website_url: NotRequired[Nullable[str]]
    r"""Company's website URL"""


class Companies(BaseModel):
    url: OptionalNullable[str] = UNSET
    r"""URL to the company's profile"""

    uid: OptionalNullable[str] = UNSET
    r"""LinkedIn uid"""

    name: Optional[str] = None
    r"""Name of the company"""

    website_url: OptionalNullable[str] = UNSET
    r"""Company's website URL"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["url", "uid", "name", "website_url"]
        nullable_fields = ["url", "uid", "website_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SearchCompaniesResponseBodyTypedDict(TypedDict):
    r"""SearchCompanies API successful response"""

    companies: NotRequired[List[CompaniesTypedDict]]


class SearchCompaniesResponseBody(BaseModel):
    r"""SearchCompanies API successful response"""

    companies: Optional[List[Companies]] = None
