"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from exfunc.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TotalRoundsTypedDict(TypedDict):
    r"""Total rounds of funding information"""

    count: NotRequired[Nullable[int]]
    r"""Number of funding rounds"""
    url: NotRequired[Nullable[str]]
    r"""URL of source"""


class TotalRounds(BaseModel):
    r"""Total rounds of funding information"""

    count: OptionalNullable[int] = UNSET
    r"""Number of funding rounds"""

    url: OptionalNullable[str] = UNSET
    r"""URL of source"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["count", "url"]
        nullable_fields = ["count", "url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LastRoundTypedDict(TypedDict):
    r"""Last round of funding information"""

    stage: NotRequired[Nullable[str]]
    r"""Stage of last funding round"""
    date_: NotRequired[Nullable[str]]
    r"""Date of last funding round"""
    amount: NotRequired[Nullable[str]]
    r"""Amount of last funding round"""
    url: NotRequired[Nullable[str]]
    r"""URL of source"""


class LastRound(BaseModel):
    r"""Last round of funding information"""

    stage: OptionalNullable[str] = UNSET
    r"""Stage of last funding round"""

    date_: Annotated[OptionalNullable[str], pydantic.Field(alias="date")] = UNSET
    r"""Date of last funding round"""

    amount: OptionalNullable[str] = UNSET
    r"""Amount of last funding round"""

    url: OptionalNullable[str] = UNSET
    r"""URL of source"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["stage", "date", "amount", "url"]
        nullable_fields = ["stage", "date", "amount", "url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class InvestorsTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""Name of investor"""
    url: NotRequired[Nullable[str]]
    r"""URL of source"""


class Investors(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""Name of investor"""

    url: OptionalNullable[str] = UNSET
    r"""URL of source"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "url"]
        nullable_fields = ["name", "url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FundingTypedDict(TypedDict):
    r"""Funding information for the company"""

    total_rounds: NotRequired[TotalRoundsTypedDict]
    r"""Total rounds of funding information"""
    last_round: NotRequired[LastRoundTypedDict]
    r"""Last round of funding information"""
    investors: NotRequired[List[InvestorsTypedDict]]
    r"""List of investors"""


class Funding(BaseModel):
    r"""Funding information for the company"""

    total_rounds: Optional[TotalRounds] = None
    r"""Total rounds of funding information"""

    last_round: Optional[LastRound] = None
    r"""Last round of funding information"""

    investors: Optional[List[Investors]] = None
    r"""List of investors"""


class LinkedInCompanyTypedDict(TypedDict):
    url: NotRequired[str]
    r"""URL to the company's profile"""
    name: NotRequired[str]
    r"""Name of the company"""
    location: NotRequired[str]
    r"""Location of the company"""
    industry: NotRequired[str]
    r"""Industry in which the company operates"""
    overview: NotRequired[str]
    r"""Overview or description of the company"""
    size: NotRequired[str]
    r"""Size of the company (e.g., number of employees)"""
    specialties: NotRequired[str]
    r"""Commma separated string of specialties or areas of expertise for the company"""
    website_url: NotRequired[str]
    r"""Company's website URL"""
    funding: NotRequired[FundingTypedDict]
    r"""Funding information for the company"""


class LinkedInCompany(BaseModel):
    url: Optional[str] = None
    r"""URL to the company's profile"""

    name: Optional[str] = None
    r"""Name of the company"""

    location: Optional[str] = None
    r"""Location of the company"""

    industry: Optional[str] = None
    r"""Industry in which the company operates"""

    overview: Optional[str] = None
    r"""Overview or description of the company"""

    size: Optional[str] = None
    r"""Size of the company (e.g., number of employees)"""

    specialties: Optional[str] = None
    r"""Commma separated string of specialties or areas of expertise for the company"""

    website_url: Optional[str] = None
    r"""Company's website URL"""

    funding: Optional[Funding] = None
    r"""Funding information for the company"""
