"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from exfunc.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class GoogleNewsTypedDict(TypedDict):
    title: NotRequired[str]
    r"""The title of the news article"""
    link: NotRequired[str]
    r"""The URL link to the news article"""
    snippet: NotRequired[Nullable[str]]
    r"""A brief snippet or summary of the news article"""
    photo_url: NotRequired[Nullable[str]]
    r"""The URL of the photo associated with the news article"""
    published_datetime_utc: NotRequired[datetime]
    r"""The publication date and time in UTC"""
    source_url: NotRequired[str]
    r"""The URL of the source website"""
    source_name: NotRequired[str]
    r"""The name of the news source"""


class GoogleNews(BaseModel):
    title: Optional[str] = None
    r"""The title of the news article"""

    link: Optional[str] = None
    r"""The URL link to the news article"""

    snippet: OptionalNullable[str] = UNSET
    r"""A brief snippet or summary of the news article"""

    photo_url: OptionalNullable[str] = UNSET
    r"""The URL of the photo associated with the news article"""

    published_datetime_utc: Optional[datetime] = None
    r"""The publication date and time in UTC"""

    source_url: Optional[str] = None
    r"""The URL of the source website"""

    source_name: Optional[str] = None
    r"""The name of the news source"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "link",
            "snippet",
            "photo_url",
            "published_datetime_utc",
            "source_url",
            "source_name",
        ]
        nullable_fields = ["snippet", "photo_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
