![Tests](https://github.com/mvaliev/cdftpy/actions/workflows/tests.yaml/badge.svg)

## CDFTPY: Python package for performing classical density functional theory calculations for molecular liquids 
#### Marat Valiev and Gennady Chuev
___
#### Quick Start:
___

Standard RISM calculation can be run as

    cdft1d -m rism <input_file>

RSDFT calculation can be run as

    cdft1d -m rsdft <input_file>

where <input_file> is the optional input file. An example of the latter 
for simulation of ion solvation in two-site water model is given below

     <solute>
     # site   sigma        eps(kj/mol)    charge(e)    x   y   z
     Cl       4.83         0.05349244     -1.0         0.0 0.0 0.0
     <simulation>
     solvent s2
     tol 1.0E-7
     max_iter 200
     rmax 100
     
     #optional analysis
     <analysis>
     rdf_peaks
     <output>
     rdf

In the absence of the input file, the calculation will attempt to 
generate on interactively

___
#### General usage:
___
    cdft1d [OPTIONS] [INPUT_FILE]



    Options:
      -m, --method [rism|rsdft]
      Defines calculation method, with rsdft as a default

      -s, --solvent <solvent_model>
      Defines solvent_model with default as s2. 
      Other avaialble models include hcl, n2, hcl_neutral.
      An additional model restricted to RISM is spce.

      -d, --dashboard [filename]      
        Generate dashboard for analysis. 
        The dashboard will be saved under the [filename] if provided, 
        otherwise it will be open in browser window

      -r --range [charge|sigma|eps] <values>
        Run calculation over the range of solute "charge","sigma",or "eps" 
        parameter values. Values could specified as array, e.g. [0,0.5,...] 
        or in triplets notation [start]:stop:nsteps

      --version                  display version
      --help                     Show this message and exit.
      --version                  display version


___
#### References:
___
G.N. Chuev, M. V. Fedotova and M. Valiev,
 Renormalized site density functional theory,
 J. Stat. Mech. (2021) 033205, https://doi.org/10.1088/1742-5468/abdeb3

G.N. Chuev, M. V. Fedotova and M. Valiev,
Chemical bond effects in classical site density 
functional theory of inhomogeneous molecular liquids. 
J. Chem Phys. 2020 Jan 31;152(4):041101,
https://doi.org/10.1063/1.5139619

M. Valiev and G.N. Chuev,
 Site density models of inhomogeneous classical molecular liquids,
 J. Stat. Mech. (2018) 093201,
https://doi.org/10.1088/1742-5468/aad6bf

 
 
