from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.lang


class AlreadyBoundException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

_MarshalledObject__T = _py_TypeVar('_MarshalledObject__T')  # <T>
class MarshalledObject(java.io.Serializable, _py_Generic[_MarshalledObject__T]):
    def __init__(self, t: _MarshalledObject__T): ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self) -> _MarshalledObject__T: ...
    def hashCode(self) -> int: ...

class Naming:
    @classmethod
    def bind(cls, string: str, remote: 'Remote') -> None: ...
    @classmethod
    def list(cls, string: str) -> _py_List[str]: ...
    @classmethod
    def lookup(cls, string: str) -> 'Remote': ...
    @classmethod
    def rebind(cls, string: str, remote: 'Remote') -> None: ...
    @classmethod
    def unbind(cls, string: str) -> None: ...

class NotBoundException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class RMISecurityException(java.lang.SecurityException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...

class RMISecurityManager(java.lang.SecurityManager):
    def __init__(self): ...

class Remote: ...

class RemoteException(java.io.IOException):
    detail: java.lang.Throwable = ...
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    def getCause(self) -> java.lang.Throwable: ...
    def getMessage(self) -> str: ...

class AccessException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class ConnectException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class ConnectIOException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class MarshalException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class NoSuchObjectException(RemoteException):
    def __init__(self, string: str): ...

class ServerError(RemoteException):
    def __init__(self, string: str, error: java.lang.Error): ...

class ServerException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class ServerRuntimeException(RemoteException):
    def __init__(self, string: str, exception: java.lang.Exception): ...

class StubNotFoundException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class UnexpectedException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class UnknownHostException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class UnmarshalException(RemoteException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...
