from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.lang
import java.net
import java.nio.channels
import java.nio.charset
import java.nio.file.attribute
import java.nio.file.spi
import java.security
import java.util
import java.util.concurrent
import java.util.function
import java.util.stream


class AccessMode(java.lang.Enum['AccessMode']):
    READ: _py_ClassVar['AccessMode'] = ...
    WRITE: _py_ClassVar['AccessMode'] = ...
    EXECUTE: _py_ClassVar['AccessMode'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'AccessMode': ...
    @classmethod
    def values(cls) -> _py_List['AccessMode']: ...

class ClosedDirectoryStreamException(java.lang.IllegalStateException):
    def __init__(self): ...

class ClosedFileSystemException(java.lang.IllegalStateException):
    def __init__(self): ...

class ClosedWatchServiceException(java.lang.IllegalStateException):
    def __init__(self): ...

class CopyMoveHelper: ...

class CopyOption: ...

class DirectoryIteratorException(java.util.ConcurrentModificationException):
    def __init__(self, iOException: java.io.IOException): ...
    @overload
    def getCause(self) -> java.io.IOException: ...
    @overload
    def getCause(self) -> java.lang.Throwable: ...

_DirectoryStream__Filter__T = _py_TypeVar('_DirectoryStream__Filter__T')  # <T>
_DirectoryStream__T = _py_TypeVar('_DirectoryStream__T')  # <T>
class DirectoryStream(java.io.Closeable, java.lang.Iterable[_DirectoryStream__T], _py_Generic[_DirectoryStream__T]):
    def iterator(self) -> java.util.Iterator[_DirectoryStream__T]: ...
    class Filter(_py_Generic[_DirectoryStream__Filter__T]):
        def accept(self, t: _DirectoryStream__Filter__T) -> bool: ...

class FileStore:
    def getAttribute(self, string: str) -> _py_Any: ...
    _getFileStoreAttributeView__V = _py_TypeVar('_getFileStoreAttributeView__V', bound=java.nio.file.attribute.FileStoreAttributeView)  # <V>
    def getFileStoreAttributeView(self, class_: _py_Type[_getFileStoreAttributeView__V]) -> _getFileStoreAttributeView__V: ...
    def getTotalSpace(self) -> int: ...
    def getUnallocatedSpace(self) -> int: ...
    def getUsableSpace(self) -> int: ...
    def isReadOnly(self) -> bool: ...
    def name(self) -> str: ...
    @overload
    def supportsFileAttributeView(self, class_: _py_Type[java.nio.file.attribute.FileAttributeView]) -> bool: ...
    @overload
    def supportsFileAttributeView(self, string: str) -> bool: ...
    def type(self) -> str: ...

class FileSystem(java.io.Closeable):
    def close(self) -> None: ...
    def getFileStores(self) -> java.lang.Iterable[FileStore]: ...
    def getPath(self, string: str, stringArray: _py_List[str]) -> 'Path': ...
    def getPathMatcher(self, string: str) -> 'PathMatcher': ...
    def getRootDirectories(self) -> java.lang.Iterable['Path']: ...
    def getSeparator(self) -> str: ...
    def getUserPrincipalLookupService(self) -> java.nio.file.attribute.UserPrincipalLookupService: ...
    def isOpen(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def newWatchService(self) -> 'WatchService': ...
    def provider(self) -> java.nio.file.spi.FileSystemProvider: ...
    def supportedFileAttributeViews(self) -> java.util.Set[str]: ...

class FileSystemAlreadyExistsException(java.lang.RuntimeException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class FileSystemException(java.io.IOException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...
    def getFile(self) -> str: ...
    def getMessage(self) -> str: ...
    def getOtherFile(self) -> str: ...
    def getReason(self) -> str: ...

class FileSystemNotFoundException(java.lang.RuntimeException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class FileSystems:
    @classmethod
    def getDefault(cls) -> FileSystem: ...
    @classmethod
    def getFileSystem(cls, uRI: java.net.URI) -> FileSystem: ...
    @classmethod
    @overload
    def newFileSystem(cls, uRI: java.net.URI, map: java.util.Map[str, _py_Any]) -> FileSystem: ...
    @classmethod
    @overload
    def newFileSystem(cls, uRI: java.net.URI, map: java.util.Map[str, _py_Any], classLoader: java.lang.ClassLoader) -> FileSystem: ...
    @classmethod
    @overload
    def newFileSystem(cls, path: 'Path', classLoader: java.lang.ClassLoader) -> FileSystem: ...

class FileTreeIterator(java.util.Iterator['FileTreeWalker.Event'], java.io.Closeable):
    def close(self) -> None: ...
    def hasNext(self) -> bool: ...
    @overload
    def next(self) -> _py_Any: ...
    @overload
    def next(self) -> 'FileTreeWalker.Event': ...

class FileTreeWalker(java.io.Closeable):
    def close(self) -> None: ...
    class Event: ...

class FileVisitOption(java.lang.Enum['FileVisitOption']):
    FOLLOW_LINKS: _py_ClassVar['FileVisitOption'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'FileVisitOption': ...
    @classmethod
    def values(cls) -> _py_List['FileVisitOption']: ...

class FileVisitResult(java.lang.Enum['FileVisitResult']):
    CONTINUE: _py_ClassVar['FileVisitResult'] = ...
    TERMINATE: _py_ClassVar['FileVisitResult'] = ...
    SKIP_SUBTREE: _py_ClassVar['FileVisitResult'] = ...
    SKIP_SIBLINGS: _py_ClassVar['FileVisitResult'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'FileVisitResult': ...
    @classmethod
    def values(cls) -> _py_List['FileVisitResult']: ...

_FileVisitor__T = _py_TypeVar('_FileVisitor__T')  # <T>
class FileVisitor(_py_Generic[_FileVisitor__T]):
    def postVisitDirectory(self, t: _FileVisitor__T, iOException: java.io.IOException) -> FileVisitResult: ...
    def preVisitDirectory(self, t: _FileVisitor__T, basicFileAttributes: java.nio.file.attribute.BasicFileAttributes) -> FileVisitResult: ...
    def visitFile(self, t: _FileVisitor__T, basicFileAttributes: java.nio.file.attribute.BasicFileAttributes) -> FileVisitResult: ...
    def visitFileFailed(self, t: _FileVisitor__T, iOException: java.io.IOException) -> FileVisitResult: ...

class Files:
    @classmethod
    @overload
    def copy(cls, path: 'Path', path2: 'Path', copyOptionArray: _py_List[CopyOption]) -> 'Path': ...
    @classmethod
    @overload
    def copy(cls, inputStream: java.io.InputStream, path: 'Path', copyOptionArray: _py_List[CopyOption]) -> int: ...
    @classmethod
    @overload
    def copy(cls, path: 'Path', outputStream: java.io.OutputStream) -> int: ...
    @classmethod
    def createDirectories(cls, path: 'Path', fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    def createDirectory(cls, path: 'Path', fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    def createFile(cls, path: 'Path', fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    def createLink(cls, path: 'Path', path2: 'Path') -> 'Path': ...
    @classmethod
    def createSymbolicLink(cls, path: 'Path', path2: 'Path', fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    @overload
    def createTempDirectory(cls, string: str, fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    @overload
    def createTempDirectory(cls, path: 'Path', string: str, fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    @overload
    def createTempFile(cls, string: str, string2: str, fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    @overload
    def createTempFile(cls, path: 'Path', string: str, string2: str, fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> 'Path': ...
    @classmethod
    def delete(cls, path: 'Path') -> None: ...
    @classmethod
    def deleteIfExists(cls, path: 'Path') -> bool: ...
    @classmethod
    def exists(cls, path: 'Path', linkOptionArray: _py_List['LinkOption']) -> bool: ...
    @classmethod
    def find(cls, path: 'Path', int: int, biPredicate: java.util.function.BiPredicate['Path', java.nio.file.attribute.BasicFileAttributes], fileVisitOptionArray: _py_List[FileVisitOption]) -> java.util.stream.Stream['Path']: ...
    @classmethod
    def getAttribute(cls, path: 'Path', string: str, linkOptionArray: _py_List['LinkOption']) -> _py_Any: ...
    _getFileAttributeView__V = _py_TypeVar('_getFileAttributeView__V', bound=java.nio.file.attribute.FileAttributeView)  # <V>
    @classmethod
    def getFileAttributeView(cls, path: 'Path', class_: _py_Type[_getFileAttributeView__V], linkOptionArray: _py_List['LinkOption']) -> _getFileAttributeView__V: ...
    @classmethod
    def getFileStore(cls, path: 'Path') -> FileStore: ...
    @classmethod
    def getLastModifiedTime(cls, path: 'Path', linkOptionArray: _py_List['LinkOption']) -> java.nio.file.attribute.FileTime: ...
    @classmethod
    def getOwner(cls, path: 'Path', linkOptionArray: _py_List['LinkOption']) -> java.nio.file.attribute.UserPrincipal: ...
    @classmethod
    def getPosixFilePermissions(cls, path: 'Path', linkOptionArray: _py_List['LinkOption']) -> java.util.Set[java.nio.file.attribute.PosixFilePermission]: ...
    @classmethod
    def isDirectory(cls, path: 'Path', linkOptionArray: _py_List['LinkOption']) -> bool: ...
    @classmethod
    def isExecutable(cls, path: 'Path') -> bool: ...
    @classmethod
    def isHidden(cls, path: 'Path') -> bool: ...
    @classmethod
    def isReadable(cls, path: 'Path') -> bool: ...
    @classmethod
    def isRegularFile(cls, path: 'Path', linkOptionArray: _py_List['LinkOption']) -> bool: ...
    @classmethod
    def isSameFile(cls, path: 'Path', path2: 'Path') -> bool: ...
    @classmethod
    def isSymbolicLink(cls, path: 'Path') -> bool: ...
    @classmethod
    def isWritable(cls, path: 'Path') -> bool: ...
    @classmethod
    @overload
    def lines(cls, path: 'Path') -> java.util.stream.Stream[str]: ...
    @classmethod
    @overload
    def lines(cls, path: 'Path', charset: java.nio.charset.Charset) -> java.util.stream.Stream[str]: ...
    @classmethod
    def list(cls, path: 'Path') -> java.util.stream.Stream['Path']: ...
    @classmethod
    def move(cls, path: 'Path', path2: 'Path', copyOptionArray: _py_List[CopyOption]) -> 'Path': ...
    @classmethod
    @overload
    def newBufferedReader(cls, path: 'Path') -> java.io.BufferedReader: ...
    @classmethod
    @overload
    def newBufferedReader(cls, path: 'Path', charset: java.nio.charset.Charset) -> java.io.BufferedReader: ...
    @classmethod
    @overload
    def newBufferedWriter(cls, path: 'Path', charset: java.nio.charset.Charset, openOptionArray: _py_List['OpenOption']) -> java.io.BufferedWriter: ...
    @classmethod
    @overload
    def newBufferedWriter(cls, path: 'Path', openOptionArray: _py_List['OpenOption']) -> java.io.BufferedWriter: ...
    @classmethod
    @overload
    def newByteChannel(cls, path: 'Path', openOptionArray: _py_List['OpenOption']) -> java.nio.channels.SeekableByteChannel: ...
    @classmethod
    @overload
    def newByteChannel(cls, path: 'Path', set: java.util.Set['OpenOption'], fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> java.nio.channels.SeekableByteChannel: ...
    @classmethod
    @overload
    def newDirectoryStream(cls, path: 'Path') -> DirectoryStream['Path']: ...
    @classmethod
    @overload
    def newDirectoryStream(cls, path: 'Path', string: str) -> DirectoryStream['Path']: ...
    @classmethod
    @overload
    def newDirectoryStream(cls, path: 'Path', filter: DirectoryStream.Filter['Path']) -> DirectoryStream['Path']: ...
    @classmethod
    def newInputStream(cls, path: 'Path', openOptionArray: _py_List['OpenOption']) -> java.io.InputStream: ...
    @classmethod
    def newOutputStream(cls, path: 'Path', openOptionArray: _py_List['OpenOption']) -> java.io.OutputStream: ...
    @classmethod
    def notExists(cls, path: 'Path', linkOptionArray: _py_List['LinkOption']) -> bool: ...
    @classmethod
    def probeContentType(cls, path: 'Path') -> str: ...
    @classmethod
    def readAllBytes(cls, path: 'Path') -> _py_List[int]: ...
    @classmethod
    @overload
    def readAllLines(cls, path: 'Path') -> java.util.List[str]: ...
    @classmethod
    @overload
    def readAllLines(cls, path: 'Path', charset: java.nio.charset.Charset) -> java.util.List[str]: ...
    _readAttributes_0__A = _py_TypeVar('_readAttributes_0__A', bound=java.nio.file.attribute.BasicFileAttributes)  # <A>
    @classmethod
    @overload
    def readAttributes(cls, path: 'Path', class_: _py_Type[_readAttributes_0__A], linkOptionArray: _py_List['LinkOption']) -> _readAttributes_0__A: ...
    @classmethod
    @overload
    def readAttributes(cls, path: 'Path', string: str, linkOptionArray: _py_List['LinkOption']) -> java.util.Map[str, _py_Any]: ...
    @classmethod
    def readSymbolicLink(cls, path: 'Path') -> 'Path': ...
    @classmethod
    def setAttribute(cls, path: 'Path', string: str, object: _py_Any, linkOptionArray: _py_List['LinkOption']) -> 'Path': ...
    @classmethod
    def setLastModifiedTime(cls, path: 'Path', fileTime: java.nio.file.attribute.FileTime) -> 'Path': ...
    @classmethod
    def setOwner(cls, path: 'Path', userPrincipal: java.nio.file.attribute.UserPrincipal) -> 'Path': ...
    @classmethod
    def setPosixFilePermissions(cls, path: 'Path', set: java.util.Set[java.nio.file.attribute.PosixFilePermission]) -> 'Path': ...
    @classmethod
    def size(cls, path: 'Path') -> int: ...
    @classmethod
    @overload
    def walk(cls, path: 'Path', int: int, fileVisitOptionArray: _py_List[FileVisitOption]) -> java.util.stream.Stream['Path']: ...
    @classmethod
    @overload
    def walk(cls, path: 'Path', fileVisitOptionArray: _py_List[FileVisitOption]) -> java.util.stream.Stream['Path']: ...
    @classmethod
    @overload
    def walkFileTree(cls, path: 'Path', fileVisitor: FileVisitor['Path']) -> 'Path': ...
    @classmethod
    @overload
    def walkFileTree(cls, path: 'Path', set: java.util.Set[FileVisitOption], int: int, fileVisitor: FileVisitor['Path']) -> 'Path': ...
    @classmethod
    @overload
    def write(cls, path: 'Path', byteArray: _py_List[int], openOptionArray: _py_List['OpenOption']) -> 'Path': ...
    @classmethod
    @overload
    def write(cls, path: 'Path', iterable: java.lang.Iterable[java.lang.CharSequence], charset: java.nio.charset.Charset, openOptionArray: _py_List['OpenOption']) -> 'Path': ...
    @classmethod
    @overload
    def write(cls, path: 'Path', iterable: java.lang.Iterable[java.lang.CharSequence], openOptionArray: _py_List['OpenOption']) -> 'Path': ...

class InvalidPathException(java.lang.IllegalArgumentException):
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, int: int): ...
    def getIndex(self) -> int: ...
    def getInput(self) -> str: ...
    def getMessage(self) -> str: ...
    def getReason(self) -> str: ...

class LinkPermission(java.security.BasicPermission):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...

class OpenOption: ...

class PathMatcher:
    def matches(self, path: 'Path') -> bool: ...

class Paths:
    @classmethod
    @overload
    def get(cls, string: str, stringArray: _py_List[str]) -> 'Path': ...
    @classmethod
    @overload
    def get(cls, uRI: java.net.URI) -> 'Path': ...

class ProviderMismatchException(java.lang.IllegalArgumentException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class ProviderNotFoundException(java.lang.RuntimeException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...

class ReadOnlyFileSystemException(java.lang.UnsupportedOperationException):
    def __init__(self): ...

class StandardWatchEventKinds:
    OVERFLOW: _py_ClassVar['WatchEvent.Kind'] = ...
    ENTRY_CREATE: _py_ClassVar['WatchEvent.Kind'] = ...
    ENTRY_DELETE: _py_ClassVar['WatchEvent.Kind'] = ...
    ENTRY_MODIFY: _py_ClassVar['WatchEvent.Kind'] = ...

class TempFileHelper: ...

_WatchEvent__Kind__T = _py_TypeVar('_WatchEvent__Kind__T')  # <T>
_WatchEvent__T = _py_TypeVar('_WatchEvent__T')  # <T>
class WatchEvent(_py_Generic[_WatchEvent__T]):
    def context(self) -> _WatchEvent__T: ...
    def count(self) -> int: ...
    def kind(self) -> 'WatchEvent.Kind'[_WatchEvent__T]: ...
    class Kind(_py_Generic[_WatchEvent__Kind__T]):
        def name(self) -> str: ...
        def type(self) -> _py_Type[_WatchEvent__Kind__T]: ...
    class Modifier:
        def name(self) -> str: ...

class WatchKey:
    def cancel(self) -> None: ...
    def isValid(self) -> bool: ...
    def pollEvents(self) -> java.util.List[WatchEvent[_py_Any]]: ...
    def reset(self) -> bool: ...
    def watchable(self) -> 'Watchable': ...

class WatchService(java.io.Closeable):
    def close(self) -> None: ...
    @overload
    def poll(self) -> WatchKey: ...
    @overload
    def poll(self, long: int, timeUnit: java.util.concurrent.TimeUnit) -> WatchKey: ...
    def take(self) -> WatchKey: ...

class Watchable:
    @overload
    def register(self, watchService: WatchService, kindArray: _py_List[WatchEvent.Kind[_py_Any]]) -> WatchKey: ...
    @overload
    def register(self, watchService: WatchService, kindArray: _py_List[WatchEvent.Kind[_py_Any]], modifierArray: _py_List[WatchEvent.Modifier]) -> WatchKey: ...

class AccessDeniedException(FileSystemException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...

class AtomicMoveNotSupportedException(FileSystemException):
    def __init__(self, string: str, string2: str, string3: str): ...

class DirectoryNotEmptyException(FileSystemException):
    def __init__(self, string: str): ...

class FileAlreadyExistsException(FileSystemException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...

class FileSystemLoopException(FileSystemException):
    def __init__(self, string: str): ...

class LinkOption(java.lang.Enum['LinkOption'], OpenOption, CopyOption):
    NOFOLLOW_LINKS: _py_ClassVar['LinkOption'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'LinkOption': ...
    @classmethod
    def values(cls) -> _py_List['LinkOption']: ...

class NoSuchFileException(FileSystemException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...

class NotDirectoryException(FileSystemException):
    def __init__(self, string: str): ...

class NotLinkException(FileSystemException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...

class Path(java.lang.Comparable['Path'], java.lang.Iterable['Path'], Watchable):
    @overload
    def compareTo(self, path: 'Path') -> int: ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def endsWith(self, string: str) -> bool: ...
    @overload
    def endsWith(self, path: 'Path') -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getFileName(self) -> 'Path': ...
    def getFileSystem(self) -> FileSystem: ...
    def getName(self, int: int) -> 'Path': ...
    def getNameCount(self) -> int: ...
    def getParent(self) -> 'Path': ...
    def getRoot(self) -> 'Path': ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def iterator(self) -> java.util.Iterator['Path']: ...
    def normalize(self) -> 'Path': ...
    @overload
    def register(self, watchService: WatchService, kindArray: _py_List[WatchEvent.Kind[_py_Any]]) -> WatchKey: ...
    @overload
    def register(self, watchService: WatchService, kindArray: _py_List[WatchEvent.Kind[_py_Any]], modifierArray: _py_List[WatchEvent.Modifier]) -> WatchKey: ...
    def relativize(self, path: 'Path') -> 'Path': ...
    @overload
    def resolve(self, string: str) -> 'Path': ...
    @overload
    def resolve(self, path: 'Path') -> 'Path': ...
    @overload
    def resolveSibling(self, string: str) -> 'Path': ...
    @overload
    def resolveSibling(self, path: 'Path') -> 'Path': ...
    @overload
    def startsWith(self, string: str) -> bool: ...
    @overload
    def startsWith(self, path: 'Path') -> bool: ...
    def subpath(self, int: int, int2: int) -> 'Path': ...
    def toAbsolutePath(self) -> 'Path': ...
    def toFile(self) -> java.io.File: ...
    def toRealPath(self, linkOptionArray: _py_List[LinkOption]) -> 'Path': ...
    def toString(self) -> str: ...
    def toUri(self) -> java.net.URI: ...

_SecureDirectoryStream__T = _py_TypeVar('_SecureDirectoryStream__T')  # <T>
class SecureDirectoryStream(DirectoryStream[_SecureDirectoryStream__T], _py_Generic[_SecureDirectoryStream__T]):
    def deleteDirectory(self, t: _SecureDirectoryStream__T) -> None: ...
    def deleteFile(self, t: _SecureDirectoryStream__T) -> None: ...
    _getFileAttributeView_0__V = _py_TypeVar('_getFileAttributeView_0__V', bound=java.nio.file.attribute.FileAttributeView)  # <V>
    @overload
    def getFileAttributeView(self, class_: _py_Type[_getFileAttributeView_0__V]) -> _getFileAttributeView_0__V: ...
    _getFileAttributeView_1__V = _py_TypeVar('_getFileAttributeView_1__V', bound=java.nio.file.attribute.FileAttributeView)  # <V>
    @overload
    def getFileAttributeView(self, t: _SecureDirectoryStream__T, class_: _py_Type[_getFileAttributeView_1__V], linkOptionArray: _py_List[LinkOption]) -> _getFileAttributeView_1__V: ...
    def move(self, t: _SecureDirectoryStream__T, secureDirectoryStream: 'SecureDirectoryStream'[_SecureDirectoryStream__T], t2: _SecureDirectoryStream__T) -> None: ...
    def newByteChannel(self, t: _SecureDirectoryStream__T, set: java.util.Set[OpenOption], fileAttributeArray: _py_List[java.nio.file.attribute.FileAttribute[_py_Any]]) -> java.nio.channels.SeekableByteChannel: ...
    def newDirectoryStream(self, t: _SecureDirectoryStream__T, linkOptionArray: _py_List[LinkOption]) -> 'SecureDirectoryStream'[_SecureDirectoryStream__T]: ...

_SimpleFileVisitor__T = _py_TypeVar('_SimpleFileVisitor__T')  # <T>
class SimpleFileVisitor(FileVisitor[_SimpleFileVisitor__T], _py_Generic[_SimpleFileVisitor__T]):
    def postVisitDirectory(self, t: _SimpleFileVisitor__T, iOException: java.io.IOException) -> FileVisitResult: ...
    def preVisitDirectory(self, t: _SimpleFileVisitor__T, basicFileAttributes: java.nio.file.attribute.BasicFileAttributes) -> FileVisitResult: ...
    def visitFile(self, t: _SimpleFileVisitor__T, basicFileAttributes: java.nio.file.attribute.BasicFileAttributes) -> FileVisitResult: ...
    def visitFileFailed(self, t: _SimpleFileVisitor__T, iOException: java.io.IOException) -> FileVisitResult: ...

class StandardCopyOption(java.lang.Enum['StandardCopyOption'], CopyOption):
    REPLACE_EXISTING: _py_ClassVar['StandardCopyOption'] = ...
    COPY_ATTRIBUTES: _py_ClassVar['StandardCopyOption'] = ...
    ATOMIC_MOVE: _py_ClassVar['StandardCopyOption'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'StandardCopyOption': ...
    @classmethod
    def values(cls) -> _py_List['StandardCopyOption']: ...

class StandardOpenOption(java.lang.Enum['StandardOpenOption'], OpenOption):
    READ: _py_ClassVar['StandardOpenOption'] = ...
    WRITE: _py_ClassVar['StandardOpenOption'] = ...
    APPEND: _py_ClassVar['StandardOpenOption'] = ...
    TRUNCATE_EXISTING: _py_ClassVar['StandardOpenOption'] = ...
    CREATE: _py_ClassVar['StandardOpenOption'] = ...
    CREATE_NEW: _py_ClassVar['StandardOpenOption'] = ...
    DELETE_ON_CLOSE: _py_ClassVar['StandardOpenOption'] = ...
    SPARSE: _py_ClassVar['StandardOpenOption'] = ...
    SYNC: _py_ClassVar['StandardOpenOption'] = ...
    DSYNC: _py_ClassVar['StandardOpenOption'] = ...
    _valueOf_0__T = _py_TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'StandardOpenOption': ...
    @classmethod
    def values(cls) -> _py_List['StandardOpenOption']: ...
