from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.lang
import java.util
import java.util.function
import java.util.stream
import sun.misc
import sun.nio.ch


class Bits: ...

class Buffer:
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def capacity(self) -> int: ...
    def clear(self) -> 'Buffer': ...
    def flip(self) -> 'Buffer': ...
    def hasArray(self) -> bool: ...
    def hasRemaining(self) -> bool: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @overload
    def limit(self) -> int: ...
    @overload
    def limit(self, int: int) -> 'Buffer': ...
    def mark(self) -> 'Buffer': ...
    @overload
    def position(self) -> int: ...
    @overload
    def position(self, int: int) -> 'Buffer': ...
    def remaining(self) -> int: ...
    def reset(self) -> 'Buffer': ...
    def rewind(self) -> 'Buffer': ...

class BufferOverflowException(java.lang.RuntimeException):
    def __init__(self): ...

class BufferUnderflowException(java.lang.RuntimeException):
    def __init__(self): ...

class ByteOrder:
    BIG_ENDIAN: _py_ClassVar['ByteOrder'] = ...
    LITTLE_ENDIAN: _py_ClassVar['ByteOrder'] = ...
    @classmethod
    def nativeOrder(cls) -> 'ByteOrder': ...
    def toString(self) -> str: ...

class CharBufferSpliterator(java.util.Spliterator.OfInt):
    def characteristics(self) -> int: ...
    def estimateSize(self) -> int: ...
    @overload
    def forEachRemaining(self, consumer: java.util.function.Consumer[int]) -> None: ...
    @overload
    def forEachRemaining(self, object: _py_Any) -> None: ...
    @overload
    def forEachRemaining(self, intConsumer: java.util.function.IntConsumer) -> None: ...
    @overload
    def tryAdvance(self, object: _py_Any) -> bool: ...
    @overload
    def tryAdvance(self, intConsumer: java.util.function.IntConsumer) -> bool: ...
    @overload
    def tryAdvance(self, consumer: java.util.function.Consumer[int]) -> bool: ...
    @overload
    def trySplit(self) -> java.util.Spliterator: ...
    @overload
    def trySplit(self) -> java.util.Spliterator.OfInt: ...
    @overload
    def trySplit(self) -> java.util.Spliterator.OfPrimitive: ...

class InvalidMarkException(java.lang.IllegalStateException):
    def __init__(self): ...

class ReadOnlyBufferException(java.lang.UnsupportedOperationException):
    def __init__(self): ...

class ByteBuffer(Buffer, java.lang.Comparable['ByteBuffer']):
    @classmethod
    def allocate(cls, int: int) -> 'ByteBuffer': ...
    @classmethod
    def allocateDirect(cls, int: int) -> 'ByteBuffer': ...
    @overload
    def array(self) -> _py_List[int]: ...
    @overload
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def asCharBuffer(self) -> 'CharBuffer': ...
    def asDoubleBuffer(self) -> 'DoubleBuffer': ...
    def asFloatBuffer(self) -> 'FloatBuffer': ...
    def asIntBuffer(self) -> 'IntBuffer': ...
    def asLongBuffer(self) -> 'LongBuffer': ...
    def asReadOnlyBuffer(self) -> 'ByteBuffer': ...
    def asShortBuffer(self) -> 'ShortBuffer': ...
    def compact(self) -> 'ByteBuffer': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, byteBuffer: 'ByteBuffer') -> int: ...
    def duplicate(self) -> 'ByteBuffer': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, byteArray: _py_List[int]) -> 'ByteBuffer': ...
    @overload
    def get(self, byteArray: _py_List[int], int: int, int2: int) -> 'ByteBuffer': ...
    @overload
    def getChar(self) -> str: ...
    @overload
    def getChar(self, int: int) -> str: ...
    @overload
    def getDouble(self) -> float: ...
    @overload
    def getDouble(self, int: int) -> float: ...
    @overload
    def getFloat(self) -> float: ...
    @overload
    def getFloat(self, int: int) -> float: ...
    @overload
    def getInt(self) -> int: ...
    @overload
    def getInt(self, int: int) -> int: ...
    @overload
    def getLong(self) -> int: ...
    @overload
    def getLong(self, int: int) -> int: ...
    @overload
    def getShort(self) -> int: ...
    @overload
    def getShort(self, int: int) -> int: ...
    def hasArray(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDirect(self) -> bool: ...
    @overload
    def order(self, byteOrder: ByteOrder) -> 'ByteBuffer': ...
    @overload
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, byte: int) -> 'ByteBuffer': ...
    @overload
    def put(self, int: int, byte: int) -> 'ByteBuffer': ...
    @overload
    def put(self, byteArray: _py_List[int]) -> 'ByteBuffer': ...
    @overload
    def put(self, byteArray: _py_List[int], int: int, int2: int) -> 'ByteBuffer': ...
    @overload
    def put(self, byteBuffer: 'ByteBuffer') -> 'ByteBuffer': ...
    @overload
    def putChar(self, char: str) -> 'ByteBuffer': ...
    @overload
    def putChar(self, int: int, char: str) -> 'ByteBuffer': ...
    @overload
    def putDouble(self, double: float) -> 'ByteBuffer': ...
    @overload
    def putDouble(self, int: int, double: float) -> 'ByteBuffer': ...
    @overload
    def putFloat(self, float: float) -> 'ByteBuffer': ...
    @overload
    def putFloat(self, int: int, float: float) -> 'ByteBuffer': ...
    @overload
    def putInt(self, int: int) -> 'ByteBuffer': ...
    @overload
    def putInt(self, int: int, int2: int) -> 'ByteBuffer': ...
    @overload
    def putLong(self, int: int, long: int) -> 'ByteBuffer': ...
    @overload
    def putLong(self, long: int) -> 'ByteBuffer': ...
    @overload
    def putShort(self, int: int, short: int) -> 'ByteBuffer': ...
    @overload
    def putShort(self, short: int) -> 'ByteBuffer': ...
    def slice(self) -> 'ByteBuffer': ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def wrap(cls, byteArray: _py_List[int]) -> 'ByteBuffer': ...
    @classmethod
    @overload
    def wrap(cls, byteArray: _py_List[int], int: int, int2: int) -> 'ByteBuffer': ...

class CharBuffer(Buffer, java.lang.Comparable['CharBuffer'], java.lang.Appendable, java.lang.CharSequence, java.lang.Readable):
    @classmethod
    def allocate(cls, int: int) -> 'CharBuffer': ...
    @overload
    def append(self, char: str) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> java.lang.Appendable: ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> java.lang.Appendable: ...
    @overload
    def append(self, char: str) -> 'CharBuffer': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence) -> 'CharBuffer': ...
    @overload
    def append(self, charSequence: java.lang.CharSequence, int: int, int2: int) -> 'CharBuffer': ...
    @overload
    def array(self) -> _py_List[str]: ...
    @overload
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def asReadOnlyBuffer(self) -> 'CharBuffer': ...
    def charAt(self, int: int) -> str: ...
    def chars(self) -> java.util.stream.IntStream: ...
    def compact(self) -> 'CharBuffer': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, charBuffer: 'CharBuffer') -> int: ...
    def duplicate(self) -> 'CharBuffer': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self) -> str: ...
    @overload
    def get(self, int: int) -> str: ...
    @overload
    def get(self, charArray: _py_List[str]) -> 'CharBuffer': ...
    @overload
    def get(self, charArray: _py_List[str], int: int, int2: int) -> 'CharBuffer': ...
    def hasArray(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDirect(self) -> bool: ...
    def length(self) -> int: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, char: str) -> 'CharBuffer': ...
    @overload
    def put(self, int: int, char: str) -> 'CharBuffer': ...
    @overload
    def put(self, charArray: _py_List[str]) -> 'CharBuffer': ...
    @overload
    def put(self, string: str) -> 'CharBuffer': ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> 'CharBuffer': ...
    @overload
    def put(self, string: str, int: int, int2: int) -> 'CharBuffer': ...
    @overload
    def put(self, charBuffer: 'CharBuffer') -> 'CharBuffer': ...
    def read(self, charBuffer: 'CharBuffer') -> int: ...
    def slice(self) -> 'CharBuffer': ...
    @overload
    def subSequence(self, int: int, int2: int) -> 'CharBuffer': ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def wrap(cls, charArray: _py_List[str]) -> 'CharBuffer': ...
    @classmethod
    @overload
    def wrap(cls, charArray: _py_List[str], int: int, int2: int) -> 'CharBuffer': ...
    @classmethod
    @overload
    def wrap(cls, charSequence: java.lang.CharSequence) -> 'CharBuffer': ...
    @classmethod
    @overload
    def wrap(cls, charSequence: java.lang.CharSequence, int: int, int2: int) -> 'CharBuffer': ...

class DoubleBuffer(Buffer, java.lang.Comparable['DoubleBuffer']):
    @classmethod
    def allocate(cls, int: int) -> 'DoubleBuffer': ...
    @overload
    def array(self) -> _py_List[float]: ...
    @overload
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def asReadOnlyBuffer(self) -> 'DoubleBuffer': ...
    def compact(self) -> 'DoubleBuffer': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, doubleBuffer: 'DoubleBuffer') -> int: ...
    def duplicate(self) -> 'DoubleBuffer': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, doubleArray: _py_List[float]) -> 'DoubleBuffer': ...
    @overload
    def get(self, doubleArray: _py_List[float], int: int, int2: int) -> 'DoubleBuffer': ...
    def hasArray(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDirect(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, double: float) -> 'DoubleBuffer': ...
    @overload
    def put(self, int: int, double: float) -> 'DoubleBuffer': ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> 'DoubleBuffer': ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> 'DoubleBuffer': ...
    @overload
    def put(self, doubleBuffer: 'DoubleBuffer') -> 'DoubleBuffer': ...
    def slice(self) -> 'DoubleBuffer': ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def wrap(cls, doubleArray: _py_List[float]) -> 'DoubleBuffer': ...
    @classmethod
    @overload
    def wrap(cls, doubleArray: _py_List[float], int: int, int2: int) -> 'DoubleBuffer': ...

class FloatBuffer(Buffer, java.lang.Comparable['FloatBuffer']):
    @classmethod
    def allocate(cls, int: int) -> 'FloatBuffer': ...
    @overload
    def array(self) -> _py_List[float]: ...
    @overload
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def asReadOnlyBuffer(self) -> 'FloatBuffer': ...
    def compact(self) -> 'FloatBuffer': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, floatBuffer: 'FloatBuffer') -> int: ...
    def duplicate(self) -> 'FloatBuffer': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, floatArray: _py_List[float]) -> 'FloatBuffer': ...
    @overload
    def get(self, floatArray: _py_List[float], int: int, int2: int) -> 'FloatBuffer': ...
    def hasArray(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDirect(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, float: float) -> 'FloatBuffer': ...
    @overload
    def put(self, int: int, float: float) -> 'FloatBuffer': ...
    @overload
    def put(self, floatArray: _py_List[float]) -> 'FloatBuffer': ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> 'FloatBuffer': ...
    @overload
    def put(self, floatBuffer: 'FloatBuffer') -> 'FloatBuffer': ...
    def slice(self) -> 'FloatBuffer': ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def wrap(cls, floatArray: _py_List[float]) -> 'FloatBuffer': ...
    @classmethod
    @overload
    def wrap(cls, floatArray: _py_List[float], int: int, int2: int) -> 'FloatBuffer': ...

class IntBuffer(Buffer, java.lang.Comparable['IntBuffer']):
    @classmethod
    def allocate(cls, int: int) -> 'IntBuffer': ...
    @overload
    def array(self) -> _py_List[int]: ...
    @overload
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def asReadOnlyBuffer(self) -> 'IntBuffer': ...
    def compact(self) -> 'IntBuffer': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, intBuffer: 'IntBuffer') -> int: ...
    def duplicate(self) -> 'IntBuffer': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, intArray: _py_List[int]) -> 'IntBuffer': ...
    @overload
    def get(self, intArray: _py_List[int], int2: int, int3: int) -> 'IntBuffer': ...
    def hasArray(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDirect(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, int: int) -> 'IntBuffer': ...
    @overload
    def put(self, int: int, int2: int) -> 'IntBuffer': ...
    @overload
    def put(self, intArray: _py_List[int]) -> 'IntBuffer': ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> 'IntBuffer': ...
    @overload
    def put(self, intBuffer: 'IntBuffer') -> 'IntBuffer': ...
    def slice(self) -> 'IntBuffer': ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def wrap(cls, intArray: _py_List[int]) -> 'IntBuffer': ...
    @classmethod
    @overload
    def wrap(cls, intArray: _py_List[int], int2: int, int3: int) -> 'IntBuffer': ...

class LongBuffer(Buffer, java.lang.Comparable['LongBuffer']):
    @classmethod
    def allocate(cls, int: int) -> 'LongBuffer': ...
    @overload
    def array(self) -> _py_List[int]: ...
    @overload
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def asReadOnlyBuffer(self) -> 'LongBuffer': ...
    def compact(self) -> 'LongBuffer': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, longBuffer: 'LongBuffer') -> int: ...
    def duplicate(self) -> 'LongBuffer': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, longArray: _py_List[int]) -> 'LongBuffer': ...
    @overload
    def get(self, longArray: _py_List[int], int: int, int2: int) -> 'LongBuffer': ...
    def hasArray(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDirect(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, int: int, long: int) -> 'LongBuffer': ...
    @overload
    def put(self, long: int) -> 'LongBuffer': ...
    @overload
    def put(self, longArray: _py_List[int]) -> 'LongBuffer': ...
    @overload
    def put(self, longBuffer: 'LongBuffer') -> 'LongBuffer': ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> 'LongBuffer': ...
    def slice(self) -> 'LongBuffer': ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def wrap(cls, longArray: _py_List[int]) -> 'LongBuffer': ...
    @classmethod
    @overload
    def wrap(cls, longArray: _py_List[int], int: int, int2: int) -> 'LongBuffer': ...

class ShortBuffer(Buffer, java.lang.Comparable['ShortBuffer']):
    @classmethod
    def allocate(cls, int: int) -> 'ShortBuffer': ...
    @overload
    def array(self) -> _py_List[int]: ...
    @overload
    def array(self) -> _py_Any: ...
    def arrayOffset(self) -> int: ...
    def asReadOnlyBuffer(self) -> 'ShortBuffer': ...
    def compact(self) -> 'ShortBuffer': ...
    @overload
    def compareTo(self, object: _py_Any) -> int: ...
    @overload
    def compareTo(self, shortBuffer: 'ShortBuffer') -> int: ...
    def duplicate(self) -> 'ShortBuffer': ...
    def equals(self, object: _py_Any) -> bool: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, shortArray: _py_List[int]) -> 'ShortBuffer': ...
    @overload
    def get(self, shortArray: _py_List[int], int: int, int2: int) -> 'ShortBuffer': ...
    def hasArray(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDirect(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, int: int, short: int) -> 'ShortBuffer': ...
    @overload
    def put(self, short: int) -> 'ShortBuffer': ...
    @overload
    def put(self, shortArray: _py_List[int]) -> 'ShortBuffer': ...
    @overload
    def put(self, shortBuffer: 'ShortBuffer') -> 'ShortBuffer': ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> 'ShortBuffer': ...
    def slice(self) -> 'ShortBuffer': ...
    def toString(self) -> str: ...
    @classmethod
    @overload
    def wrap(cls, shortArray: _py_List[int]) -> 'ShortBuffer': ...
    @classmethod
    @overload
    def wrap(cls, shortArray: _py_List[int], int: int, int2: int) -> 'ShortBuffer': ...

class ByteBufferAsCharBufferB(CharBuffer):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    @overload
    def get(self) -> str: ...
    @overload
    def get(self, int: int) -> str: ...
    @overload
    def get(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def get(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...
    @overload
    def toString(self) -> str: ...

class ByteBufferAsCharBufferL(CharBuffer):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    @overload
    def get(self) -> str: ...
    @overload
    def get(self, int: int) -> str: ...
    @overload
    def get(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def get(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...
    @overload
    def toString(self) -> str: ...

class ByteBufferAsDoubleBufferB(DoubleBuffer):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def get(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class ByteBufferAsDoubleBufferL(DoubleBuffer):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def get(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class ByteBufferAsFloatBufferB(FloatBuffer):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def get(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class ByteBufferAsFloatBufferL(FloatBuffer):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def get(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class ByteBufferAsIntBufferB(IntBuffer):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def get(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class ByteBufferAsIntBufferL(IntBuffer):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def get(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class ByteBufferAsLongBufferB(LongBuffer):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class ByteBufferAsLongBufferL(LongBuffer):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class ByteBufferAsShortBufferB(ShortBuffer):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class ByteBufferAsShortBufferL(ShortBuffer):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class DirectCharBufferS(CharBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    @overload
    def get(self) -> str: ...
    @overload
    def get(self, int: int) -> str: ...
    @overload
    def get(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def get(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self) -> str: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...

class DirectCharBufferU(CharBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    @overload
    def get(self) -> str: ...
    @overload
    def get(self, int: int) -> str: ...
    @overload
    def get(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def get(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self) -> str: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...

class DirectDoubleBufferS(DoubleBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def get(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class DirectDoubleBufferU(DoubleBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def get(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class DirectFloatBufferS(FloatBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def get(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class DirectFloatBufferU(FloatBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def get(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class DirectIntBufferS(IntBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def get(self, intArray: _py_List[int]) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class DirectIntBufferU(IntBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def get(self, intArray: _py_List[int]) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class DirectLongBufferS(LongBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class DirectLongBufferU(LongBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class DirectShortBufferS(ShortBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class DirectShortBufferU(ShortBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class HeapByteBuffer(ByteBuffer):
    def asCharBuffer(self) -> CharBuffer: ...
    def asDoubleBuffer(self) -> DoubleBuffer: ...
    def asFloatBuffer(self) -> FloatBuffer: ...
    def asIntBuffer(self) -> IntBuffer: ...
    def asLongBuffer(self) -> LongBuffer: ...
    def asReadOnlyBuffer(self) -> ByteBuffer: ...
    def asShortBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ByteBuffer: ...
    def duplicate(self) -> ByteBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, byteArray: _py_List[int]) -> ByteBuffer: ...
    @overload
    def get(self, byteArray: _py_List[int], int: int, int2: int) -> ByteBuffer: ...
    @overload
    def getChar(self) -> str: ...
    @overload
    def getChar(self, int: int) -> str: ...
    @overload
    def getDouble(self) -> float: ...
    @overload
    def getDouble(self, int: int) -> float: ...
    @overload
    def getFloat(self) -> float: ...
    @overload
    def getFloat(self, int: int) -> float: ...
    @overload
    def getInt(self) -> int: ...
    @overload
    def getInt(self, int: int) -> int: ...
    @overload
    def getLong(self) -> int: ...
    @overload
    def getLong(self, int: int) -> int: ...
    @overload
    def getShort(self) -> int: ...
    @overload
    def getShort(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @overload
    def put(self, byteArray: _py_List[int]) -> ByteBuffer: ...
    @overload
    def put(self, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteArray: _py_List[int], int: int, int2: int) -> ByteBuffer: ...
    @overload
    def put(self, int: int, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteBuffer: ByteBuffer) -> ByteBuffer: ...
    @overload
    def putChar(self, char: str) -> ByteBuffer: ...
    @overload
    def putChar(self, int: int, char: str) -> ByteBuffer: ...
    @overload
    def putDouble(self, double: float) -> ByteBuffer: ...
    @overload
    def putDouble(self, int: int, double: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, float: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, int: int, float: float) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int, int2: int) -> ByteBuffer: ...
    @overload
    def putLong(self, int: int, long: int) -> ByteBuffer: ...
    @overload
    def putLong(self, long: int) -> ByteBuffer: ...
    @overload
    def putShort(self, int: int, short: int) -> ByteBuffer: ...
    @overload
    def putShort(self, short: int) -> ByteBuffer: ...
    def slice(self) -> ByteBuffer: ...

class HeapCharBuffer(CharBuffer):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    @overload
    def get(self) -> str: ...
    @overload
    def get(self, int: int) -> str: ...
    @overload
    def get(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def get(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...

class HeapDoubleBuffer(DoubleBuffer):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def get(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class HeapFloatBuffer(FloatBuffer):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    @overload
    def get(self) -> float: ...
    @overload
    def get(self, int: int) -> float: ...
    @overload
    def get(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def get(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class HeapIntBuffer(IntBuffer):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def get(self, intArray: _py_List[int]) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class HeapLongBuffer(LongBuffer):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    @overload
    def get(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class HeapShortBuffer(ShortBuffer):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    @overload
    def get(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class MappedByteBuffer(ByteBuffer):
    def force(self) -> 'MappedByteBuffer': ...
    def isLoaded(self) -> bool: ...
    def load(self) -> 'MappedByteBuffer': ...

class StringCharBuffer(CharBuffer):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    @overload
    def get(self) -> str: ...
    @overload
    def get(self, int: int) -> str: ...
    @overload
    def get(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def get(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...

class ByteBufferAsCharBufferRB(ByteBufferAsCharBufferB):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...
    @overload
    def toString(self) -> str: ...

class ByteBufferAsCharBufferRL(ByteBufferAsCharBufferL):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...
    @overload
    def toString(self) -> str: ...

class ByteBufferAsDoubleBufferRB(ByteBufferAsDoubleBufferB):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class ByteBufferAsDoubleBufferRL(ByteBufferAsDoubleBufferL):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class ByteBufferAsFloatBufferRB(ByteBufferAsFloatBufferB):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class ByteBufferAsFloatBufferRL(ByteBufferAsFloatBufferL):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class ByteBufferAsIntBufferRB(ByteBufferAsIntBufferB):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class ByteBufferAsIntBufferRL(ByteBufferAsIntBufferL):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class ByteBufferAsLongBufferRB(ByteBufferAsLongBufferB):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class ByteBufferAsLongBufferRL(ByteBufferAsLongBufferL):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class ByteBufferAsShortBufferRB(ByteBufferAsShortBufferB):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class ByteBufferAsShortBufferRL(ByteBufferAsShortBufferL):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class DirectByteBuffer(MappedByteBuffer, sun.nio.ch.DirectBuffer):
    def address(self) -> int: ...
    def asCharBuffer(self) -> CharBuffer: ...
    def asDoubleBuffer(self) -> DoubleBuffer: ...
    def asFloatBuffer(self) -> FloatBuffer: ...
    def asIntBuffer(self) -> IntBuffer: ...
    def asLongBuffer(self) -> LongBuffer: ...
    def asReadOnlyBuffer(self) -> ByteBuffer: ...
    def asShortBuffer(self) -> ShortBuffer: ...
    def attachment(self) -> _py_Any: ...
    def cleaner(self) -> sun.misc.Cleaner: ...
    def compact(self) -> ByteBuffer: ...
    def duplicate(self) -> ByteBuffer: ...
    @overload
    def get(self) -> int: ...
    @overload
    def get(self, int: int) -> int: ...
    @overload
    def get(self, byteArray: _py_List[int]) -> ByteBuffer: ...
    @overload
    def get(self, byteArray: _py_List[int], int: int, int2: int) -> ByteBuffer: ...
    @overload
    def getChar(self) -> str: ...
    @overload
    def getChar(self, int: int) -> str: ...
    @overload
    def getDouble(self) -> float: ...
    @overload
    def getDouble(self, int: int) -> float: ...
    @overload
    def getFloat(self) -> float: ...
    @overload
    def getFloat(self, int: int) -> float: ...
    @overload
    def getInt(self) -> int: ...
    @overload
    def getInt(self, int: int) -> int: ...
    @overload
    def getLong(self) -> int: ...
    @overload
    def getLong(self, int: int) -> int: ...
    @overload
    def getShort(self) -> int: ...
    @overload
    def getShort(self, int: int) -> int: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @overload
    def put(self, byteArray: _py_List[int]) -> ByteBuffer: ...
    @overload
    def put(self, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteArray: _py_List[int], int: int, int2: int) -> ByteBuffer: ...
    @overload
    def put(self, int: int, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteBuffer: ByteBuffer) -> ByteBuffer: ...
    @overload
    def putChar(self, char: str) -> ByteBuffer: ...
    @overload
    def putChar(self, int: int, char: str) -> ByteBuffer: ...
    @overload
    def putDouble(self, double: float) -> ByteBuffer: ...
    @overload
    def putDouble(self, int: int, double: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, float: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, int: int, float: float) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int, int2: int) -> ByteBuffer: ...
    @overload
    def putLong(self, int: int, long: int) -> ByteBuffer: ...
    @overload
    def putLong(self, long: int) -> ByteBuffer: ...
    @overload
    def putShort(self, int: int, short: int) -> ByteBuffer: ...
    @overload
    def putShort(self, short: int) -> ByteBuffer: ...
    def slice(self) -> ByteBuffer: ...

class DirectCharBufferRS(DirectCharBufferS, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self) -> str: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...

class DirectCharBufferRU(DirectCharBufferU, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...
    @overload
    def toString(self) -> str: ...
    @overload
    def toString(self, int: int, int2: int) -> str: ...

class DirectDoubleBufferRS(DirectDoubleBufferS, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class DirectDoubleBufferRU(DirectDoubleBufferU, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class DirectFloatBufferRS(DirectFloatBufferS, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class DirectFloatBufferRU(DirectFloatBufferU, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class DirectIntBufferRS(DirectIntBufferS, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class DirectIntBufferRU(DirectIntBufferU, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class DirectLongBufferRS(DirectLongBufferS, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class DirectLongBufferRU(DirectLongBufferU, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class DirectShortBufferRS(DirectShortBufferS, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class DirectShortBufferRU(DirectShortBufferU, sun.nio.ch.DirectBuffer):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class HeapByteBufferR(HeapByteBuffer):
    def asCharBuffer(self) -> CharBuffer: ...
    def asDoubleBuffer(self) -> DoubleBuffer: ...
    def asFloatBuffer(self) -> FloatBuffer: ...
    def asIntBuffer(self) -> IntBuffer: ...
    def asLongBuffer(self) -> LongBuffer: ...
    def asReadOnlyBuffer(self) -> ByteBuffer: ...
    def asShortBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ByteBuffer: ...
    def duplicate(self) -> ByteBuffer: ...
    def isReadOnly(self) -> bool: ...
    @overload
    def put(self, byteArray: _py_List[int]) -> ByteBuffer: ...
    @overload
    def put(self, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteArray: _py_List[int], int: int, int2: int) -> ByteBuffer: ...
    @overload
    def put(self, int: int, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteBuffer: ByteBuffer) -> ByteBuffer: ...
    @overload
    def putChar(self, char: str) -> ByteBuffer: ...
    @overload
    def putChar(self, int: int, char: str) -> ByteBuffer: ...
    @overload
    def putDouble(self, double: float) -> ByteBuffer: ...
    @overload
    def putDouble(self, int: int, double: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, float: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, int: int, float: float) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int, int2: int) -> ByteBuffer: ...
    @overload
    def putLong(self, int: int, long: int) -> ByteBuffer: ...
    @overload
    def putLong(self, long: int) -> ByteBuffer: ...
    @overload
    def putShort(self, int: int, short: int) -> ByteBuffer: ...
    @overload
    def putShort(self, short: int) -> ByteBuffer: ...
    def slice(self) -> ByteBuffer: ...

class HeapCharBufferR(HeapCharBuffer):
    def asReadOnlyBuffer(self) -> CharBuffer: ...
    def compact(self) -> CharBuffer: ...
    def duplicate(self) -> CharBuffer: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, charArray: _py_List[str]) -> CharBuffer: ...
    @overload
    def put(self, string: str) -> CharBuffer: ...
    @overload
    def put(self, string: str, int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, char: str) -> CharBuffer: ...
    @overload
    def put(self, charArray: _py_List[str], int: int, int2: int) -> CharBuffer: ...
    @overload
    def put(self, int: int, char: str) -> CharBuffer: ...
    @overload
    def put(self, charBuffer: CharBuffer) -> CharBuffer: ...
    def slice(self) -> CharBuffer: ...
    @overload
    def subSequence(self, int: int, int2: int) -> java.lang.CharSequence: ...
    @overload
    def subSequence(self, int: int, int2: int) -> CharBuffer: ...

class HeapDoubleBufferR(HeapDoubleBuffer):
    def asReadOnlyBuffer(self) -> DoubleBuffer: ...
    def compact(self) -> DoubleBuffer: ...
    def duplicate(self) -> DoubleBuffer: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, doubleArray: _py_List[float]) -> DoubleBuffer: ...
    @overload
    def put(self, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleArray: _py_List[float], int: int, int2: int) -> DoubleBuffer: ...
    @overload
    def put(self, int: int, double: float) -> DoubleBuffer: ...
    @overload
    def put(self, doubleBuffer: DoubleBuffer) -> DoubleBuffer: ...
    def slice(self) -> DoubleBuffer: ...

class HeapFloatBufferR(HeapFloatBuffer):
    def asReadOnlyBuffer(self) -> FloatBuffer: ...
    def compact(self) -> FloatBuffer: ...
    def duplicate(self) -> FloatBuffer: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, floatArray: _py_List[float]) -> FloatBuffer: ...
    @overload
    def put(self, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatArray: _py_List[float], int: int, int2: int) -> FloatBuffer: ...
    @overload
    def put(self, int: int, float: float) -> FloatBuffer: ...
    @overload
    def put(self, floatBuffer: FloatBuffer) -> FloatBuffer: ...
    def slice(self) -> FloatBuffer: ...

class HeapIntBufferR(HeapIntBuffer):
    def asReadOnlyBuffer(self) -> IntBuffer: ...
    def compact(self) -> IntBuffer: ...
    def duplicate(self) -> IntBuffer: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, intArray: _py_List[int]) -> IntBuffer: ...
    @overload
    def put(self, int: int) -> IntBuffer: ...
    @overload
    def put(self, int: int, int2: int) -> IntBuffer: ...
    @overload
    def put(self, intArray: _py_List[int], int2: int, int3: int) -> IntBuffer: ...
    @overload
    def put(self, intBuffer: IntBuffer) -> IntBuffer: ...
    def slice(self) -> IntBuffer: ...

class HeapLongBufferR(HeapLongBuffer):
    def asReadOnlyBuffer(self) -> LongBuffer: ...
    def compact(self) -> LongBuffer: ...
    def duplicate(self) -> LongBuffer: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, longArray: _py_List[int]) -> LongBuffer: ...
    @overload
    def put(self, int: int, long: int) -> LongBuffer: ...
    @overload
    def put(self, longBuffer: LongBuffer) -> LongBuffer: ...
    @overload
    def put(self, long: int) -> LongBuffer: ...
    @overload
    def put(self, longArray: _py_List[int], int: int, int2: int) -> LongBuffer: ...
    def slice(self) -> LongBuffer: ...

class HeapShortBufferR(HeapShortBuffer):
    def asReadOnlyBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ShortBuffer: ...
    def duplicate(self) -> ShortBuffer: ...
    def isReadOnly(self) -> bool: ...
    def order(self) -> ByteOrder: ...
    @overload
    def put(self, shortArray: _py_List[int]) -> ShortBuffer: ...
    @overload
    def put(self, int: int, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortBuffer: ShortBuffer) -> ShortBuffer: ...
    @overload
    def put(self, short: int) -> ShortBuffer: ...
    @overload
    def put(self, shortArray: _py_List[int], int: int, int2: int) -> ShortBuffer: ...
    def slice(self) -> ShortBuffer: ...

class DirectByteBufferR(DirectByteBuffer, sun.nio.ch.DirectBuffer):
    def asCharBuffer(self) -> CharBuffer: ...
    def asDoubleBuffer(self) -> DoubleBuffer: ...
    def asFloatBuffer(self) -> FloatBuffer: ...
    def asIntBuffer(self) -> IntBuffer: ...
    def asLongBuffer(self) -> LongBuffer: ...
    def asReadOnlyBuffer(self) -> ByteBuffer: ...
    def asShortBuffer(self) -> ShortBuffer: ...
    def compact(self) -> ByteBuffer: ...
    def duplicate(self) -> ByteBuffer: ...
    def isDirect(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @overload
    def put(self, byteArray: _py_List[int]) -> ByteBuffer: ...
    @overload
    def put(self, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteArray: _py_List[int], int: int, int2: int) -> ByteBuffer: ...
    @overload
    def put(self, int: int, byte: int) -> ByteBuffer: ...
    @overload
    def put(self, byteBuffer: ByteBuffer) -> ByteBuffer: ...
    @overload
    def putChar(self, char: str) -> ByteBuffer: ...
    @overload
    def putChar(self, int: int, char: str) -> ByteBuffer: ...
    @overload
    def putDouble(self, double: float) -> ByteBuffer: ...
    @overload
    def putDouble(self, int: int, double: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, float: float) -> ByteBuffer: ...
    @overload
    def putFloat(self, int: int, float: float) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int) -> ByteBuffer: ...
    @overload
    def putInt(self, int: int, int2: int) -> ByteBuffer: ...
    @overload
    def putLong(self, int: int, long: int) -> ByteBuffer: ...
    @overload
    def putLong(self, long: int) -> ByteBuffer: ...
    @overload
    def putShort(self, int: int, short: int) -> ByteBuffer: ...
    @overload
    def putShort(self, short: int) -> ByteBuffer: ...
    def slice(self) -> ByteBuffer: ...
