from typing import Any as _py_Any
from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload


class FinalizerHistogram: ...

_Reference__T = _py_TypeVar('_Reference__T')  # <T>
class Reference(_py_Generic[_Reference__T]):
    def clear(self) -> None: ...
    def enqueue(self) -> bool: ...
    def get(self) -> _Reference__T: ...
    def isEnqueued(self) -> bool: ...

_ReferenceQueue__T = _py_TypeVar('_ReferenceQueue__T')  # <T>
class ReferenceQueue(_py_Generic[_ReferenceQueue__T]):
    def __init__(self): ...
    def poll(self) -> Reference[_ReferenceQueue__T]: ...
    @overload
    def remove(self) -> Reference[_ReferenceQueue__T]: ...
    @overload
    def remove(self, long: int) -> Reference[_ReferenceQueue__T]: ...

_FinalReference__T = _py_TypeVar('_FinalReference__T')  # <T>
class FinalReference(Reference[_FinalReference__T], _py_Generic[_FinalReference__T]):
    def __init__(self, t: _FinalReference__T, referenceQueue: ReferenceQueue[_FinalReference__T]): ...

_PhantomReference__T = _py_TypeVar('_PhantomReference__T')  # <T>
class PhantomReference(Reference[_PhantomReference__T], _py_Generic[_PhantomReference__T]):
    def __init__(self, t: _PhantomReference__T, referenceQueue: ReferenceQueue[_PhantomReference__T]): ...
    def get(self) -> _PhantomReference__T: ...

_SoftReference__T = _py_TypeVar('_SoftReference__T')  # <T>
class SoftReference(Reference[_SoftReference__T], _py_Generic[_SoftReference__T]):
    @overload
    def __init__(self, t: _SoftReference__T): ...
    @overload
    def __init__(self, t: _SoftReference__T, referenceQueue: ReferenceQueue[_SoftReference__T]): ...
    def get(self) -> _SoftReference__T: ...

_WeakReference__T = _py_TypeVar('_WeakReference__T')  # <T>
class WeakReference(Reference[_WeakReference__T], _py_Generic[_WeakReference__T]):
    @overload
    def __init__(self, t: _WeakReference__T): ...
    @overload
    def __init__(self, t: _WeakReference__T, referenceQueue: ReferenceQueue[_WeakReference__T]): ...

class Finalizer(FinalReference[_py_Any]): ...
