from typing import Any as _py_Any
from typing import ClassVar as _py_ClassVar
from typing import overload
import java.awt
import java.awt.font
import java.lang
import java.text
import java.util


class AWTEventListener(java.util.EventListener):
    def eventDispatched(self, aWTEvent: java.awt.AWTEvent) -> None: ...

class ActionEvent(java.awt.AWTEvent):
    SHIFT_MASK: _py_ClassVar[int] = ...
    CTRL_MASK: _py_ClassVar[int] = ...
    META_MASK: _py_ClassVar[int] = ...
    ALT_MASK: _py_ClassVar[int] = ...
    ACTION_FIRST: _py_ClassVar[int] = ...
    ACTION_LAST: _py_ClassVar[int] = ...
    ACTION_PERFORMED: _py_ClassVar[int] = ...
    @overload
    def __init__(self, object: _py_Any, int: int, string: str): ...
    @overload
    def __init__(self, object: _py_Any, int: int, string: str, int2: int): ...
    @overload
    def __init__(self, object: _py_Any, int: int, string: str, long: int, int2: int): ...
    def getActionCommand(self) -> str: ...
    def getModifiers(self) -> int: ...
    def getWhen(self) -> int: ...
    def paramString(self) -> str: ...

class ActionListener(java.util.EventListener):
    def actionPerformed(self, actionEvent: ActionEvent) -> None: ...

class AdjustmentEvent(java.awt.AWTEvent):
    ADJUSTMENT_FIRST: _py_ClassVar[int] = ...
    ADJUSTMENT_LAST: _py_ClassVar[int] = ...
    ADJUSTMENT_VALUE_CHANGED: _py_ClassVar[int] = ...
    UNIT_INCREMENT: _py_ClassVar[int] = ...
    UNIT_DECREMENT: _py_ClassVar[int] = ...
    BLOCK_DECREMENT: _py_ClassVar[int] = ...
    BLOCK_INCREMENT: _py_ClassVar[int] = ...
    TRACK: _py_ClassVar[int] = ...
    @overload
    def __init__(self, adjustable: java.awt.Adjustable, int: int, int2: int, int3: int): ...
    @overload
    def __init__(self, adjustable: java.awt.Adjustable, int: int, int2: int, int3: int, boolean: bool): ...
    def getAdjustable(self) -> java.awt.Adjustable: ...
    def getAdjustmentType(self) -> int: ...
    def getValue(self) -> int: ...
    def getValueIsAdjusting(self) -> bool: ...
    def paramString(self) -> str: ...

class AdjustmentListener(java.util.EventListener):
    def adjustmentValueChanged(self, adjustmentEvent: AdjustmentEvent) -> None: ...

class ComponentEvent(java.awt.AWTEvent):
    COMPONENT_FIRST: _py_ClassVar[int] = ...
    COMPONENT_LAST: _py_ClassVar[int] = ...
    COMPONENT_MOVED: _py_ClassVar[int] = ...
    COMPONENT_RESIZED: _py_ClassVar[int] = ...
    COMPONENT_SHOWN: _py_ClassVar[int] = ...
    COMPONENT_HIDDEN: _py_ClassVar[int] = ...
    def __init__(self, component: java.awt.Component, int: int): ...
    def getComponent(self) -> java.awt.Component: ...
    def paramString(self) -> str: ...

class ComponentListener(java.util.EventListener):
    def componentHidden(self, componentEvent: ComponentEvent) -> None: ...
    def componentMoved(self, componentEvent: ComponentEvent) -> None: ...
    def componentResized(self, componentEvent: ComponentEvent) -> None: ...
    def componentShown(self, componentEvent: ComponentEvent) -> None: ...

class ContainerListener(java.util.EventListener):
    def componentAdded(self, containerEvent: 'ContainerEvent') -> None: ...
    def componentRemoved(self, containerEvent: 'ContainerEvent') -> None: ...

class FocusListener(java.util.EventListener):
    def focusGained(self, focusEvent: 'FocusEvent') -> None: ...
    def focusLost(self, focusEvent: 'FocusEvent') -> None: ...

class HierarchyBoundsListener(java.util.EventListener):
    def ancestorMoved(self, hierarchyEvent: 'HierarchyEvent') -> None: ...
    def ancestorResized(self, hierarchyEvent: 'HierarchyEvent') -> None: ...

class HierarchyEvent(java.awt.AWTEvent):
    HIERARCHY_FIRST: _py_ClassVar[int] = ...
    HIERARCHY_CHANGED: _py_ClassVar[int] = ...
    ANCESTOR_MOVED: _py_ClassVar[int] = ...
    ANCESTOR_RESIZED: _py_ClassVar[int] = ...
    HIERARCHY_LAST: _py_ClassVar[int] = ...
    PARENT_CHANGED: _py_ClassVar[int] = ...
    DISPLAYABILITY_CHANGED: _py_ClassVar[int] = ...
    SHOWING_CHANGED: _py_ClassVar[int] = ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, component2: java.awt.Component, container: java.awt.Container): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, component2: java.awt.Component, container: java.awt.Container, long: int): ...
    def getChangeFlags(self) -> int: ...
    def getChanged(self) -> java.awt.Component: ...
    def getChangedParent(self) -> java.awt.Container: ...
    def getComponent(self) -> java.awt.Component: ...
    def paramString(self) -> str: ...

class HierarchyListener(java.util.EventListener):
    def hierarchyChanged(self, hierarchyEvent: HierarchyEvent) -> None: ...

class InputMethodEvent(java.awt.AWTEvent):
    INPUT_METHOD_FIRST: _py_ClassVar[int] = ...
    INPUT_METHOD_TEXT_CHANGED: _py_ClassVar[int] = ...
    CARET_POSITION_CHANGED: _py_ClassVar[int] = ...
    INPUT_METHOD_LAST: _py_ClassVar[int] = ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, textHitInfo: java.awt.font.TextHitInfo, textHitInfo2: java.awt.font.TextHitInfo): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, attributedCharacterIterator: java.text.AttributedCharacterIterator, int2: int, textHitInfo: java.awt.font.TextHitInfo, textHitInfo2: java.awt.font.TextHitInfo): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, attributedCharacterIterator: java.text.AttributedCharacterIterator, int2: int, textHitInfo: java.awt.font.TextHitInfo, textHitInfo2: java.awt.font.TextHitInfo): ...
    def consume(self) -> None: ...
    def getCaret(self) -> java.awt.font.TextHitInfo: ...
    def getCommittedCharacterCount(self) -> int: ...
    def getText(self) -> java.text.AttributedCharacterIterator: ...
    def getVisiblePosition(self) -> java.awt.font.TextHitInfo: ...
    def getWhen(self) -> int: ...
    def isConsumed(self) -> bool: ...
    def paramString(self) -> str: ...

class InputMethodListener(java.util.EventListener):
    def caretPositionChanged(self, inputMethodEvent: InputMethodEvent) -> None: ...
    def inputMethodTextChanged(self, inputMethodEvent: InputMethodEvent) -> None: ...

class InvocationEvent(java.awt.AWTEvent, java.awt.ActiveEvent):
    INVOCATION_FIRST: _py_ClassVar[int] = ...
    INVOCATION_DEFAULT: _py_ClassVar[int] = ...
    INVOCATION_LAST: _py_ClassVar[int] = ...
    @overload
    def __init__(self, object: _py_Any, runnable: java.lang.Runnable): ...
    @overload
    def __init__(self, object: _py_Any, runnable: java.lang.Runnable, object2: _py_Any, boolean: bool): ...
    @overload
    def __init__(self, object: _py_Any, runnable: java.lang.Runnable, runnable2: java.lang.Runnable, boolean: bool): ...
    def dispatch(self) -> None: ...
    def getException(self) -> java.lang.Exception: ...
    def getThrowable(self) -> java.lang.Throwable: ...
    def getWhen(self) -> int: ...
    def isDispatched(self) -> bool: ...
    def paramString(self) -> str: ...

class ItemEvent(java.awt.AWTEvent):
    ITEM_FIRST: _py_ClassVar[int] = ...
    ITEM_LAST: _py_ClassVar[int] = ...
    ITEM_STATE_CHANGED: _py_ClassVar[int] = ...
    SELECTED: _py_ClassVar[int] = ...
    DESELECTED: _py_ClassVar[int] = ...
    def __init__(self, itemSelectable: java.awt.ItemSelectable, int: int, object: _py_Any, int2: int): ...
    def getItem(self) -> _py_Any: ...
    def getItemSelectable(self) -> java.awt.ItemSelectable: ...
    def getStateChange(self) -> int: ...
    def paramString(self) -> str: ...

class ItemListener(java.util.EventListener):
    def itemStateChanged(self, itemEvent: ItemEvent) -> None: ...

class KeyListener(java.util.EventListener):
    def keyPressed(self, keyEvent: 'KeyEvent') -> None: ...
    def keyReleased(self, keyEvent: 'KeyEvent') -> None: ...
    def keyTyped(self, keyEvent: 'KeyEvent') -> None: ...

class MouseListener(java.util.EventListener):
    def mouseClicked(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseEntered(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseExited(self, mouseEvent: 'MouseEvent') -> None: ...
    def mousePressed(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseReleased(self, mouseEvent: 'MouseEvent') -> None: ...

class MouseMotionListener(java.util.EventListener):
    def mouseDragged(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseMoved(self, mouseEvent: 'MouseEvent') -> None: ...

class MouseWheelListener(java.util.EventListener):
    def mouseWheelMoved(self, mouseWheelEvent: 'MouseWheelEvent') -> None: ...

class NativeLibLoader: ...

class TextEvent(java.awt.AWTEvent):
    TEXT_FIRST: _py_ClassVar[int] = ...
    TEXT_LAST: _py_ClassVar[int] = ...
    TEXT_VALUE_CHANGED: _py_ClassVar[int] = ...
    def __init__(self, object: _py_Any, int: int): ...
    def paramString(self) -> str: ...

class TextListener(java.util.EventListener):
    def textValueChanged(self, textEvent: TextEvent) -> None: ...

class WindowFocusListener(java.util.EventListener):
    def windowGainedFocus(self, windowEvent: 'WindowEvent') -> None: ...
    def windowLostFocus(self, windowEvent: 'WindowEvent') -> None: ...

class WindowListener(java.util.EventListener):
    def windowActivated(self, windowEvent: 'WindowEvent') -> None: ...
    def windowClosed(self, windowEvent: 'WindowEvent') -> None: ...
    def windowClosing(self, windowEvent: 'WindowEvent') -> None: ...
    def windowDeactivated(self, windowEvent: 'WindowEvent') -> None: ...
    def windowDeiconified(self, windowEvent: 'WindowEvent') -> None: ...
    def windowIconified(self, windowEvent: 'WindowEvent') -> None: ...
    def windowOpened(self, windowEvent: 'WindowEvent') -> None: ...

class WindowStateListener(java.util.EventListener):
    def windowStateChanged(self, windowEvent: 'WindowEvent') -> None: ...

class AWTEventListenerProxy(java.util.EventListenerProxy[AWTEventListener], AWTEventListener):
    def __init__(self, long: int, aWTEventListener: AWTEventListener): ...
    def eventDispatched(self, aWTEvent: java.awt.AWTEvent) -> None: ...
    def getEventMask(self) -> int: ...

class ComponentAdapter(ComponentListener):
    def __init__(self): ...
    def componentHidden(self, componentEvent: ComponentEvent) -> None: ...
    def componentMoved(self, componentEvent: ComponentEvent) -> None: ...
    def componentResized(self, componentEvent: ComponentEvent) -> None: ...
    def componentShown(self, componentEvent: ComponentEvent) -> None: ...

class ContainerAdapter(ContainerListener):
    def __init__(self): ...
    def componentAdded(self, containerEvent: 'ContainerEvent') -> None: ...
    def componentRemoved(self, containerEvent: 'ContainerEvent') -> None: ...

class ContainerEvent(ComponentEvent):
    CONTAINER_FIRST: _py_ClassVar[int] = ...
    CONTAINER_LAST: _py_ClassVar[int] = ...
    COMPONENT_ADDED: _py_ClassVar[int] = ...
    COMPONENT_REMOVED: _py_ClassVar[int] = ...
    def __init__(self, component: java.awt.Component, int: int, component2: java.awt.Component): ...
    def getChild(self) -> java.awt.Component: ...
    def getContainer(self) -> java.awt.Container: ...
    def paramString(self) -> str: ...

class FocusAdapter(FocusListener):
    def __init__(self): ...
    def focusGained(self, focusEvent: 'FocusEvent') -> None: ...
    def focusLost(self, focusEvent: 'FocusEvent') -> None: ...

class FocusEvent(ComponentEvent):
    FOCUS_FIRST: _py_ClassVar[int] = ...
    FOCUS_LAST: _py_ClassVar[int] = ...
    FOCUS_GAINED: _py_ClassVar[int] = ...
    FOCUS_LOST: _py_ClassVar[int] = ...
    @overload
    def __init__(self, component: java.awt.Component, int: int): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, boolean: bool): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, boolean: bool, component2: java.awt.Component): ...
    def getOppositeComponent(self) -> java.awt.Component: ...
    def isTemporary(self) -> bool: ...
    def paramString(self) -> str: ...

class HierarchyBoundsAdapter(HierarchyBoundsListener):
    def __init__(self): ...
    def ancestorMoved(self, hierarchyEvent: HierarchyEvent) -> None: ...
    def ancestorResized(self, hierarchyEvent: HierarchyEvent) -> None: ...

class InputEvent(ComponentEvent):
    SHIFT_MASK: _py_ClassVar[int] = ...
    CTRL_MASK: _py_ClassVar[int] = ...
    META_MASK: _py_ClassVar[int] = ...
    ALT_MASK: _py_ClassVar[int] = ...
    ALT_GRAPH_MASK: _py_ClassVar[int] = ...
    BUTTON1_MASK: _py_ClassVar[int] = ...
    BUTTON2_MASK: _py_ClassVar[int] = ...
    BUTTON3_MASK: _py_ClassVar[int] = ...
    SHIFT_DOWN_MASK: _py_ClassVar[int] = ...
    CTRL_DOWN_MASK: _py_ClassVar[int] = ...
    META_DOWN_MASK: _py_ClassVar[int] = ...
    ALT_DOWN_MASK: _py_ClassVar[int] = ...
    BUTTON1_DOWN_MASK: _py_ClassVar[int] = ...
    BUTTON2_DOWN_MASK: _py_ClassVar[int] = ...
    BUTTON3_DOWN_MASK: _py_ClassVar[int] = ...
    ALT_GRAPH_DOWN_MASK: _py_ClassVar[int] = ...
    def consume(self) -> None: ...
    @classmethod
    def getMaskForButton(cls, int: int) -> int: ...
    def getModifiers(self) -> int: ...
    def getModifiersEx(self) -> int: ...
    @classmethod
    def getModifiersExText(cls, int: int) -> str: ...
    def getWhen(self) -> int: ...
    def isAltDown(self) -> bool: ...
    def isAltGraphDown(self) -> bool: ...
    def isConsumed(self) -> bool: ...
    def isControlDown(self) -> bool: ...
    def isMetaDown(self) -> bool: ...
    def isShiftDown(self) -> bool: ...

class KeyAdapter(KeyListener):
    def __init__(self): ...
    def keyPressed(self, keyEvent: 'KeyEvent') -> None: ...
    def keyReleased(self, keyEvent: 'KeyEvent') -> None: ...
    def keyTyped(self, keyEvent: 'KeyEvent') -> None: ...

class MouseAdapter(MouseListener, MouseWheelListener, MouseMotionListener):
    def __init__(self): ...
    def mouseClicked(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseDragged(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseEntered(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseExited(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseMoved(self, mouseEvent: 'MouseEvent') -> None: ...
    def mousePressed(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseReleased(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseWheelMoved(self, mouseWheelEvent: 'MouseWheelEvent') -> None: ...

class MouseMotionAdapter(MouseMotionListener):
    def __init__(self): ...
    def mouseDragged(self, mouseEvent: 'MouseEvent') -> None: ...
    def mouseMoved(self, mouseEvent: 'MouseEvent') -> None: ...

class PaintEvent(ComponentEvent):
    PAINT_FIRST: _py_ClassVar[int] = ...
    PAINT_LAST: _py_ClassVar[int] = ...
    PAINT: _py_ClassVar[int] = ...
    UPDATE: _py_ClassVar[int] = ...
    def __init__(self, component: java.awt.Component, int: int, rectangle: java.awt.Rectangle): ...
    def getUpdateRect(self) -> java.awt.Rectangle: ...
    def paramString(self) -> str: ...
    def setUpdateRect(self, rectangle: java.awt.Rectangle) -> None: ...

class WindowAdapter(WindowListener, WindowStateListener, WindowFocusListener):
    def __init__(self): ...
    def windowActivated(self, windowEvent: 'WindowEvent') -> None: ...
    def windowClosed(self, windowEvent: 'WindowEvent') -> None: ...
    def windowClosing(self, windowEvent: 'WindowEvent') -> None: ...
    def windowDeactivated(self, windowEvent: 'WindowEvent') -> None: ...
    def windowDeiconified(self, windowEvent: 'WindowEvent') -> None: ...
    def windowGainedFocus(self, windowEvent: 'WindowEvent') -> None: ...
    def windowIconified(self, windowEvent: 'WindowEvent') -> None: ...
    def windowLostFocus(self, windowEvent: 'WindowEvent') -> None: ...
    def windowOpened(self, windowEvent: 'WindowEvent') -> None: ...
    def windowStateChanged(self, windowEvent: 'WindowEvent') -> None: ...

class WindowEvent(ComponentEvent):
    WINDOW_FIRST: _py_ClassVar[int] = ...
    WINDOW_OPENED: _py_ClassVar[int] = ...
    WINDOW_CLOSING: _py_ClassVar[int] = ...
    WINDOW_CLOSED: _py_ClassVar[int] = ...
    WINDOW_ICONIFIED: _py_ClassVar[int] = ...
    WINDOW_DEICONIFIED: _py_ClassVar[int] = ...
    WINDOW_ACTIVATED: _py_ClassVar[int] = ...
    WINDOW_DEACTIVATED: _py_ClassVar[int] = ...
    WINDOW_GAINED_FOCUS: _py_ClassVar[int] = ...
    WINDOW_LOST_FOCUS: _py_ClassVar[int] = ...
    WINDOW_STATE_CHANGED: _py_ClassVar[int] = ...
    WINDOW_LAST: _py_ClassVar[int] = ...
    @overload
    def __init__(self, window: java.awt.Window, int: int): ...
    @overload
    def __init__(self, window: java.awt.Window, int: int, int2: int, int3: int): ...
    @overload
    def __init__(self, window: java.awt.Window, int: int, window2: java.awt.Window): ...
    @overload
    def __init__(self, window: java.awt.Window, int: int, window2: java.awt.Window, int2: int, int3: int): ...
    def getNewState(self) -> int: ...
    def getOldState(self) -> int: ...
    def getOppositeWindow(self) -> java.awt.Window: ...
    def getWindow(self) -> java.awt.Window: ...
    def paramString(self) -> str: ...

class KeyEvent(InputEvent):
    KEY_FIRST: _py_ClassVar[int] = ...
    KEY_LAST: _py_ClassVar[int] = ...
    KEY_TYPED: _py_ClassVar[int] = ...
    KEY_PRESSED: _py_ClassVar[int] = ...
    KEY_RELEASED: _py_ClassVar[int] = ...
    VK_ENTER: _py_ClassVar[int] = ...
    VK_BACK_SPACE: _py_ClassVar[int] = ...
    VK_TAB: _py_ClassVar[int] = ...
    VK_CANCEL: _py_ClassVar[int] = ...
    VK_CLEAR: _py_ClassVar[int] = ...
    VK_SHIFT: _py_ClassVar[int] = ...
    VK_CONTROL: _py_ClassVar[int] = ...
    VK_ALT: _py_ClassVar[int] = ...
    VK_PAUSE: _py_ClassVar[int] = ...
    VK_CAPS_LOCK: _py_ClassVar[int] = ...
    VK_ESCAPE: _py_ClassVar[int] = ...
    VK_SPACE: _py_ClassVar[int] = ...
    VK_PAGE_UP: _py_ClassVar[int] = ...
    VK_PAGE_DOWN: _py_ClassVar[int] = ...
    VK_END: _py_ClassVar[int] = ...
    VK_HOME: _py_ClassVar[int] = ...
    VK_LEFT: _py_ClassVar[int] = ...
    VK_UP: _py_ClassVar[int] = ...
    VK_RIGHT: _py_ClassVar[int] = ...
    VK_DOWN: _py_ClassVar[int] = ...
    VK_COMMA: _py_ClassVar[int] = ...
    VK_MINUS: _py_ClassVar[int] = ...
    VK_PERIOD: _py_ClassVar[int] = ...
    VK_SLASH: _py_ClassVar[int] = ...
    VK_0: _py_ClassVar[int] = ...
    VK_1: _py_ClassVar[int] = ...
    VK_2: _py_ClassVar[int] = ...
    VK_3: _py_ClassVar[int] = ...
    VK_4: _py_ClassVar[int] = ...
    VK_5: _py_ClassVar[int] = ...
    VK_6: _py_ClassVar[int] = ...
    VK_7: _py_ClassVar[int] = ...
    VK_8: _py_ClassVar[int] = ...
    VK_9: _py_ClassVar[int] = ...
    VK_SEMICOLON: _py_ClassVar[int] = ...
    VK_EQUALS: _py_ClassVar[int] = ...
    VK_A: _py_ClassVar[int] = ...
    VK_B: _py_ClassVar[int] = ...
    VK_C: _py_ClassVar[int] = ...
    VK_D: _py_ClassVar[int] = ...
    VK_E: _py_ClassVar[int] = ...
    VK_F: _py_ClassVar[int] = ...
    VK_G: _py_ClassVar[int] = ...
    VK_H: _py_ClassVar[int] = ...
    VK_I: _py_ClassVar[int] = ...
    VK_J: _py_ClassVar[int] = ...
    VK_K: _py_ClassVar[int] = ...
    VK_L: _py_ClassVar[int] = ...
    VK_M: _py_ClassVar[int] = ...
    VK_N: _py_ClassVar[int] = ...
    VK_O: _py_ClassVar[int] = ...
    VK_P: _py_ClassVar[int] = ...
    VK_Q: _py_ClassVar[int] = ...
    VK_R: _py_ClassVar[int] = ...
    VK_S: _py_ClassVar[int] = ...
    VK_T: _py_ClassVar[int] = ...
    VK_U: _py_ClassVar[int] = ...
    VK_V: _py_ClassVar[int] = ...
    VK_W: _py_ClassVar[int] = ...
    VK_X: _py_ClassVar[int] = ...
    VK_Y: _py_ClassVar[int] = ...
    VK_Z: _py_ClassVar[int] = ...
    VK_OPEN_BRACKET: _py_ClassVar[int] = ...
    VK_BACK_SLASH: _py_ClassVar[int] = ...
    VK_CLOSE_BRACKET: _py_ClassVar[int] = ...
    VK_NUMPAD0: _py_ClassVar[int] = ...
    VK_NUMPAD1: _py_ClassVar[int] = ...
    VK_NUMPAD2: _py_ClassVar[int] = ...
    VK_NUMPAD3: _py_ClassVar[int] = ...
    VK_NUMPAD4: _py_ClassVar[int] = ...
    VK_NUMPAD5: _py_ClassVar[int] = ...
    VK_NUMPAD6: _py_ClassVar[int] = ...
    VK_NUMPAD7: _py_ClassVar[int] = ...
    VK_NUMPAD8: _py_ClassVar[int] = ...
    VK_NUMPAD9: _py_ClassVar[int] = ...
    VK_MULTIPLY: _py_ClassVar[int] = ...
    VK_ADD: _py_ClassVar[int] = ...
    VK_SEPARATER: _py_ClassVar[int] = ...
    VK_SEPARATOR: _py_ClassVar[int] = ...
    VK_SUBTRACT: _py_ClassVar[int] = ...
    VK_DECIMAL: _py_ClassVar[int] = ...
    VK_DIVIDE: _py_ClassVar[int] = ...
    VK_DELETE: _py_ClassVar[int] = ...
    VK_NUM_LOCK: _py_ClassVar[int] = ...
    VK_SCROLL_LOCK: _py_ClassVar[int] = ...
    VK_F1: _py_ClassVar[int] = ...
    VK_F2: _py_ClassVar[int] = ...
    VK_F3: _py_ClassVar[int] = ...
    VK_F4: _py_ClassVar[int] = ...
    VK_F5: _py_ClassVar[int] = ...
    VK_F6: _py_ClassVar[int] = ...
    VK_F7: _py_ClassVar[int] = ...
    VK_F8: _py_ClassVar[int] = ...
    VK_F9: _py_ClassVar[int] = ...
    VK_F10: _py_ClassVar[int] = ...
    VK_F11: _py_ClassVar[int] = ...
    VK_F12: _py_ClassVar[int] = ...
    VK_F13: _py_ClassVar[int] = ...
    VK_F14: _py_ClassVar[int] = ...
    VK_F15: _py_ClassVar[int] = ...
    VK_F16: _py_ClassVar[int] = ...
    VK_F17: _py_ClassVar[int] = ...
    VK_F18: _py_ClassVar[int] = ...
    VK_F19: _py_ClassVar[int] = ...
    VK_F20: _py_ClassVar[int] = ...
    VK_F21: _py_ClassVar[int] = ...
    VK_F22: _py_ClassVar[int] = ...
    VK_F23: _py_ClassVar[int] = ...
    VK_F24: _py_ClassVar[int] = ...
    VK_PRINTSCREEN: _py_ClassVar[int] = ...
    VK_INSERT: _py_ClassVar[int] = ...
    VK_HELP: _py_ClassVar[int] = ...
    VK_META: _py_ClassVar[int] = ...
    VK_BACK_QUOTE: _py_ClassVar[int] = ...
    VK_QUOTE: _py_ClassVar[int] = ...
    VK_KP_UP: _py_ClassVar[int] = ...
    VK_KP_DOWN: _py_ClassVar[int] = ...
    VK_KP_LEFT: _py_ClassVar[int] = ...
    VK_KP_RIGHT: _py_ClassVar[int] = ...
    VK_DEAD_GRAVE: _py_ClassVar[int] = ...
    VK_DEAD_ACUTE: _py_ClassVar[int] = ...
    VK_DEAD_CIRCUMFLEX: _py_ClassVar[int] = ...
    VK_DEAD_TILDE: _py_ClassVar[int] = ...
    VK_DEAD_MACRON: _py_ClassVar[int] = ...
    VK_DEAD_BREVE: _py_ClassVar[int] = ...
    VK_DEAD_ABOVEDOT: _py_ClassVar[int] = ...
    VK_DEAD_DIAERESIS: _py_ClassVar[int] = ...
    VK_DEAD_ABOVERING: _py_ClassVar[int] = ...
    VK_DEAD_DOUBLEACUTE: _py_ClassVar[int] = ...
    VK_DEAD_CARON: _py_ClassVar[int] = ...
    VK_DEAD_CEDILLA: _py_ClassVar[int] = ...
    VK_DEAD_OGONEK: _py_ClassVar[int] = ...
    VK_DEAD_IOTA: _py_ClassVar[int] = ...
    VK_DEAD_VOICED_SOUND: _py_ClassVar[int] = ...
    VK_DEAD_SEMIVOICED_SOUND: _py_ClassVar[int] = ...
    VK_AMPERSAND: _py_ClassVar[int] = ...
    VK_ASTERISK: _py_ClassVar[int] = ...
    VK_QUOTEDBL: _py_ClassVar[int] = ...
    VK_LESS: _py_ClassVar[int] = ...
    VK_GREATER: _py_ClassVar[int] = ...
    VK_BRACELEFT: _py_ClassVar[int] = ...
    VK_BRACERIGHT: _py_ClassVar[int] = ...
    VK_AT: _py_ClassVar[int] = ...
    VK_COLON: _py_ClassVar[int] = ...
    VK_CIRCUMFLEX: _py_ClassVar[int] = ...
    VK_DOLLAR: _py_ClassVar[int] = ...
    VK_EURO_SIGN: _py_ClassVar[int] = ...
    VK_EXCLAMATION_MARK: _py_ClassVar[int] = ...
    VK_INVERTED_EXCLAMATION_MARK: _py_ClassVar[int] = ...
    VK_LEFT_PARENTHESIS: _py_ClassVar[int] = ...
    VK_NUMBER_SIGN: _py_ClassVar[int] = ...
    VK_PLUS: _py_ClassVar[int] = ...
    VK_RIGHT_PARENTHESIS: _py_ClassVar[int] = ...
    VK_UNDERSCORE: _py_ClassVar[int] = ...
    VK_WINDOWS: _py_ClassVar[int] = ...
    VK_CONTEXT_MENU: _py_ClassVar[int] = ...
    VK_FINAL: _py_ClassVar[int] = ...
    VK_CONVERT: _py_ClassVar[int] = ...
    VK_NONCONVERT: _py_ClassVar[int] = ...
    VK_ACCEPT: _py_ClassVar[int] = ...
    VK_MODECHANGE: _py_ClassVar[int] = ...
    VK_KANA: _py_ClassVar[int] = ...
    VK_KANJI: _py_ClassVar[int] = ...
    VK_ALPHANUMERIC: _py_ClassVar[int] = ...
    VK_KATAKANA: _py_ClassVar[int] = ...
    VK_HIRAGANA: _py_ClassVar[int] = ...
    VK_FULL_WIDTH: _py_ClassVar[int] = ...
    VK_HALF_WIDTH: _py_ClassVar[int] = ...
    VK_ROMAN_CHARACTERS: _py_ClassVar[int] = ...
    VK_ALL_CANDIDATES: _py_ClassVar[int] = ...
    VK_PREVIOUS_CANDIDATE: _py_ClassVar[int] = ...
    VK_CODE_INPUT: _py_ClassVar[int] = ...
    VK_JAPANESE_KATAKANA: _py_ClassVar[int] = ...
    VK_JAPANESE_HIRAGANA: _py_ClassVar[int] = ...
    VK_JAPANESE_ROMAN: _py_ClassVar[int] = ...
    VK_KANA_LOCK: _py_ClassVar[int] = ...
    VK_INPUT_METHOD_ON_OFF: _py_ClassVar[int] = ...
    VK_CUT: _py_ClassVar[int] = ...
    VK_COPY: _py_ClassVar[int] = ...
    VK_PASTE: _py_ClassVar[int] = ...
    VK_UNDO: _py_ClassVar[int] = ...
    VK_AGAIN: _py_ClassVar[int] = ...
    VK_FIND: _py_ClassVar[int] = ...
    VK_PROPS: _py_ClassVar[int] = ...
    VK_STOP: _py_ClassVar[int] = ...
    VK_COMPOSE: _py_ClassVar[int] = ...
    VK_ALT_GRAPH: _py_ClassVar[int] = ...
    VK_BEGIN: _py_ClassVar[int] = ...
    VK_UNDEFINED: _py_ClassVar[int] = ...
    CHAR_UNDEFINED: _py_ClassVar[str] = ...
    KEY_LOCATION_UNKNOWN: _py_ClassVar[int] = ...
    KEY_LOCATION_STANDARD: _py_ClassVar[int] = ...
    KEY_LOCATION_LEFT: _py_ClassVar[int] = ...
    KEY_LOCATION_RIGHT: _py_ClassVar[int] = ...
    KEY_LOCATION_NUMPAD: _py_ClassVar[int] = ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, char: str): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, char: str, int4: int): ...
    def getExtendedKeyCode(self) -> int: ...
    @classmethod
    def getExtendedKeyCodeForChar(cls, int: int) -> int: ...
    def getKeyChar(self) -> str: ...
    def getKeyCode(self) -> int: ...
    def getKeyLocation(self) -> int: ...
    @classmethod
    def getKeyModifiersText(cls, int: int) -> str: ...
    @classmethod
    def getKeyText(cls, int: int) -> str: ...
    def isActionKey(self) -> bool: ...
    def paramString(self) -> str: ...
    def setKeyChar(self, char: str) -> None: ...
    def setKeyCode(self, int: int) -> None: ...
    def setModifiers(self, int: int) -> None: ...

class MouseEvent(InputEvent):
    MOUSE_FIRST: _py_ClassVar[int] = ...
    MOUSE_LAST: _py_ClassVar[int] = ...
    MOUSE_CLICKED: _py_ClassVar[int] = ...
    MOUSE_PRESSED: _py_ClassVar[int] = ...
    MOUSE_RELEASED: _py_ClassVar[int] = ...
    MOUSE_MOVED: _py_ClassVar[int] = ...
    MOUSE_ENTERED: _py_ClassVar[int] = ...
    MOUSE_EXITED: _py_ClassVar[int] = ...
    MOUSE_DRAGGED: _py_ClassVar[int] = ...
    MOUSE_WHEEL: _py_ClassVar[int] = ...
    NOBUTTON: _py_ClassVar[int] = ...
    BUTTON1: _py_ClassVar[int] = ...
    BUTTON2: _py_ClassVar[int] = ...
    BUTTON3: _py_ClassVar[int] = ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, int4: int, int5: int, boolean: bool): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, int4: int, int5: int, boolean: bool, int6: int): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, boolean: bool, int8: int): ...
    def getButton(self) -> int: ...
    def getClickCount(self) -> int: ...
    def getLocationOnScreen(self) -> java.awt.Point: ...
    def getModifiersEx(self) -> int: ...
    @classmethod
    def getMouseModifiersText(cls, int: int) -> str: ...
    def getPoint(self) -> java.awt.Point: ...
    def getX(self) -> int: ...
    def getXOnScreen(self) -> int: ...
    def getY(self) -> int: ...
    def getYOnScreen(self) -> int: ...
    def isPopupTrigger(self) -> bool: ...
    def paramString(self) -> str: ...
    def translatePoint(self, int: int, int2: int) -> None: ...

class MouseWheelEvent(MouseEvent):
    WHEEL_UNIT_SCROLL: _py_ClassVar[int] = ...
    WHEEL_BLOCK_SCROLL: _py_ClassVar[int] = ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, int4: int, int5: int, boolean: bool, int6: int, int7: int, int8: int): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, boolean: bool, int8: int, int9: int, int10: int): ...
    @overload
    def __init__(self, component: java.awt.Component, int: int, long: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int, boolean: bool, int8: int, int9: int, int10: int, double: float): ...
    def getPreciseWheelRotation(self) -> float: ...
    def getScrollAmount(self) -> int: ...
    def getScrollType(self) -> int: ...
    def getUnitsToScroll(self) -> int: ...
    def getWheelRotation(self) -> int: ...
    def paramString(self) -> str: ...
