from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.domain.beams
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import cern.lsa.domain.commons
import cern.lsa.domain.devices
import cern.lsa.domain.optics.factory
import com.google.common.collect
import java.io
import java.lang
import java.util


class BeamEnum(java.lang.Enum['BeamEnum']):
    B1: _py_ClassVar['BeamEnum'] = ...
    B2: _py_ClassVar['BeamEnum'] = ...
    B3: _py_ClassVar['BeamEnum'] = ...
    B4: _py_ClassVar['BeamEnum'] = ...
    @classmethod
    def toBeamEnum(cls, string: str) -> 'BeamEnum': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'BeamEnum': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['BeamEnum']: ...

class Calibration(cern.accsoft.commons.util.Named):
    def getCalibrationFunctionByType(self, calibrationFunctionTypes: 'CalibrationFunctionTypes') -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getCalibrationFunctionMap(self) -> java.util.Map['CalibrationFunctionTypes', cern.accsoft.commons.value.ImmutableDiscreteFunction]: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getFidelModelId(self) -> int: ...

class CalibrationException(java.lang.Exception):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class CalibrationFunctionTypes(java.lang.Enum['CalibrationFunctionTypes']):
    B_FIELD: _py_ClassVar['CalibrationFunctionTypes'] = ...
    BL_FIELD: _py_ClassVar['CalibrationFunctionTypes'] = ...
    SLOPE: _py_ClassVar['CalibrationFunctionTypes'] = ...
    CURRENT2INDUCTANCE: _py_ClassVar['CalibrationFunctionTypes'] = ...
    CURRENT2COUPLING_INDUCTANCE: _py_ClassVar['CalibrationFunctionTypes'] = ...
    MAG_INTFIELD2CURRENT: _py_ClassVar['CalibrationFunctionTypes'] = ...
    EL_INTFIELD2VOLTAGE: _py_ClassVar['CalibrationFunctionTypes'] = ...
    LOCAL_FIELD2CURRENT: _py_ClassVar['CalibrationFunctionTypes'] = ...
    CURRENT2HALL_VOLTAGE: _py_ClassVar['CalibrationFunctionTypes'] = ...
    B_FIELD_RDOWN: _py_ClassVar['CalibrationFunctionTypes'] = ...
    MAG_INTFIELD2VOLTAGE: _py_ClassVar['CalibrationFunctionTypes'] = ...
    BL_FIELD_RDOWN: _py_ClassVar['CalibrationFunctionTypes'] = ...
    def getFunctionTypeName(self) -> str: ...
    @classmethod
    def getTypeForName(cls, string: str) -> 'CalibrationFunctionTypes': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'CalibrationFunctionTypes': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['CalibrationFunctionTypes']: ...

class ChromaticModel(cern.accsoft.commons.util.Named):
    def getAlphaH(self) -> float: ...
    def getAlphaV(self) -> float: ...
    def getBetaH(self) -> float: ...
    def getBetaV(self) -> float: ...
    def getBsedd(self) -> float: ...
    def getBsrem(self) -> float: ...
    def getChcon(self) -> float: ...
    def getChedd(self) -> float: ...
    def getChrem(self) -> float: ...
    def getCvcon(self) -> float: ...
    def getCvedd(self) -> float: ...
    def getCvrem(self) -> float: ...
    def getGammaH(self) -> float: ...
    def getGammaV(self) -> float: ...
    def getLatticeChromaH(self) -> float: ...
    def getLatticeChromaV(self) -> float: ...

class ElementBase(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity):
    def getAcceleratorZone(self) -> cern.accsoft.commons.domain.zones.AcceleratorZone: ...
    def getLength(self) -> float: ...
    def getMadParent(self) -> str: ...
    def getPlane(self) -> 'ElementPlane': ...
    def getPosition(self) -> float: ...
    def getType(self) -> 'ElementType': ...

class ElementPlane(java.lang.Enum['ElementPlane'], cern.accsoft.commons.util.Named):
    VERTICAL: _py_ClassVar['ElementPlane'] = ...
    HORIZONTAL: _py_ClassVar['ElementPlane'] = ...
    BOTH: _py_ClassVar['ElementPlane'] = ...
    NONE: _py_ClassVar['ElementPlane'] = ...
    @classmethod
    def findPlaneBySymbol(cls, char: str) -> 'ElementPlane': ...
    def getName(self) -> str: ...
    def getSymbol(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ElementPlane': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['ElementPlane']: ...

class ElementType(java.lang.Enum['ElementType'], cern.accsoft.commons.util.Named):
    DRIFT: _py_ClassVar['ElementType'] = ...
    HKICKER: _py_ClassVar['ElementType'] = ...
    HMONITOR: _py_ClassVar['ElementType'] = ...
    INSTRUMENT: _py_ClassVar['ElementType'] = ...
    IP: _py_ClassVar['ElementType'] = ...
    KICKER: _py_ClassVar['ElementType'] = ...
    MARKER: _py_ClassVar['ElementType'] = ...
    MONITOR: _py_ClassVar['ElementType'] = ...
    MULTIPOLE: _py_ClassVar['ElementType'] = ...
    OCTUPOLE: _py_ClassVar['ElementType'] = ...
    QUADRUPOLE: _py_ClassVar['ElementType'] = ...
    RBEND: _py_ClassVar['ElementType'] = ...
    RCOLLIMATOR: _py_ClassVar['ElementType'] = ...
    RFCAVITY: _py_ClassVar['ElementType'] = ...
    SBEND: _py_ClassVar['ElementType'] = ...
    SEXTUPOLE: _py_ClassVar['ElementType'] = ...
    SOLENOID: _py_ClassVar['ElementType'] = ...
    TKICKER: _py_ClassVar['ElementType'] = ...
    VKICKER: _py_ClassVar['ElementType'] = ...
    VMONITOR: _py_ClassVar['ElementType'] = ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'ElementType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['ElementType']: ...

class ElementsRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.optics.factory.ElementsRequestBuilder: ...
    def excludeObsolete(self) -> bool: ...
    def getAcceleratorZone(self) -> cern.accsoft.commons.domain.zones.AcceleratorZone: ...
    def getElementNames(self) -> java.util.Set[str]: ...
    def getLogicalHwNames(self) -> java.util.Set[str]: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getSteering(self) -> bool: ...
    def getTypes(self) -> java.util.Set[ElementType]: ...

class LogicalHardware(cern.lsa.domain.devices.Device):
    def getCalibrationName(self) -> str: ...
    def getCalibrationSign(self) -> int: ...
    def getLinkRuleName(self) -> str: ...
    def getLtot(self) -> float: ...
    def getMadStrengthName(self) -> str: ...
    def getMadStrengthType(self) -> str: ...
    def getMagnetType(self) -> str: ...
    def getMagneticLength(self) -> float: ...
    def getOpTemp(self) -> float: ...
    def getPlane(self) -> ElementPlane: ...
    def getRtot(self) -> float: ...
    def getRtotMeasured(self) -> float: ...
    def getTau(self) -> float: ...

class MeasuredTwiss:
    def getAlfxError(self) -> float: ...
    def getAlfxMeas(self) -> float: ...
    def getAlfyError(self) -> float: ...
    def getAlfyMeas(self) -> float: ...
    def getBetxError(self) -> float: ...
    def getBetxMeas(self) -> float: ...
    def getBetyError(self) -> float: ...
    def getBetyMeas(self) -> float: ...
    def getDxError(self) -> float: ...
    def getDxMeas(self) -> float: ...
    def getDyError(self) -> float: ...
    def getDyMeas(self) -> float: ...
    def getEnergy(self) -> float: ...
    def getMuxError(self) -> float: ...
    def getMuxMeas(self) -> float: ...
    def getMuyError(self) -> float: ...
    def getMuyMeas(self) -> float: ...
    def getTimestamp(self) -> java.util.Date: ...
    def getTwiss(self) -> 'Twiss': ...

class Optic(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity):
    def getBaseStrengthFile(self) -> str: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getDescription(self) -> str: ...
    def getGeometry(self) -> str: ...
    def getOpticParameters(self) -> java.util.Map[str, float]: ...
    def getOpticStrengths(self) -> java.util.List['OpticStrength']: ...
    def getOverrideStrengthFile(self) -> str: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getParameterValue(self, string: str) -> float: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...
    def getProgramVersion(self) -> str: ...
    def getTitle(self) -> str: ...
    def setName(self, string: str) -> None: ...

class OpticStrength:
    def getBeam(self) -> str: ...
    def getLogicalHardwareName(self) -> str: ...
    def getStrength(self) -> float: ...
    def getStrengthL(self) -> float: ...

class Optics(java.io.Serializable):
    def __init__(self, set: java.util.Set[Optic]): ...
    def getBeam(self, stringArray: _py_List[str], string2: str) -> _py_List[str]: ...
    def getOptic(self, string: str) -> Optic: ...
    def getOpticNames(self) -> java.util.Set[str]: ...
    def getOpticParameterValues(self, list: java.util.List[str], string: str) -> _py_List[float]: ...
    def getStrength(self, list: java.util.List[str], string: str) -> _py_List[float]: ...
    def getStrengthL(self, list: java.util.List[str], string: str) -> _py_List[float]: ...
    def isParameterDefined(self, collection: java.util.Collection[str], string: str) -> bool: ...
    def size(self) -> int: ...

class OpticsRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.optics.factory.OpticsRequestBuilder: ...
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def getBeamProcessTypeNames(self) -> java.util.Set[str]: ...
    def getOpticIds(self) -> java.util.Set[int]: ...
    def getParticleTransfer(self) -> cern.accsoft.commons.domain.particletransfers.ParticleTransfer: ...

class OpticsTable(java.lang.Iterable['OpticsTableItem']):
    def getBeamProcessTypeName(self) -> str: ...
    def getErrorMessages(self) -> java.util.Set[str]: ...
    def getLength(self) -> int: ...
    def getOpticNames(self) -> java.util.List[str]: ...
    def getOpticsTableItemByIndex(self, int: int) -> 'OpticsTableItem': ...
    def getOpticsTableItemByTime(self, double: float) -> 'OpticsTableItem': ...
    def getOpticsTableItems(self) -> java.util.List['OpticsTableItem']: ...
    def getSize(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...

class OpticsTableItem:
    def clone(self) -> 'OpticsTableItem': ...
    def getBeamProcessTypeName(self) -> str: ...
    def getEnergy(self) -> float: ...
    def getOpticId(self) -> int: ...
    def getOpticName(self) -> str: ...
    def getTime(self) -> int: ...

class OpticsTables:
    def __init__(self): ...
    @classmethod
    def getEnergyFunction(cls, opticsTable: OpticsTable) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    @classmethod
    def getOpticTimesCoordinates(cls, opticsTable: OpticsTable) -> _py_List[float]: ...

class PowerConverterInfo(cern.accsoft.commons.util.Named, cern.lsa.domain.commons.IdentifiedEntity):
    def getAccelerationLimit(self) -> float: ...
    def getAdvance(self) -> float: ...
    def getBeam(self) -> str: ...
    def getDecelerationLimit(self) -> float: ...
    def getDidtMax(self) -> float: ...
    def getDidtMin(self) -> float: ...
    def getIMinOp(self) -> float: ...
    def getINom(self) -> float: ...
    def getIPNo(self) -> float: ...
    def getIUlt(self) -> float: ...
    def getLastRefDatabaseUpdate(self) -> java.util.Date: ...
    def getPoweringSubsector(self) -> str: ...
    def isPolaritySwitch(self) -> bool: ...

class PreCyclingPrescription:
    def getAttributeValue(self, string: str) -> float: ...
    def getMagnetType(self) -> str: ...
    def getPrecyclingPrescriptionMode(self) -> str: ...
    def getPrecyclingPrescriptionType(self) -> str: ...

class RFCalibration(cern.accsoft.commons.util.Named):
    def getCavityQ(self, double: float) -> float: ...
    def getCavityQ2CouplerPosFunction(self) -> cern.accsoft.commons.value.ImmutableDiscreteFunction: ...
    def getCouplerPos(self, double: float) -> float: ...
    def getCreationDate(self) -> java.util.Date: ...
    def getDeviceName(self) -> str: ...

class Twiss:
    def getAlfx(self) -> float: ...
    def getAlfy(self) -> float: ...
    def getBeam(self) -> cern.accsoft.commons.domain.beams.Beam: ...
    def getBetx(self) -> float: ...
    def getBety(self) -> float: ...
    def getDpx(self) -> float: ...
    def getDpy(self) -> float: ...
    def getDx(self) -> float: ...
    def getDy(self) -> float: ...
    def getElement(self) -> ElementBase: ...
    def getK0l(self) -> float: ...
    def getK1Sl(self) -> float: ...
    def getK1l(self) -> float: ...
    def getK2Sl(self) -> float: ...
    def getK2l(self) -> float: ...
    def getK3Sl(self) -> float: ...
    def getK3l(self) -> float: ...
    def getK4l(self) -> float: ...
    def getK5l(self) -> float: ...
    def getMux(self) -> float: ...
    def getMuy(self) -> float: ...
    def getOpticName(self) -> str: ...
    def getPx(self) -> float: ...
    def getPy(self) -> float: ...
    def getX(self) -> float: ...
    def getY(self) -> float: ...
    def updateOpticName(self, string: str) -> None: ...

class TwissFilter(cern.accsoft.commons.util.Filters.Filter[Twiss]):
    def __init__(self): ...
    @overload
    def accepts(self, twiss: Twiss) -> bool: ...
    @overload
    def accepts(self, object: _py_Any) -> bool: ...
    @classmethod
    def beam(cls, beam: cern.accsoft.commons.domain.beams.Beam) -> 'TwissFilter': ...
    @classmethod
    def elementTypeIn(cls, collection: java.util.Collection[ElementType]) -> 'TwissFilter': ...
    def setBeam(self, beam: cern.accsoft.commons.domain.beams.Beam) -> 'TwissFilter': ...
    def setElementTypes(self, collection: java.util.Collection[ElementType]) -> 'TwissFilter': ...

class TwissHelper:
    def __init__(self): ...
    @classmethod
    def mapByDate(cls, collection: java.util.Collection[MeasuredTwiss]) -> java.util.Map[java.util.Date, java.util.Set[MeasuredTwiss]]: ...
    @classmethod
    def mapByEnergy(cls, collection: java.util.Collection[MeasuredTwiss]) -> java.util.Map[float, java.util.Set[MeasuredTwiss]]: ...
    @classmethod
    def mapByOpticName(cls, collection: java.util.Collection[MeasuredTwiss]) -> java.util.Map[str, java.util.Set[MeasuredTwiss]]: ...
    @classmethod
    def mapByTwiss(cls, collection: java.util.Collection[MeasuredTwiss]) -> java.util.Map[Twiss, java.util.Set[MeasuredTwiss]]: ...

class Twisses:
    BEAMS: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    ELEMENT_TYPES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    ELEMENT_NAMES: _py_ClassVar[cern.accsoft.commons.util.Mappers.Mapper] = ...
    def __init__(self): ...
    @classmethod
    def getBeams(cls, collection: java.util.Collection[Twiss]) -> java.util.Set[cern.accsoft.commons.domain.beams.Beam]: ...
    @classmethod
    def getElementTypes(cls, collection: java.util.Collection[Twiss]) -> java.util.Set[ElementType]: ...
    @classmethod
    def toElementNamesMap(cls, collection: java.util.Collection[Twiss]) -> java.util.Map[str, Twiss]: ...

class TwissesRequest:
    @classmethod
    def builder(cls) -> cern.lsa.domain.optics.factory.TwissesRequestBuilder: ...
    def getBeam(self) -> cern.accsoft.commons.domain.beams.Beam: ...
    def getElementNames(self) -> java.util.Set[str]: ...
    def getElementPositionRange(self) -> com.google.common.collect.Range[float]: ...
    def getElementTypes(self) -> java.util.Set[ElementType]: ...
    def getOpticName(self) -> str: ...

class Element(ElementBase):
    def getAffectedRings(self) -> java.util.Set[BeamEnum]: ...
    def getLogicalHwName(self) -> str: ...
    def getLogicalHwNames(self) -> java.util.Set[str]: ...
    def getSteeringPlane(self) -> ElementPlane: ...
    def isObsolete(self) -> bool: ...
    def setAffectedRings(self, set: java.util.Set[BeamEnum]) -> None: ...
    def setLength(self, double: float) -> None: ...
    def setObsolete(self, boolean: bool) -> None: ...
    def setPlane(self, elementPlane: ElementPlane) -> None: ...
    def setPosition(self, double: float) -> None: ...
    def setSteeringPlane(self, elementPlane: ElementPlane) -> None: ...
    def setType(self, elementType: ElementType) -> None: ...
