from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.util.collections
import cern.accsoft.commons.value
import cern.japc.core
import cern.japc.value
import cern.lsa.domain.settings
import java.io
import java.lang
import java.util
import org.slf4j


class ContextDriveResult(cern.accsoft.commons.util.AbstractNamedSerializable['ContextDriveResult']):
    @classmethod
    def builder(cls, drivableContext: cern.lsa.domain.settings.DrivableContext) -> 'ContextDriveResult.Builder': ...
    def containsErrors(self) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAllExceptions(self) -> java.util.Set[java.lang.Exception]: ...
    def getDrivableContext(self) -> cern.lsa.domain.settings.DrivableContext: ...
    def getJapcParameterDriveResults(self) -> java.util.Set['JapcParameterDriveResult']: ...
    def getLsaParameterDriveResults(self) -> java.util.Set['LsaParameterDriveResult']: ...
    def getLsaParametersByStatus(self, status: 'LsaParameterDriveResult.Status') -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getName(self) -> str: ...
    def hashCode(self) -> int: ...
    @classmethod
    def merge(cls, contextDriveResult: 'ContextDriveResult', contextDriveResult2: 'ContextDriveResult') -> 'ContextDriveResult': ...
    def toString(self) -> str: ...
    class Builder:
        def addDeviceAdapterDriveResult(self, deviceAdapterDriveResult: 'DeviceAdapterDriveResult') -> 'ContextDriveResult.Builder': ...
        def addDeviceAdapterDriveResults(self, set: java.util.Set['DeviceAdapterDriveResult']) -> 'ContextDriveResult.Builder': ...
        def build(self) -> 'ContextDriveResult': ...

class DeviceAdapterDriveResult(java.io.Serializable):
    @classmethod
    def builder(cls) -> 'DeviceAdapterDriveResult.Builder': ...
    def containsErrors(self) -> bool: ...
    def getJapcParameterDriveResults(self) -> java.util.Set['JapcParameterDriveResult']: ...
    def getLsaParameterDriveResults(self) -> java.util.Set['LsaParameterDriveResult']: ...
    @overload
    def merge(self, deviceAdapterDriveResult: 'DeviceAdapterDriveResult') -> 'DeviceAdapterDriveResult': ...
    @classmethod
    @overload
    def merge(cls, deviceAdapterDriveResult: 'DeviceAdapterDriveResult', deviceAdapterDriveResult2: 'DeviceAdapterDriveResult') -> 'DeviceAdapterDriveResult': ...
    class Builder:
        def addJapcParameterDriveResult(self, japcParameterDriveResult: 'JapcParameterDriveResult', lsaParameterDriveResultArray: _py_List['LsaParameterDriveResult']) -> 'DeviceAdapterDriveResult.Builder': ...
        def addLsaParameterDriveResult(self, lsaParameterDriveResult: 'LsaParameterDriveResult', japcParameterDriveResultArray: _py_List['JapcParameterDriveResult']) -> 'DeviceAdapterDriveResult.Builder': ...
        def build(self) -> 'DeviceAdapterDriveResult': ...
        @classmethod
        def emptyResult(cls) -> 'DeviceAdapterDriveResult': ...
        def getJapcParameterDriveResults(self) -> cern.accsoft.commons.util.collections.OrderedSet['JapcParameterDriveResult']: ...
        def getLsaParameterDriveResults(self) -> cern.accsoft.commons.util.collections.OrderedSet['LsaParameterDriveResult']: ...
        def setDeviceAdapterException(self, exception: java.lang.Exception) -> 'DeviceAdapterDriveResult.Builder': ...

class DriveResultSets:
    _find__T = _py_TypeVar('_find__T')  # <T>
    @classmethod
    def find(cls, t: _find__T, set: java.util.Set[_find__T]) -> java.util.Optional[_find__T]: ...
    _getStoredOrAdd__T = _py_TypeVar('_getStoredOrAdd__T')  # <T>
    @classmethod
    def getStoredOrAdd(cls, t: _getStoredOrAdd__T, set: java.util.Set[_getStoredOrAdd__T]) -> _getStoredOrAdd__T: ...

class JapcParameterDriveResult(java.io.Serializable, cern.accsoft.commons.util.Named):
    @classmethod
    def createFailed(cls, string: str, parameterValue: cern.japc.value.ParameterValue, parameterException: cern.japc.core.ParameterException) -> 'JapcParameterDriveResult': ...
    @classmethod
    @overload
    def createSuccessful(cls, string: str) -> 'JapcParameterDriveResult': ...
    @classmethod
    @overload
    def createSuccessful(cls, string: str, parameterValue: cern.japc.value.ParameterValue) -> 'JapcParameterDriveResult': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getException(self) -> cern.japc.core.ParameterException: ...
    def getName(self) -> str: ...
    def getParameterValue(self) -> cern.japc.value.ParameterValue: ...
    def hashCode(self) -> int: ...
    def isFailed(self) -> bool: ...
    def toString(self) -> str: ...

class LsaParameterDriveResult(cern.accsoft.commons.util.Named, java.io.Serializable):
    LOGGER: _py_ClassVar[org.slf4j.Logger] = ...
    def containsErrors(self) -> bool: ...
    @classmethod
    def create(cls, parameter: cern.lsa.domain.settings.Parameter, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> 'LsaParameterDriveResult': ...
    @classmethod
    def createFailedWithDriveValue(cls, parameter: cern.lsa.domain.settings.Parameter, immutableValue: cern.accsoft.commons.value.ImmutableValue, exception: java.lang.Exception) -> 'LsaParameterDriveResult': ...
    @classmethod
    def createFailedWithoutDriveValue(cls, parameter: cern.lsa.domain.settings.Parameter, exception: java.lang.Exception) -> 'LsaParameterDriveResult': ...
    @classmethod
    def createWithoutDriveValue(cls, parameter: cern.lsa.domain.settings.Parameter) -> 'LsaParameterDriveResult': ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAllExceptions(self) -> java.util.Set[java.lang.Exception]: ...
    def getDriveValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...
    def getJapcExceptions(self) -> java.util.Set[cern.japc.core.ParameterException]: ...
    def getJapcParameterDriveResults(self) -> java.util.Set[JapcParameterDriveResult]: ...
    def getLsaException(self) -> java.lang.Exception: ...
    def getName(self) -> str: ...
    def getParameter(self) -> cern.lsa.domain.settings.Parameter: ...
    def getStatus(self) -> 'LsaParameterDriveResult.Status': ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    class Status(java.lang.Enum['LsaParameterDriveResult.Status']):
        FAILED: _py_ClassVar['LsaParameterDriveResult.Status'] = ...
        IGNORED: _py_ClassVar['LsaParameterDriveResult.Status'] = ...
        SUCCESSFUL: _py_ClassVar['LsaParameterDriveResult.Status'] = ...
        NO_DRIVE_VALUE: _py_ClassVar['LsaParameterDriveResult.Status'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'LsaParameterDriveResult.Status': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['LsaParameterDriveResult.Status']: ...
