from typing import Any as _py_Any
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.value
import cern.japc.core
import cern.lsa.domain.commons.spi
import cern.lsa.domain.exploitation
import cern.lsa.domain.exploitation.spi.results
import cern.lsa.domain.settings
import java.io
import java.lang
import java.util


class DriveRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.exploitation.DriveRequest):
    DRIVE_FOR_NON_RESIDENT_CONTEXTS_ENABLED: _py_ClassVar[str] = ...
    STANDALONE_CONTEXT: _py_ClassVar[str] = ...
    DRIVABLE_CONTEXTS: _py_ClassVar[str] = ...
    CONTEXT_SETTINGS: _py_ClassVar[str] = ...
    PARAMETERS: _py_ClassVar[str] = ...
    COMMIT: _py_ClassVar[str] = ...
    TRANSACTION_ID: _py_ClassVar[str] = ...
    LENIENT_DRIVE: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any], map2: java.util.Map[str, _py_Any]): ...
    def containsSettings(self) -> bool: ...
    def driveAllParameters(self) -> bool: ...
    def getAttribute(self, string: str) -> _py_Any: ...
    def getAttributes(self) -> java.util.Map[str, _py_Any]: ...
    def getContextSettings(self) -> cern.lsa.domain.settings.ContextSettings: ...
    def getDrivableContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getStandAloneContext(self) -> cern.lsa.domain.settings.StandAloneContext: ...
    def getTransactionId(self) -> int: ...
    def getValue(self, parameter: cern.lsa.domain.settings.Parameter, drivableContext: cern.lsa.domain.settings.DrivableContext) -> cern.accsoft.commons.value.ImmutableValue: ...
    def isCommit(self) -> bool: ...
    def isDriveForNonResidentContextsEnabled(self) -> bool: ...
    def isLenientDrive(self) -> bool: ...
    def setAttribute(self, string: str, object: _py_Any) -> None: ...

class DriveResultImpl(cern.lsa.domain.exploitation.DriveResult, java.io.Serializable):
    def containsErrors(self) -> bool: ...
    def getAttribute(self, string: str) -> _py_Any: ...
    def getAttributes(self) -> java.util.Map[str, _py_Any]: ...
    def getContextDriveResults(self) -> java.util.Set[cern.lsa.domain.exploitation.spi.results.ContextDriveResult]: ...
    def getDrivableContexts(self) -> java.util.Set[cern.lsa.domain.settings.DrivableContext]: ...
    def getDrivenParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getExceptions(self) -> java.util.Set[java.lang.Exception]: ...
    def merge(self, driveResult: cern.lsa.domain.exploitation.DriveResult) -> cern.lsa.domain.exploitation.DriveResult: ...
    def toString(self) -> str: ...
    class Builder:
        def __init__(self): ...
        def addAttribute(self, string: str, object: _py_Any) -> 'DriveResultImpl.Builder': ...
        def addContextDriveResult(self, contextDriveResult: cern.lsa.domain.exploitation.spi.results.ContextDriveResult) -> 'DriveResultImpl.Builder': ...
        def build(self) -> cern.lsa.domain.exploitation.DriveResult: ...
        @classmethod
        def emptyResult(cls) -> 'DriveResultImpl': ...

class FailSafeImmutableValueImpl(cern.lsa.domain.exploitation.FailSafeImmutableValue, java.io.Serializable):
    @overload
    def __init__(self, string: str, immutableValue: cern.accsoft.commons.value.ImmutableValue): ...
    @overload
    def __init__(self, string: str, parameterException: cern.japc.core.ParameterException): ...
    def getException(self) -> cern.japc.core.ParameterException: ...
    def getParameterName(self) -> str: ...
    def getValue(self) -> cern.accsoft.commons.value.ImmutableValue: ...

class ReadHardwareRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.exploitation.ReadHardwareRequest):
    DRIVABLE_CONTEXT: _py_ClassVar[str] = ...
    PARAMETERS: _py_ClassVar[str] = ...
    NON_RESIDENT_CONTEXTS_ENABLED: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def areNonResidentContextsEnabled(self) -> bool: ...
    def getDrivableContext(self) -> cern.lsa.domain.settings.DrivableContext: ...
    def getParameters(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...
    def getParametersInternal(self) -> java.util.Set[cern.lsa.domain.settings.Parameter]: ...

class SettingsOnlineCheckRequestImpl(cern.lsa.domain.commons.spi.AbstractPropertiesHolder, cern.lsa.domain.exploitation.SettingsOnlineCheckRequest):
    USER: _py_ClassVar[str] = ...
    DEVICE_GROUP_NAME: _py_ClassVar[str] = ...
    PROPERTY_NAMES: _py_ClassVar[str] = ...
    DEVICE_NAMES: _py_ClassVar[str] = ...
    PARAMETER_NAMES: _py_ClassVar[str] = ...
    CHECK_TYPE: _py_ClassVar[str] = ...
    NON_RESIDENT_CONTEXTS_ENABLED: _py_ClassVar[str] = ...
    def __init__(self, map: java.util.Map[str, _py_Any]): ...
    def areNonResidentContextsEnabled(self) -> bool: ...
    def getCheckType(self) -> cern.lsa.domain.exploitation.SettingsOnlineCheckRequest.SettingsCheckType: ...
    def getDeviceGroupName(self) -> str: ...
    def getDeviceNames(self) -> java.util.Set[str]: ...
    def getParameterNames(self) -> java.util.Set[str]: ...
    def getPropertyNames(self) -> java.util.Set[str]: ...
    def getUser(self) -> str: ...
    def toString(self) -> str: ...
