from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.util
import cern.accsoft.commons.value
import java.lang.annotation
import java.util
import java.util.function


class Accelerators(java.lang.annotation.Annotation):
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def value(self) -> _py_List[_py_Type[java.util.function.Supplier[cern.accsoft.commons.domain.Accelerator]]]: ...
    class Resolver:
        @classmethod
        def anyMatch(cls, accelerator: cern.accsoft.commons.domain.Accelerator, accelerators: 'Accelerators') -> bool: ...
        @classmethod
        def getAccelerators(cls, accelerators: 'Accelerators') -> java.util.Set[cern.accsoft.commons.domain.Accelerator]: ...
        @classmethod
        def isClassApplicableForAccelerator(cls, class_: _py_Type[_py_Any], accelerator: cern.accsoft.commons.domain.Accelerator) -> bool: ...

class Attribute(cern.accsoft.commons.util.Named):
    def getAttributeDefinition(self) -> 'AttributeDefinition': ...
    def getBoolean(self) -> bool: ...
    def getDouble(self) -> float: ...
    def getInt(self) -> int: ...
    def getLong(self) -> int: ...
    def getValue(self) -> str: ...

class AttributeAware:
    def getAttribute(self, string: str) -> Attribute: ...
    def getAttributes(self) -> java.util.Set[Attribute]: ...

class AttributeWritableAware:
    def addAttribute(self, attribute: Attribute) -> None: ...
    def setAttributes(self, collection: java.util.Collection[Attribute]) -> None: ...

class Entities:
    def __init__(self): ...
    @classmethod
    @overload
    def getIds(cls, collection: java.util.Collection['IdentifiedEntity']) -> java.util.Collection[int]: ...
    @classmethod
    @overload
    def getIds(cls, list: java.util.List['IdentifiedEntity']) -> java.util.List[int]: ...
    @classmethod
    @overload
    def getIds(cls, set: java.util.Set['IdentifiedEntity']) -> java.util.Set[int]: ...
    @classmethod
    def getIdsList(cls, collection: java.util.Collection['IdentifiedEntity']) -> java.util.List[int]: ...
    @classmethod
    def getIdsSet(cls, collection: java.util.Collection['IdentifiedEntity']) -> java.util.Set[int]: ...
    @classmethod
    def idsIn(cls, collection: java.util.Collection[int]) -> cern.accsoft.commons.util.Filters.Filter['IdentifiedEntity']: ...
    _toIdsMap__V = _py_TypeVar('_toIdsMap__V', bound='IdentifiedEntity')  # <V>
    @classmethod
    def toIdsMap(cls, collection: java.util.Collection[_toIdsMap__V]) -> java.util.Map[int, _toIdsMap__V]: ...

class IdentifiedEntity:
    def getId(self) -> int: ...

class LSAConstants:
    class ContextsConstants:
        DEFAULT_CONTEXT_CATEGORY_NAME: _py_ClassVar[str] = ...
        OBSOLETE_CONTEXT_CATEGORY_NAME: _py_ClassVar[str] = ...
        def __init__(self): ...
    class CriticalPropertyConstants:
        CRITICAL_PROPERTIES_ADMIN_ROLE: _py_ClassVar[str] = ...
        SIGNATURE_FIELD_NAME: _py_ClassVar[str] = ...
        def __init__(self): ...
    class DriveConstants:
        TRANSACTION_ID_FILTER_FIELD_NAME: _py_ClassVar[str] = ...
        TRANSACTION_ID_PROPERTY: _py_ClassVar[str] = ...
        TRANSACTION_TEST_PROPERTY: _py_ClassVar[str] = ...
        TRANSACTION_COMMIT_PROPERTY: _py_ClassVar[str] = ...
        TRANSACTION_ROLLBACK_PROPERTY: _py_ClassVar[str] = ...
        def __init__(self): ...
    class JmxConstants:
        LSA_JMX_DOMAIN: _py_ClassVar[str] = ...
        def __init__(self): ...
    class LayoutConstants:
        DEFAULT_PARTICLE_TRANSFER_NAME: _py_ClassVar[str] = ...
        DEFAULT_BEAMPROCESS_TYPE_NAME: _py_ClassVar[str] = ...
    class MetaDeviceConstants:
        LSA_META_DEVICE_SUFFIX: _py_ClassVar[str] = ...
        CYCLES_PROPERTY_NAME: _py_ClassVar[str] = ...
        LSA_CONTEXT_MAPPING_PROPERTY_NAME: _py_ClassVar[str] = ...
        LSA_CONTEXT_PROPERTY_NAME: _py_ClassVar[str] = ...
        REFERENCE_UPDATE_PROPERTY_NAME: _py_ClassVar[str] = ...
        TRIM_PROPERTY_NAME: _py_ClassVar[str] = ...
        DRIVE_PROPERTY_NAME: _py_ClassVar[str] = ...
        DRIVABLE_CONTEXTS_FIELD_NAME: _py_ClassVar[str] = ...
        DRIVABLE_CONTEXT_NAME_FIELD_NAME: _py_ClassVar[str] = ...
        CONTEXT_SELECTORS_FIELD_NAME: _py_ClassVar[str] = ...
        DRIVABLE_CONTEXT_TYPE_FIELD_NAME: _py_ClassVar[str] = ...
        LIST_FIELD_NAME: _py_ClassVar[str] = ...
        PARAMETER_NAMES_FIELD_NAME: _py_ClassVar[str] = ...
        USERS_FIELD_NAME: _py_ClassVar[str] = ...
        USER_FIELD_NAME: _py_ClassVar[str] = ...
        def __init__(self): ...
    class ParameterConstants:
        SIGNATURE_PARAMETER_TYPE: _py_ClassVar[str] = ...
        KNOB_PARAMETER_TYPE: _py_ClassVar[str] = ...
        MOMENTUM_PROPERTY: _py_ClassVar[str] = ...
        MOMENTUM_PARAMETER_TYPE: _py_ClassVar[str] = ...
        DEFAULT_PARAMETER_HIERARCHY: _py_ClassVar[str] = ...
    class ParameterGroupConstants:
        NOT_USED_PARAMETER_GROUP: _py_ClassVar[str] = ...
        FAKE_NO_PARAMETER_GROUP: _py_ClassVar[str] = ...
        ALL_PARAMETER_GROUPS: _py_ClassVar[str] = ...
        def __init__(self): ...
    class ParameterUrlConstants:
        LSA_SERVER_NAMES_PREFIX: _py_ClassVar[str] = ...
        META_SERVICE_PREFIX: _py_ClassVar[str] = ...
        def __init__(self): ...
    class SettingCopyConstants:
        ATTR_IS_SETTINGS_COPY: _py_ClassVar[str] = ...
        ATTR_SOURCE_CONTEXT: _py_ClassVar[str] = ...
        ATTR_DESTINATION_TO_SOURCE_BEAMPROCESS: _py_ClassVar[str] = ...
        ATTR_TRIM_DATE: _py_ClassVar[str] = ...
        ATTR_ARCHIVE_VERSION: _py_ClassVar[str] = ...
        ATTR_COPY_ALL_PARAMETERS: _py_ClassVar[str] = ...
        ATTR_COPY_BEAM_OUT: _py_ClassVar[str] = ...
        def __init__(self): ...
    class TrimConstants:
        ATTR_CONTEXT_SETTINGS: _py_ClassVar[str] = ...
        ATTR_TRIMMED_CONTEXT_SETTINGS: _py_ClassVar[str] = ...
        ATTR_ALLOW_NON_TRIMMABLE_PARAMETERS: _py_ClassVar[str] = ...
        ATTR_PARAMETER_HIERARCHY: _py_ClassVar[str] = ...
        def __init__(self): ...

class AttributeDefinition(IdentifiedEntity, cern.accsoft.commons.util.Named):
    def getDefaultValue(self) -> str: ...
    def getDescription(self) -> str: ...
    def getEnumValues(self) -> java.util.Set[str]: ...
    def getUnits(self) -> str: ...
    def getValueType(self) -> cern.accsoft.commons.value.Type: ...
