from typing import Any as _py_Any
from typing import overload
import cern.accsoft.commons.domain
import cern.lsa.domain.cern.settings.elena
import cern.lsa.domain.cern.timing
import cern.lsa.domain.commons.spi
import java.io
import java.time
import java.util
import javax.xml.bind.annotation.adapters


class AbstractElenaCycleSegment(cern.lsa.domain.cern.settings.elena.ElenaCycleSegment, java.io.Serializable):
    def addTimingProcess(self, timingProcess: cern.lsa.domain.cern.timing.TimingProcess, duration: java.time.Duration, timingProcessAnchor: cern.lsa.domain.cern.timing.TimingProcessAnchor) -> None: ...
    def getAttribute(self, string: str) -> str: ...
    def getAttributeNames(self) -> java.util.Set[str]: ...
    def getAttributes(self) -> java.util.Set['AbstractElenaCycleSegment.Attribute']: ...
    def getHarmonicNumber(self) -> int: ...
    def getLength(self) -> java.time.Duration: ...
    def getLengthMillis(self) -> int: ...
    def getName(self) -> str: ...
    def getScheduledTimingProcesses(self) -> java.util.Set[cern.lsa.domain.cern.timing.TimingProcessScheduling]: ...
    def getStartMomentum(self) -> int: ...
    def getStartTime(self) -> java.time.Duration: ...
    def getType(self) -> cern.lsa.domain.cern.settings.elena.SegmentType: ...
    def isFirstSegmentInCycle(self) -> bool: ...
    def nextSegment(self) -> cern.lsa.domain.cern.settings.elena.ElenaCycleSegment: ...
    def previousSegment(self) -> cern.lsa.domain.cern.settings.elena.ElenaCycleSegment: ...
    def removeAttribute(self, string: str) -> None: ...
    def removeTimingProcess(self, timingProcess: cern.lsa.domain.cern.timing.TimingProcess) -> None: ...
    def setAttribute(self, string: str, string2: str) -> None: ...
    def setAttributes(self, set: java.util.Set['AbstractElenaCycleSegment.Attribute']) -> None: ...
    def setHarmonicNumber(self, int: int) -> None: ...
    def setLength(self, duration: java.time.Duration) -> None: ...
    def setLengthMillis(self, long: int) -> None: ...
    def setName(self, string: str) -> None: ...
    class Attribute: ...

class ElenaCycleSerializer:
    def __init__(self): ...
    def marshal(self, elenaCycleStructure: cern.lsa.domain.cern.settings.elena.ElenaCycleStructure) -> str: ...
    def unmarshal(self, string: str) -> 'ElenaCycleStructureImpl': ...

class ElenaCycleStructureImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedEntity['ElenaCycleStructureImpl'], cern.lsa.domain.cern.settings.elena.ElenaCycleStructure, java.io.Serializable):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, list: java.util.List[cern.lsa.domain.cern.settings.elena.ElenaCycleSegment], particleType: cern.accsoft.commons.domain.ParticleType, injectionMode: cern.lsa.domain.cern.settings.elena.InjectionMode): ...
    def getId(self) -> int: ...
    def getInjectionMode(self) -> cern.lsa.domain.cern.settings.elena.InjectionMode: ...
    def getInjectionSegment(self) -> cern.lsa.domain.cern.settings.elena.FlatSegment: ...
    def getLength(self) -> java.time.Duration: ...
    def getParticleType(self) -> cern.accsoft.commons.domain.ParticleType: ...
    def getSegments(self) -> java.util.List[cern.lsa.domain.cern.settings.elena.ElenaCycleSegment]: ...
    def getSegmentsCount(self) -> int: ...
    def getVersion(self) -> int: ...
    def insertFlatSegment(self, rampSegment: cern.lsa.domain.cern.settings.elena.RampSegment, int: int) -> cern.lsa.domain.cern.settings.elena.FlatSegment: ...
    def removeFlatSegment(self, flatSegment: cern.lsa.domain.cern.settings.elena.FlatSegment) -> None: ...
    def setInjectionMode(self, injectionMode: cern.lsa.domain.cern.settings.elena.InjectionMode) -> None: ...
    def setParticleType(self, particleType: cern.accsoft.commons.domain.ParticleType) -> None: ...
    def setSegments(self, list: java.util.List[cern.lsa.domain.cern.settings.elena.ElenaCycleSegment]) -> None: ...
    def setVersion(self, int: int) -> None: ...

class ParticleTypeToStringAdapter(javax.xml.bind.annotation.adapters.XmlAdapter[str, cern.accsoft.commons.domain.ParticleType]):
    def __init__(self): ...
    @overload
    def marshal(self, object: _py_Any) -> _py_Any: ...
    @overload
    def marshal(self, particleType: cern.accsoft.commons.domain.ParticleType) -> str: ...
    @overload
    def unmarshal(self, string: str) -> cern.accsoft.commons.domain.ParticleType: ...
    @overload
    def unmarshal(self, object: _py_Any) -> _py_Any: ...

class FlatSegmentImpl(AbstractElenaCycleSegment, cern.lsa.domain.cern.settings.elena.FlatSegment):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str, duration: java.time.Duration): ...
    def getEndMomentum(self) -> int: ...
    def getNumberOfExtractions(self) -> int: ...
    def getNumberOfInjections(self) -> int: ...
    def getPauseLocation(self) -> cern.lsa.domain.cern.settings.elena.PauseLocation: ...
    def setNumberOfExtractions(self, int: int) -> None: ...
    def setNumberOfInjections(self, int: int) -> None: ...
    def setPauseLocation(self, pauseLocation: cern.lsa.domain.cern.settings.elena.PauseLocation) -> None: ...
    def toString(self) -> str: ...

class RampSegmentImpl(AbstractElenaCycleSegment, cern.lsa.domain.cern.settings.elena.RampSegment):
    def __init__(self, duration: java.time.Duration): ...
    def getEndMomentum(self) -> int: ...
    def getFlatPartLength(self) -> java.time.Duration: ...
    def getFlatPartLengthMillis(self) -> int: ...
    def getRoundPartLength(self) -> java.time.Duration: ...
    def getRoundPartLengthMillis(self) -> int: ...
    def setEndMomentum(self, int: int) -> None: ...
    def setFlatPartLength(self, duration: java.time.Duration) -> None: ...
    def setFlatPartLengthMillis(self, long: int) -> None: ...
    def setRoundPartLength(self, duration: java.time.Duration) -> None: ...
    def setRoundPartLengthMillis(self, long: int) -> None: ...
    def toString(self) -> str: ...
