from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
import cern.accsoft.commons.domain.beams
import cern.accsoft.commons.domain.lhc
import cern.accsoft.commons.util
import cern.lsa.domain.cern.devices
import cern.lsa.domain.commons.spi
import java.io
import java.util


class BlmCrateInfoImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.cern.devices.BlmCrateInfo], cern.lsa.domain.cern.devices.BlmCrateInfo):
    def __init__(self, string: str): ...
    @classmethod
    def getBeanPropertyNameByFESAFieldName(cls, string: str) -> str: ...
    def getBlecfPresent(self) -> int: ...
    def getBlecsFirmwareVersion(self) -> int: ...
    def getBlecsSerial(self) -> int: ...
    def getBletcPresent(self) -> int: ...
    def getChannelCableConnected(self) -> _py_List[int]: ...
    def getExpertNames(self) -> _py_List[_py_List[str]]: ...
    def getHvcfcTestHv(self) -> int: ...
    def getHvcfcTestHvPeak(self) -> int: ...
    def getLastLSAModification(self) -> int: ...
    def getLhcInteractionPoint(self) -> cern.accsoft.commons.domain.lhc.LhcInteractionPoint: ...
    def getMod1GainMax(self) -> _py_List[int]: ...
    def getMod1GainMin(self) -> _py_List[int]: ...
    def getMod1Period(self) -> int: ...
    def getMod1PhaseMax(self) -> _py_List[int]: ...
    def getMod1PhaseMin(self) -> _py_List[int]: ...
    def getMod1Voltage(self) -> int: ...
    def getMod2GainMax(self) -> _py_List[int]: ...
    def getMod2GainMin(self) -> _py_List[int]: ...
    def getMod2Period(self) -> int: ...
    def getMod2PhaseMax(self) -> _py_List[int]: ...
    def getMod2PhaseMin(self) -> _py_List[int]: ...
    def getMod2Voltage(self) -> int: ...
    def getModTestHv(self) -> int: ...
    def getNormalOpHv(self) -> int: ...
    def getNormalOpHv1Hv2Diff(self) -> int: ...
    def getOfficialNames(self) -> _py_List[_py_List[str]]: ...
    def getRdacResetHv(self) -> int: ...
    def getRdacResetHvPeak(self) -> int: ...
    def getRgohResetHv(self) -> int: ...
    def getRgohResetHvPeak(self) -> int: ...
    def setBlecfSerial(self, int: int, int2: int, int3: int) -> None: ...
    def setBlecsFirmwareVersion(self, int: int) -> None: ...
    def setBlecsSerial(self, long: int) -> None: ...
    def setBletcSerial(self, int: int, int2: int, long: int) -> None: ...
    def setChannelCableConnected(self, int: int, boolean: bool) -> None: ...
    def setExpertName(self, int: int, int2: int, string: str) -> None: ...
    def setHvcfcTestHv(self, int: int) -> None: ...
    def setHvcfcTestHvPeak(self, int: int) -> None: ...
    def setLastLSAModification(self, long: int) -> None: ...
    def setLhcInteractionPoint(self, lhcInteractionPoint: cern.accsoft.commons.domain.lhc.LhcInteractionPoint) -> None: ...
    def setMod1GainMax(self, int: int, short: int) -> None: ...
    def setMod1GainMin(self, int: int, short: int) -> None: ...
    def setMod1Period(self, int: int) -> None: ...
    def setMod1PhaseMax(self, int: int, short: int) -> None: ...
    def setMod1PhaseMin(self, int: int, short: int) -> None: ...
    def setMod1Voltage(self, int: int) -> None: ...
    def setMod2GainMax(self, int: int, short: int) -> None: ...
    def setMod2GainMin(self, int: int, short: int) -> None: ...
    def setMod2Period(self, int: int) -> None: ...
    def setMod2PhaseMax(self, int: int, short: int) -> None: ...
    def setMod2PhaseMin(self, int: int, short: int) -> None: ...
    def setMod2Voltage(self, int: int) -> None: ...
    def setModTestHv(self, int: int) -> None: ...
    def setNormalOpHv(self, int: int) -> None: ...
    def setNormalOpHv1Hv2Diff(self, int: int) -> None: ...
    def setOfficialName(self, int: int, int2: int, string: str) -> None: ...
    def setRdacResetHv(self, int: int) -> None: ...
    def setRdacResetHvPeak(self, int: int) -> None: ...
    def setRgohResetHv(self, int: int) -> None: ...
    def setRgohResetHvPeak(self, int: int) -> None: ...

class BlmFamilyImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.cern.devices.BlmFamily], cern.lsa.domain.cern.devices.BlmFamily):
    def __init__(self, string: str, double: float, double2: float): ...
    def addThresholds(self, int: int, longArray: _py_List[int]) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAmpsFactor(self) -> float: ...
    def getGysFactor(self) -> float: ...
    def getThresholds(self) -> _py_List[int]: ...
    def hashCode(self) -> int: ...
    def setAmpsFactor(self, double: float) -> None: ...
    def setFamilyName(self, string: str) -> None: ...
    def setGysFactor(self, double: float) -> None: ...
    def toString(self) -> str: ...

class BlmInfoImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.cern.devices.BlmInfo], cern.lsa.domain.cern.devices.ThresholdsAwareBlmInfo, java.io.Serializable):
    SPARE_BLM_NAME_PREFIX: _py_ClassVar[str] = ...
    def __init__(self, string: str): ...
    def addAppliedThresholds(self, int: int, longArray: _py_List[int]) -> None: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getAppliedThresholds(self) -> _py_List[_py_List[int]]: ...
    def getBlecfSerial(self) -> int: ...
    def getBletcFirmwareVersion(self) -> int: ...
    def getBletcSerial(self) -> int: ...
    def getBlmFamily(self) -> cern.lsa.domain.cern.devices.BlmFamily: ...
    def getCardIndex(self) -> int: ...
    def getChannelIndex(self) -> int: ...
    def getCrateName(self) -> str: ...
    def getDcum(self) -> int: ...
    def getFilterValueCapacitor(self) -> int: ...
    def getFilterValueResistor(self) -> int: ...
    def getIncludedRunningSums(self) -> _py_List[bool]: ...
    def getLastLSAModification(self) -> int: ...
    def getLhcInteractionPoint(self) -> cern.accsoft.commons.domain.lhc.LhcInteractionPoint: ...
    def getMobileName(self) -> str: ...
    def getOfficialName(self) -> str: ...
    def hashCode(self) -> int: ...
    def isCableConnected(self) -> bool: ...
    def isConnectedToBis(self) -> bool: ...
    def isMasked(self) -> bool: ...
    def isSpare(self) -> bool: ...
    def setBlecfSerial(self, int: int) -> None: ...
    def setBletcFirmwareVersion(self, int: int) -> None: ...
    def setBletcSerial(self, long: int) -> None: ...
    def setBlmFamily(self, blmFamily: cern.lsa.domain.cern.devices.BlmFamily) -> None: ...
    def setCableConnected(self, boolean: bool) -> None: ...
    def setCardIndex(self, int: int) -> None: ...
    def setChannelIndex(self, int: int) -> None: ...
    def setConnectedToBis(self, boolean: bool) -> None: ...
    def setCrateName(self, string: str) -> None: ...
    def setDcum(self, int: int) -> None: ...
    def setFilterValueCapacitor(self, int: int) -> None: ...
    def setFilterValueResistor(self, int: int) -> None: ...
    def setIncludedRunningSums(self, booleanArray: _py_List[bool]) -> None: ...
    def setLastLSAModification(self, long: int) -> None: ...
    def setLhcInteractionPoint(self, lhcInteractionPoint: cern.accsoft.commons.domain.lhc.LhcInteractionPoint) -> None: ...
    def setMasked(self, boolean: bool) -> None: ...
    def setMobileName(self, string: str) -> None: ...
    def setOfficialName(self, string: str) -> None: ...
    def toString(self) -> str: ...

class CollimatorAlignmentImpl(cern.lsa.domain.commons.spi.AbstractIdentifiedEntity[cern.lsa.domain.cern.devices.CollimatorAlignment], cern.lsa.domain.cern.devices.CollimatorAlignment):
    def __init__(self): ...
    def getAlignmentTime(self) -> java.util.Date: ...
    def getBeamModeCategory(self) -> str: ...
    def getCollimatorName(self) -> str: ...
    def getLeftJawPos(self) -> float: ...
    def getOpticName(self) -> str: ...
    def getRightJawPos(self) -> float: ...
    def getTcp1LeftPos(self) -> float: ...
    def getTcp1RightPos(self) -> float: ...
    def getTcp2LeftPos(self) -> float: ...
    def getTcp2RightPos(self) -> float: ...
    def setAlignmentTime(self, date: java.util.Date) -> None: ...
    def setBeamModeCategory(self, string: str) -> None: ...
    def setCollimatorName(self, string: str) -> None: ...
    def setLeftJawPos(self, float: float) -> None: ...
    def setOpticName(self, string: str) -> None: ...
    def setRightJawPos(self, float: float) -> None: ...
    def setTcp1LeftPos(self, float: float) -> None: ...
    def setTcp1RightPos(self, float: float) -> None: ...
    def setTcp2LeftPos(self, float: float) -> None: ...
    def setTcp2RightPos(self, float: float) -> None: ...
    def toString(self) -> str: ...

class LhcBeamLossMapImpl(cern.lsa.domain.cern.devices.LhcBeamLossMap, java.io.Serializable):
    def __init__(self, list: java.util.List[cern.lsa.domain.cern.devices.LhcBeamLossMap.LhcBeamLossMapEntry]): ...
    def getAllEntries(self) -> java.util.List[cern.lsa.domain.cern.devices.LhcBeamLossMap.LhcBeamLossMapEntry]: ...
    def getEntry(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam, string: str, string2: str) -> cern.lsa.domain.cern.devices.LhcBeamLossMap.LhcBeamLossMapEntry: ...
    class LhcBeamLossMapEntryImpl(cern.lsa.domain.cern.devices.LhcBeamLossMap.LhcBeamLossMapEntry):
        def __init__(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam, string: str, string2: str, long: int, long2: int): ...
        def getBeam(self) -> cern.accsoft.commons.domain.beams.LhcBeam: ...
        def getBeamModeCategory(self) -> str: ...
        def getConfigType(self) -> str: ...
        def getValidFrom(self) -> int: ...
        def getValidTo(self) -> int: ...

class LhcCollimatorInfoImpl(cern.accsoft.commons.util.AbstractNamedSerializable[cern.lsa.domain.cern.devices.LhcCollimatorInfo], cern.lsa.domain.cern.devices.LhcCollimatorInfo):
    def __init__(self): ...
    def getAngle(self) -> float: ...
    def getAutoRetractionLeftDown(self) -> float: ...
    def getAutoRetractionLeftUp(self) -> float: ...
    def getAutoRetractionRightDown(self) -> float: ...
    def getAutoRetractionRightUp(self) -> float: ...
    def getAxisLeftDown(self) -> float: ...
    def getAxisLeftUp(self) -> float: ...
    def getAxisRightDown(self) -> float: ...
    def getAxisRightUp(self) -> float: ...
    def getAxisTank(self) -> float: ...
    def getBeam(self) -> cern.accsoft.commons.domain.beams.LhcBeam: ...
    def getBlmi(self) -> str: ...
    def getBlmi2(self) -> str: ...
    def getBlms(self) -> str: ...
    def getBlms2(self) -> str: ...
    def getBpmBtnAttnCoeffLeftDown(self) -> float: ...
    def getBpmBtnAttnCoeffLeftUp(self) -> float: ...
    def getBpmBtnAttnCoeffRightDown(self) -> float: ...
    def getBpmBtnAttnCoeffRightUp(self) -> float: ...
    def getBpmBtnCapacitanceLeftDown(self) -> float: ...
    def getBpmBtnCapacitanceLeftUp(self) -> float: ...
    def getBpmBtnCapacitanceRightDown(self) -> float: ...
    def getBpmBtnCapacitanceRightUp(self) -> float: ...
    def getBpmBtnDiameterLeftDown(self) -> float: ...
    def getBpmBtnDiameterLeftUp(self) -> float: ...
    def getBpmBtnDiameterRightDown(self) -> float: ...
    def getBpmBtnDiameterRightUp(self) -> float: ...
    def getBpmBtnDistToJawLeftDown(self) -> float: ...
    def getBpmBtnDistToJawLeftUp(self) -> float: ...
    def getBpmBtnDistToJawRightDown(self) -> float: ...
    def getBpmBtnDistToJawRightUp(self) -> float: ...
    def getBpmBtnDistToSfcLeftDown(self) -> float: ...
    def getBpmBtnDistToSfcLeftUp(self) -> float: ...
    def getBpmBtnDistToSfcRightDown(self) -> float: ...
    def getBpmBtnDistToSfcRightUp(self) -> float: ...
    def getBpmChannelIdLeftDown(self) -> float: ...
    def getBpmChannelIdLeftUp(self) -> float: ...
    def getBpmChannelIdRightDown(self) -> float: ...
    def getBpmChannelIdRightUp(self) -> float: ...
    def getBpmFrontEndIdDown(self) -> float: ...
    def getBpmFrontEndIdUp(self) -> float: ...
    def getBpmNameDown(self) -> str: ...
    def getBpmNameUp(self) -> str: ...
    def getCercaName(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getFamily(self) -> str: ...
    def getJawLeftDown(self) -> str: ...
    def getJawLeftUp(self) -> str: ...
    def getJawRightDown(self) -> str: ...
    def getJawRightUp(self) -> str: ...
    def getLastUpdate(self) -> java.util.Date: ...
    def getLength(self) -> float: ...
    def getMaterial(self) -> str: ...
    def getMaxFlatErrLeft(self) -> float: ...
    def getMaxFlatErrRight(self) -> float: ...
    def getMaxTiltLeftMinus(self) -> float: ...
    def getMaxTiltLeftPlus(self) -> float: ...
    def getMaxTiltRightMinus(self) -> float: ...
    def getMaxTiltRightPlus(self) -> float: ...
    def getMechPlayLeftDown(self) -> float: ...
    def getMechPlayLeftUp(self) -> float: ...
    def getMechPlayRightDown(self) -> float: ...
    def getMechPlayRightUp(self) -> float: ...
    def getMtfName(self) -> str: ...
    def getRegion(self) -> cern.lsa.domain.cern.devices.CollimatorRegion: ...
    def getScrewSerialNumberLeftDown(self) -> str: ...
    def getScrewSerialNumberLeftUp(self) -> str: ...
    def getScrewSerialNumberRightDown(self) -> str: ...
    def getScrewSerialNumberRightUp(self) -> str: ...
    def getStopAntiDown(self) -> float: ...
    def getStopAntiUp(self) -> float: ...
    def getStopLeftDownIn(self) -> float: ...
    def getStopLeftDownOut(self) -> float: ...
    def getStopLeftUpIn(self) -> float: ...
    def getStopLeftUpOut(self) -> float: ...
    def getStopRightDownIn(self) -> float: ...
    def getStopRightDownOut(self) -> float: ...
    def getStopRightUpIn(self) -> float: ...
    def getStopRightUpOut(self) -> float: ...
    def getSwitchAntiDown(self) -> float: ...
    def getSwitchAntiUp(self) -> float: ...
    def getSwitchLeftDownIn(self) -> float: ...
    def getSwitchLeftDownOut(self) -> float: ...
    def getSwitchLeftUpIn(self) -> float: ...
    def getSwitchLeftUpOut(self) -> float: ...
    def getSwitchRightDownIn(self) -> float: ...
    def getSwitchRightDownOut(self) -> float: ...
    def getSwitchRightUpIn(self) -> float: ...
    def getSwitchRightUpOut(self) -> float: ...
    def getTankCalibration(self) -> float: ...
    def getTankPosSetPoint(self) -> float: ...
    def getTankPosStopDown(self) -> float: ...
    def getTankPosStopUp(self) -> float: ...
    def getTankPosSwitchDown(self) -> float: ...
    def getTankPosSwitchUp(self) -> float: ...
    def isBpmInstalled(self) -> bool: ...
    def setAngle(self, double: float) -> None: ...
    def setAutoRetractionLeftDown(self, double: float) -> None: ...
    def setAutoRetractionLeftUp(self, double: float) -> None: ...
    def setAutoRetractionRightDown(self, double: float) -> None: ...
    def setAutoRetractionRightUp(self, double: float) -> None: ...
    def setAxisLeftDown(self, double: float) -> None: ...
    def setAxisLeftUp(self, double: float) -> None: ...
    def setAxisRightDown(self, double: float) -> None: ...
    def setAxisRightUp(self, double: float) -> None: ...
    def setAxisTank(self, double: float) -> None: ...
    def setBeam(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam) -> None: ...
    def setBlmi(self, string: str) -> None: ...
    def setBlmi2(self, string: str) -> None: ...
    def setBlms(self, string: str) -> None: ...
    def setBlms2(self, string: str) -> None: ...
    def setBpmBtnAttnCoeffLeftDown(self, double: float) -> None: ...
    def setBpmBtnAttnCoeffLeftUp(self, double: float) -> None: ...
    def setBpmBtnAttnCoeffRightDown(self, double: float) -> None: ...
    def setBpmBtnAttnCoeffRightUp(self, double: float) -> None: ...
    def setBpmBtnCapacitanceLeftDown(self, double: float) -> None: ...
    def setBpmBtnCapacitanceLeftUp(self, double: float) -> None: ...
    def setBpmBtnCapacitanceRightDown(self, double: float) -> None: ...
    def setBpmBtnCapacitanceRightUp(self, double: float) -> None: ...
    def setBpmBtnDiameterLeftDown(self, double: float) -> None: ...
    def setBpmBtnDiameterLeftUp(self, double: float) -> None: ...
    def setBpmBtnDiameterRightDown(self, double: float) -> None: ...
    def setBpmBtnDiameterRightUp(self, double: float) -> None: ...
    def setBpmBtnDistToJawLeftDown(self, double: float) -> None: ...
    def setBpmBtnDistToJawLeftUp(self, double: float) -> None: ...
    def setBpmBtnDistToJawRightDown(self, double: float) -> None: ...
    def setBpmBtnDistToJawRightUp(self, double: float) -> None: ...
    def setBpmBtnDistToSfcLeftDown(self, double: float) -> None: ...
    def setBpmBtnDistToSfcLeftUp(self, double: float) -> None: ...
    def setBpmBtnDistToSfcRightDown(self, double: float) -> None: ...
    def setBpmBtnDistToSfcRightUp(self, double: float) -> None: ...
    def setBpmChannelIdLeftDown(self, double: float) -> None: ...
    def setBpmChannelIdLeftUp(self, double: float) -> None: ...
    def setBpmChannelIdRightDown(self, double: float) -> None: ...
    def setBpmChannelIdRightUp(self, double: float) -> None: ...
    def setBpmFrontEndIdDown(self, double: float) -> None: ...
    def setBpmFrontEndIdUp(self, double: float) -> None: ...
    def setBpmInstalled(self, boolean: bool) -> None: ...
    def setBpmNameDown(self, string: str) -> None: ...
    def setBpmNameUp(self, string: str) -> None: ...
    def setCercaName(self, string: str) -> None: ...
    def setDisplayName(self, string: str) -> None: ...
    def setFamily(self, string: str) -> None: ...
    def setJawLeftDown(self, string: str) -> None: ...
    def setJawLeftUp(self, string: str) -> None: ...
    def setJawRightDown(self, string: str) -> None: ...
    def setJawRightUp(self, string: str) -> None: ...
    def setLastUpdate(self, date: java.util.Date) -> None: ...
    def setLength(self, double: float) -> None: ...
    def setMaterial(self, string: str) -> None: ...
    def setMaxFlatErrLeft(self, double: float) -> None: ...
    def setMaxFlatErrRight(self, double: float) -> None: ...
    def setMaxTiltLeftMinus(self, double: float) -> None: ...
    def setMaxTiltLeftPlus(self, double: float) -> None: ...
    def setMaxTiltRightMinus(self, double: float) -> None: ...
    def setMaxTiltRightPlus(self, double: float) -> None: ...
    def setMechPlayLeftDown(self, double: float) -> None: ...
    def setMechPlayLeftUp(self, double: float) -> None: ...
    def setMechPlayRightDown(self, double: float) -> None: ...
    def setMechPlayRightUp(self, double: float) -> None: ...
    def setMtfName(self, string: str) -> None: ...
    def setRegion(self, collimatorRegion: cern.lsa.domain.cern.devices.CollimatorRegion) -> None: ...
    def setScrewSerialNumberLeftDown(self, string: str) -> None: ...
    def setScrewSerialNumberLeftUp(self, string: str) -> None: ...
    def setScrewSerialNumberRightDown(self, string: str) -> None: ...
    def setScrewSerialNumberRightUp(self, string: str) -> None: ...
    def setStopAntiDown(self, double: float) -> None: ...
    def setStopAntiUp(self, double: float) -> None: ...
    def setStopLeftDownIn(self, double: float) -> None: ...
    def setStopLeftDownOut(self, double: float) -> None: ...
    def setStopLeftUpIn(self, double: float) -> None: ...
    def setStopLeftUpOut(self, double: float) -> None: ...
    def setStopRightDownIn(self, double: float) -> None: ...
    def setStopRightDownOut(self, double: float) -> None: ...
    def setStopRightUpIn(self, double: float) -> None: ...
    def setStopRightUpOut(self, double: float) -> None: ...
    def setSwitchAntiDown(self, double: float) -> None: ...
    def setSwitchAntiUp(self, double: float) -> None: ...
    def setSwitchLeftDownIn(self, double: float) -> None: ...
    def setSwitchLeftDownOut(self, double: float) -> None: ...
    def setSwitchLeftUpIn(self, double: float) -> None: ...
    def setSwitchLeftUpOut(self, double: float) -> None: ...
    def setSwitchRightDownIn(self, double: float) -> None: ...
    def setSwitchRightDownOut(self, double: float) -> None: ...
    def setSwitchRightUpIn(self, double: float) -> None: ...
    def setSwitchRightUpOut(self, double: float) -> None: ...
    def setTankCalibration(self, double: float) -> None: ...
    def setTankPosSetPoint(self, double: float) -> None: ...
    def setTankPosStopDown(self, double: float) -> None: ...
    def setTankPosStopUp(self, double: float) -> None: ...
    def setTankPosSwitchDown(self, double: float) -> None: ...
    def setTankPosSwitchUp(self, double: float) -> None: ...

class RfFgcChannelImpl(cern.lsa.domain.cern.devices.RfFgcChannel, java.io.Serializable):
    def __init__(self): ...
    def getChannelName(self) -> str: ...
    def getChannelNumber(self) -> int: ...
    def getDescription(self) -> str: ...
    def getFGCName(self) -> str: ...
    def getMaxSlope(self) -> float: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getParameterName(self) -> str: ...
    def getUnit(self) -> str: ...
    def setChannelName(self, string: str) -> None: ...
    def setChannelNumber(self, int: int) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setFGCName(self, string: str) -> None: ...
    def setMaxSlope(self, double: float) -> None: ...
    def setMaxValue(self, double: float) -> None: ...
    def setMinValue(self, double: float) -> None: ...
    def setParameterName(self, string: str) -> None: ...
    def setUnit(self, string: str) -> None: ...
