from typing import Any as _py_Any
from typing import Type as _py_Type
from typing import overload
import cern.japc.core
import cern.japc.core.spi.provider
import cern.japc.core.spi.transaction
import cern.japc.core.transaction
import cern.japc.value


class AcquiredParameterValueAdapter:
    def adaptValueReceived(self, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> cern.japc.core.AcquiredParameterValue: ...

class ConstantParameter(cern.japc.core.spi.transaction.AbstractTransactionalParameter):
    def __init__(self, string: str, parameterValue: cern.japc.value.ParameterValue): ...
    @overload
    def setParameterDescriptor(self, parameterDescriptor: cern.japc.core.ParameterDescriptor, descriptorProvider: cern.japc.core.spi.provider.DescriptorProvider) -> None: ...
    @overload
    def setParameterDescriptor(self, parameterDescriptor: cern.japc.core.ParameterDescriptor) -> None: ...
    @overload
    def setValueDescriptor(self, valueDescriptor: cern.japc.value.ValueDescriptor, descriptorProvider: cern.japc.core.spi.provider.DescriptorProvider) -> None: ...
    @overload
    def setValueDescriptor(self, valueDescriptor: cern.japc.value.ValueDescriptor) -> None: ...

class ParameterValueSentAdapter:
    def adaptValueSent(self, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.value.ParameterValue: ...

class ViewParameter(cern.japc.core.spi.transaction.TransactionalParameterDecorator):
    def __init__(self, string: str, transactionalParameter: cern.japc.core.transaction.TransactionalParameter, acquiredParameterValueAdapter: AcquiredParameterValueAdapter): ...
    def createSubscription(self, selector: cern.japc.core.Selector, parameterValueListener: cern.japc.core.ParameterValueListener) -> cern.japc.core.SubscriptionHandle: ...
    def getAdaptedParameter(self) -> cern.japc.core.transaction.TransactionalParameter: ...
    def getDeviceName(self) -> str: ...
    def getName(self) -> str: ...
    def getParameterDescriptor(self) -> cern.japc.core.ParameterDescriptor: ...
    def getPropertyName(self) -> str: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector) -> cern.japc.core.AcquiredParameterValue: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...
    def getValueDescriptor(self) -> cern.japc.value.ValueDescriptor: ...
    def prepareValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, compositeTransaction: cern.japc.core.transaction.CompositeTransaction) -> None: ...
    def setParameterDescriptor(self, parameterDescriptor: cern.japc.core.ParameterDescriptor) -> None: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...
    def setValueDescriptor(self, valueDescriptor: cern.japc.value.ValueDescriptor) -> None: ...
    def toString(self) -> str: ...

class VirtualParameterUtil:
    def __init__(self): ...
    @classmethod
    def createAdapterParameter(cls, string: str, string2: str, transactionalParameter: cern.japc.core.transaction.TransactionalParameter, class_: _py_Type, transactionalParameter2: cern.japc.core.transaction.TransactionalParameter, class2: _py_Type) -> 'AdapterParameter': ...
    @classmethod
    def createAdapterParameterWithAdapterInstances(cls, string: str, string2: str, transactionalParameter: cern.japc.core.transaction.TransactionalParameter, acquiredParameterValueAdapter: AcquiredParameterValueAdapter, transactionalParameter2: cern.japc.core.transaction.TransactionalParameter, parameterValueSentAdapter: ParameterValueSentAdapter) -> 'AdapterParameter': ...
    @classmethod
    def createInstance(cls, class_: _py_Type, string: str) -> _py_Any: ...
    @classmethod
    @overload
    def createViewParameter(cls, string: str, string2: str, transactionalParameter: cern.japc.core.transaction.TransactionalParameter) -> ViewParameter: ...
    @classmethod
    @overload
    def createViewParameter(cls, string: str, string2: str, transactionalParameter: cern.japc.core.transaction.TransactionalParameter, acquiredParameterValueAdapter: AcquiredParameterValueAdapter) -> ViewParameter: ...
    @classmethod
    @overload
    def createViewParameter(cls, string: str, string2: str, transactionalParameter: cern.japc.core.transaction.TransactionalParameter, class_: _py_Type) -> ViewParameter: ...

class AbstractAcquiredParameterValueAdapter(AcquiredParameterValueAdapter):
    def __init__(self, string: str): ...
    def adaptValueReceived(self, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> cern.japc.core.AcquiredParameterValue: ...

class AdapterParameter(ViewParameter):
    def __init__(self, string: str, transactionalParameter: cern.japc.core.transaction.TransactionalParameter, acquiredParameterValueAdapter: AcquiredParameterValueAdapter, transactionalParameter2: cern.japc.core.transaction.TransactionalParameter, parameterValueSentAdapter: ParameterValueSentAdapter): ...
    def prepareValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, compositeTransaction: cern.japc.core.transaction.CompositeTransaction) -> None: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...

class FieldFilteringParameterAdapter(AdapterParameter):
    def __init__(self, transactionalParameter: cern.japc.core.transaction.TransactionalParameter, string: str, string2: str): ...
    def getParameterDescriptor(self) -> cern.japc.core.ParameterDescriptor: ...
    def getValueDescriptor(self) -> cern.japc.value.ValueDescriptor: ...

class IdentityValueAdapter(AbstractAcquiredParameterValueAdapter, ParameterValueSentAdapter):
    def __init__(self, string: str): ...
    def adaptValueSent(self, parameterValue: cern.japc.value.ParameterValue) -> cern.japc.value.ParameterValue: ...
