from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.util.value
import cern.japc.value
import java.lang
import java.util


class AcquiredParameterValue:
    def getAdditionalErrors(self) -> _py_List[str]: ...
    def getDescriptor(self) -> cern.japc.value.ValueDescriptor: ...
    def getHeader(self) -> 'ValueHeader': ...
    def getParameterName(self) -> str: ...
    def getStatus(self) -> cern.japc.value.ValueStatus: ...
    def getValue(self) -> cern.japc.value.ParameterValue: ...

class DeviceDescriptor:
    IMPL_FESA: _py_ClassVar[int] = ...
    IMPL_GM: _py_ClassVar[int] = ...
    IMPL_SLEQP: _py_ClassVar[int] = ...
    IMPL_BISCOTO: _py_ClassVar[int] = ...
    IMPL_HARDWARE: _py_ClassVar[int] = ...
    IMPL_VIRTUAL: _py_ClassVar[int] = ...
    IMPL_FGC: _py_ClassVar[int] = ...
    IMPL_UNKNOWN: _py_ClassVar[int] = ...
    def getControlProperty(self) -> str: ...
    def getDescription(self) -> str: ...
    def getDeviceClassDescription(self) -> str: ...
    def getDeviceClassName(self) -> str: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getHostName(self) -> str: ...
    def getImplementation(self) -> int: ...
    def getLogicalLocation(self) -> str: ...
    def getName(self) -> str: ...
    def getResetProperty(self) -> str: ...
    def getStatusProperty(self) -> str: ...
    def getTgmName(self) -> str: ...
    def isCycleBound(self) -> bool: ...
    def isCycleDependent(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...

class ImmutableParameter(cern.accsoft.commons.util.Named):
    def createSubscription(self, selector: 'Selector', parameterValueListener: 'ParameterValueListener') -> 'SubscriptionHandle': ...
    def getDeviceName(self) -> str: ...
    def getName(self) -> str: ...
    def getParameterDescriptor(self) -> 'ParameterDescriptor': ...
    def getPropertyName(self) -> str: ...
    @overload
    def getValue(self, selector: 'Selector') -> AcquiredParameterValue: ...
    @overload
    def getValue(self, selector: 'Selector', parameterValueListener: 'ParameterValueListener') -> None: ...
    def getValueDescriptor(self) -> cern.japc.value.ValueDescriptor: ...

class ObjectDescriptor(cern.japc.value.ValueDescriptor):
    def getDescription(self) -> str: ...

class ObjectParameterValue(cern.japc.value.ParameterValue):
    def getValue(self) -> _py_Any: ...
    @overload
    def makeMutable(self) -> 'ObjectParameterValue': ...
    @overload
    def makeMutable(self) -> cern.japc.value.ParameterValue: ...
    def setValue(self, object: _py_Any) -> None: ...

class ParameterCharacteristics:
    PARAMETER_CHARACTERISTIC_ARRAY_CALL_ID: _py_ClassVar[str] = ...
    def getAdditionalInformation(self) -> java.util.Map[str, _py_Any]: ...
    def isWildcardSubscriptionParameter(self) -> bool: ...

class ParameterDescriptor:
    def getDescription(self) -> str: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getType(self) -> cern.japc.value.Type: ...
    def isCycleBound(self) -> bool: ...
    def isCycleDependent(self) -> bool: ...
    def isFilterable(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isTransactional(self) -> bool: ...
    def isValueMutable(self) -> bool: ...
    def isWritable(self) -> bool: ...

class ParameterException(java.lang.Exception):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, valueHeader: 'ValueHeader'): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, valueHeader: 'ValueHeader', int: int): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, int: int): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, long: int, selector: 'Selector'): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, long: int, selector: 'Selector', int: int): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, long: int, long2: int, selector: 'Selector'): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getCode(self) -> int: ...
    def getCycleStamp(self) -> int: ...
    def getHeader(self) -> 'ValueHeader': ...
    def getSelector(self) -> 'Selector': ...

class ParameterExplorer:
    def getAcceleratorNames(self, boolean: bool) -> _py_List[str]: ...
    def getDependentParameterNames(self, string: str) -> _py_List[str]: ...
    def getDeviceNamesForAccelerator(self, string: str, filter: 'ParameterExplorer.Filter') -> _py_List[str]: ...
    def getDeviceNamesForHost(self, string: str, filter: 'ParameterExplorer.Filter') -> _py_List[str]: ...
    def getFamilyNamesForAccelerator(self, string: str, filter: 'ParameterExplorer.Filter') -> _py_List[str]: ...
    def getFamilyNamesForHost(self, string: str, filter: 'ParameterExplorer.Filter') -> _py_List[str]: ...
    def getHostNamesForAccelerator(self, string: str, filter: 'ParameterExplorer.Filter') -> _py_List[str]: ...
    def getPropertyNameDescriptions(self, string: str) -> _py_List['ParameterExplorer.NameDescription']: ...
    def getRootParameterNames(self) -> _py_List[str]: ...
    def getSourceParameterNames(self, string: str) -> _py_List[str]: ...
    class Filter:
        def getFilteredValues(self) -> _py_List[str]: ...
    class NameDescription:
        def getDescription(self) -> str: ...
        def getName(self) -> str: ...

class ParameterRuntimeException(java.lang.RuntimeException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, exception: java.lang.Exception): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, exception: java.lang.Exception): ...

class ParameterValueListener:
    def exceptionOccured(self, string: str, string2: str, parameterException: ParameterException) -> None: ...
    def valueReceived(self, string: str, acquiredParameterValue: AcquiredParameterValue) -> None: ...

class Parameters:
    @classmethod
    def appendFieldName(cls, string: str, string2: str) -> str: ...
    @classmethod
    @overload
    def buildParameterName(cls, string: str, string2: str) -> str: ...
    @classmethod
    @overload
    def buildParameterName(cls, string: str, string2: str, string3: str) -> str: ...
    @classmethod
    def extractDeviceAndProperty(cls, string: str) -> str: ...
    @classmethod
    def extractDeviceName(cls, string: str) -> str: ...
    @classmethod
    def extractDevicesAndProperties(cls, stringArray: _py_List[str]) -> _py_List[str]: ...
    @classmethod
    def extractDistinctDevicesAndProperties(cls, collection: java.util.Collection[str]) -> java.util.Set[str]: ...
    @classmethod
    def extractFieldName(cls, string: str) -> str: ...
    @classmethod
    def extractPropertyAndField(cls, string: str) -> str: ...
    @classmethod
    def extractPropertyName(cls, string: str) -> str: ...
    @classmethod
    def getDevicePropertyNameSeparator(cls) -> str: ...
    @classmethod
    def getMaxValue(cls, string: str, selector: 'Selector') -> float: ...
    @classmethod
    def getMinValue(cls, string: str, selector: 'Selector') -> float: ...
    @classmethod
    def getPropertyFieldSeparator(cls) -> str: ...
    @classmethod
    def getUnit(cls, string: str, selector: 'Selector') -> str: ...
    @classmethod
    def hasFieldName(cls, string: str) -> bool: ...
    @classmethod
    @overload
    def isParameterName(cls, string: str) -> bool: ...
    @classmethod
    @overload
    def isParameterName(cls, string: str, boolean: bool) -> bool: ...

class Selector:
    PERIODIC_PULLING: _py_ClassVar[str] = ...
    PERIODIC_2SEC: _py_ClassVar[str] = ...
    PERIODIC_4SEC: _py_ClassVar[str] = ...
    PERIODIC_16SEC: _py_ClassVar[str] = ...
    PERIODIC_64SEC: _py_ClassVar[str] = ...
    PERIODIC_256SEC: _py_ClassVar[str] = ...
    def getDataFilter(self) -> cern.japc.value.ParameterValue: ...
    def getId(self) -> str: ...
    def getPeriod(self) -> int: ...
    def isPeriodic(self) -> bool: ...

class Selectors:
    NO_SELECTOR: _py_ClassVar[Selector] = ...
    NON_PPM_SELECTOR: _py_ClassVar[Selector] = ...
    USER_ALL_SUFFIX: _py_ClassVar[str] = ...
    @classmethod
    def adapt(cls, selector: Selector) -> 'Selectors.OngoingSelectorAdaptation': ...
    @classmethod
    def adaptIfPossible(cls, selector: Selector) -> 'Selectors.OngoingSelectorAdaptation': ...
    @classmethod
    def assertSelectorIdValid(cls, string: str) -> None: ...
    @classmethod
    def assertSelectorValid(cls, selector: Selector) -> None: ...
    @classmethod
    @overload
    def createUserAllSelector(cls, string: str) -> Selector: ...
    @classmethod
    @overload
    def createUserAllSelector(cls, string: str, parameterValue: cern.japc.value.ParameterValue) -> Selector: ...
    @classmethod
    def createUserAllSelectorId(cls, string: str) -> str: ...
    @classmethod
    @overload
    def extractTimingDomain(cls, selector: Selector) -> str: ...
    @classmethod
    @overload
    def extractTimingDomain(cls, string: str) -> str: ...
    @classmethod
    def isNoSelector(cls, selector: Selector) -> bool: ...
    @classmethod
    def isNoSelectorId(cls, string: str) -> bool: ...
    @classmethod
    @overload
    def isUserAllSelector(cls, selector: Selector) -> bool: ...
    @classmethod
    @overload
    def isUserAllSelector(cls, string: str) -> bool: ...
    @classmethod
    def isUserAllSelectorId(cls, string: str) -> bool: ...
    @classmethod
    def isUserSelector(cls, selector: Selector) -> bool: ...
    @classmethod
    def isUserSelectorId(cls, string: str) -> bool: ...
    class OngoingSelectorAdaptation:
        def to(self, immutableParameter: ImmutableParameter) -> Selector: ...

class SubscriptionConfigurator:
    PUSH_MODE: _py_ClassVar[int] = ...
    PULL_MODE: _py_ClassVar[int] = ...
    def getDataDeliveryMode(self) -> int: ...
    def getSelector(self) -> Selector: ...
    def setDataDeliveryMode(self, int: int) -> None: ...

class ValueHeader:
    def getAcqStamp(self) -> int: ...
    def getAcqStampMillis(self) -> int: ...
    def getCycleStamp(self) -> int: ...
    def getCycleStampMillis(self) -> int: ...
    def getSelector(self) -> Selector: ...
    def getSetStamp(self) -> int: ...
    def getSetStampMillis(self) -> int: ...
    def isFirstUpdate(self) -> bool: ...
    def isImmediateUpdate(self) -> bool: ...

class AuthorizationExpiredException(ParameterException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class FailSafeParameterValue(AcquiredParameterValue, cern.accsoft.commons.util.value.FailSafe[ParameterException, AcquiredParameterValue]):
    def getException(self) -> ParameterException: ...
    def getString(self) -> str: ...

class MapParameterDescriptor(ParameterDescriptor):
    def get(self, string: str) -> 'SimpleParameterDescriptor': ...
    def getNames(self) -> _py_List[str]: ...
    def size(self) -> int: ...

class NoDataAvailableException(ParameterException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, selector: Selector): ...
    @overload
    def __init__(self, string: str, valueHeader: ValueHeader): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, selector: Selector): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, valueHeader: ValueHeader): ...

class NoValueException(ParameterException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, valueHeader: ValueHeader): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, valueHeader: ValueHeader): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, long: int, selector: Selector): ...
    @overload
    def __init__(self, string: str, long: int): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class Parameter(ImmutableParameter):
    @overload
    def setValue(self, selector: Selector, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    @overload
    def setValue(self, selector: Selector, parameterValue: cern.japc.value.ParameterValue, parameterValueListener: ParameterValueListener) -> None: ...

class SubscriptionHandle(SubscriptionConfigurator):
    def getListener(self) -> ParameterValueListener: ...
    def getParameter(self) -> ImmutableParameter: ...
    def isMonitoring(self) -> bool: ...
    def peekValue(self, long: int) -> AcquiredParameterValue: ...
    def startMonitoring(self) -> None: ...
    def stopMonitoring(self) -> None: ...

class SubscriptionProblemException(ParameterException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable, valueHeader: ValueHeader): ...

class SubscriptionRecoveredException(ParameterException):
    def __init__(self, string: str): ...

class WaitingForDataException(ParameterException):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SimpleParameterDescriptor(MapParameterDescriptor): ...
