from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util
import cern.accsoft.commons.util.value
import cern.accsoft.commons.value.expression
import cern.accsoft.commons.value.operation
import cern.accsoft.commons.value.spi.function
import cern.accsoft.commons.value.spi.operation
import cern.japc.value
import java.io
import java.lang
import java.util


class BoundedPolynomials:
    @classmethod
    @overload
    def createBoundedPolynomialSequence(cls, boundedPolynomialArray: _py_List['BoundedPolynomial']) -> 'BoundedPolynomialSequence': ...
    @classmethod
    @overload
    def createBoundedPolynomialSequence(cls, collection: java.util.Collection['BoundedPolynomial']) -> 'BoundedPolynomialSequence': ...
    @classmethod
    def createLinearBoundedPolynomialSequence(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> 'BoundedPolynomialSequence': ...
    @classmethod
    @overload
    def forAbsoluteBoundedPolynomial(cls, polynomial: 'Polynomial', interval: 'Interval') -> 'BoundedPolynomial': ...
    @classmethod
    @overload
    def forAbsoluteBoundedPolynomial(cls, polynomial: 'Polynomial', double: float, double2: float) -> 'BoundedPolynomial': ...
    @classmethod
    @overload
    def forRelativeBoundedPolynomial(cls, polynomial: 'Polynomial', interval: 'Interval') -> 'BoundedPolynomial': ...
    @classmethod
    @overload
    def forRelativeBoundedPolynomial(cls, polynomial: 'Polynomial', double: float, double2: float) -> 'BoundedPolynomial': ...
    @classmethod
    @overload
    def getIntervals(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence') -> _py_List['Interval']: ...
    @classmethod
    @overload
    def getIntervals(cls, boundedPolynomialArray: _py_List['BoundedPolynomial']) -> _py_List['Interval']: ...
    @classmethod
    @overload
    def getLength(cls, boundedPolynomial: 'BoundedPolynomial') -> float: ...
    @classmethod
    @overload
    def getLength(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence') -> float: ...
    @classmethod
    def isContinue(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence', boundedPolynomialSequence2: 'BoundedPolynomialSequence') -> bool: ...
    @classmethod
    def isContinueWith(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence', boundedPolynomialSequence2: 'BoundedPolynomialSequence', double: float) -> bool: ...
    @classmethod
    def toAbsolutePolynomial(cls, boundedPolynomial: 'BoundedPolynomial') -> 'Polynomial': ...
    @classmethod
    def toAbsolutePolynomials(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence') -> _py_List['Polynomial']: ...
    @classmethod
    @overload
    def toDiscreteFunction(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence') -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def toDiscreteFunction(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence', double: float) -> 'DiscreteFunction': ...
    @classmethod
    def toRelativePolynomial(cls, boundedPolynomial: 'BoundedPolynomial') -> 'Polynomial': ...
    @classmethod
    def toRelativePolynomials(cls, boundedPolynomialSequence: 'BoundedPolynomialSequence') -> _py_List['Polynomial']: ...

class DiscreteFunctionCompressor:
    @overload
    def __init__(self, discreteFunction: 'DiscreteFunction', int: int): ...
    @overload
    def __init__(self, discreteFunction: 'DiscreteFunction', int: int, int2: int, int3: int, int4: int, float: float): ...
    def compressFunction(self) -> 'DiscreteFunction': ...

class DiscreteFunctions:
    DEFAULT_SHIFT_COMPENSATION_FACTOR: _py_ClassVar[float] = ...
    @classmethod
    def align(cls, discreteFunction: 'DiscreteFunction', int: int, int2: int) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def buildDiscreteFunctionList(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> cern.japc.value.DiscreteFunctionList: ...
    @classmethod
    @overload
    def buildDiscreteFunctionList(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float], intArray: _py_List[int]) -> cern.japc.value.DiscreteFunctionList: ...
    @classmethod
    @overload
    def compare(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', immutableDiscreteFunction2: 'ImmutableDiscreteFunction') -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def compare(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', immutableDiscreteFunction2: 'ImmutableDiscreteFunction', double: float) -> 'DiscreteFunction': ...
    @classmethod
    def computeDerivative(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', approximationMode: 'DiscreteFunctions.ApproximationMode') -> 'DiscreteFunction': ...
    @classmethod
    def computeIntegral(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> float: ...
    @classmethod
    def computeTotalSize(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> int: ...
    @classmethod
    def concat(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', immutableDiscreteFunction2: 'ImmutableDiscreteFunction') -> 'DiscreteFunction': ...
    @classmethod
    def containsNaN(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> bool: ...
    @classmethod
    def convertFromJAPCFunction(cls, discreteFunction: cern.japc.value.DiscreteFunction) -> 'ImmutableDiscreteFunction': ...
    @classmethod
    def convertFromJAPCFunctionList(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> 'ImmutableDiscreteFunctionList': ...
    @classmethod
    def convertToJAPCFunction(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> cern.japc.value.DiscreteFunction: ...
    @classmethod
    def convertToJAPCFunctionList(cls, immutableDiscreteFunctionList: 'ImmutableDiscreteFunctionList') -> cern.japc.value.DiscreteFunctionList: ...
    @classmethod
    def createConstantDiscreteFunction(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def dx(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', int: int) -> float: ...
    @classmethod
    @overload
    def dx(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', int: int, int2: int) -> float: ...
    @classmethod
    @overload
    def dy(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', int: int) -> float: ...
    @classmethod
    @overload
    def dy(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', int: int, int2: int) -> float: ...
    @classmethod
    @overload
    def extractXArray(cls, immutableDiscreteFunctionList: 'ImmutableDiscreteFunctionList') -> _py_List[float]: ...
    @classmethod
    @overload
    def extractXArray(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> _py_List[float]: ...
    @classmethod
    @overload
    def extractYArray(cls, immutableDiscreteFunctionList: 'ImmutableDiscreteFunctionList') -> _py_List[float]: ...
    @classmethod
    @overload
    def extractYArray(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> _py_List[float]: ...
    @classmethod
    @overload
    def filter(cls, discreteFunction: 'DiscreteFunction', double: float) -> 'DiscreteFunctions.FilterResult': ...
    @classmethod
    @overload
    def filter(cls, discreteFunction: 'DiscreteFunction', double: float, interval: 'Interval') -> 'DiscreteFunctions.FilterResult': ...
    @classmethod
    @overload
    def filterByXCoordinate(cls, discreteFunction: 'DiscreteFunction', double: float) -> None: ...
    @classmethod
    @overload
    def filterByXCoordinate(cls, discreteFunction: 'DiscreteFunction', double: float, double2: float) -> None: ...
    @classmethod
    def filterFractionalXCoordinates(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> 'ImmutableDiscreteFunction': ...
    @classmethod
    @overload
    def filterRamerDouglasPeucker(cls, discreteFunction: 'DiscreteFunction', double: float) -> 'DiscreteFunctions.FilterResult': ...
    @classmethod
    @overload
    def filterRamerDouglasPeucker(cls, discreteFunction: 'DiscreteFunction', double: float, interval: 'Interval') -> 'DiscreteFunctions.FilterResult': ...
    @classmethod
    def getAbsoluteFunction(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList, int: int) -> cern.japc.value.DiscreteFunction: ...
    @classmethod
    def getAllXforY(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> java.util.SortedSet[float]: ...
    @classmethod
    @overload
    def getAvailableConstantSpaceAtBeginning(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> float: ...
    @classmethod
    @overload
    def getAvailableConstantSpaceAtBeginning(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> float: ...
    @classmethod
    @overload
    def getAvailableConstantSpaceAtEnd(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> float: ...
    @classmethod
    @overload
    def getAvailableConstantSpaceAtEnd(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> float: ...
    @classmethod
    def getSplitIndices(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> _py_List[int]: ...
    @classmethod
    def getXforY(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> float: ...
    @classmethod
    @overload
    def hasSameLength(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', int: int) -> bool: ...
    @classmethod
    @overload
    def hasSameLength(cls, immutableDiscreteFunctionsArray: 'ImmutableDiscreteFunctionsArray', int: int) -> bool: ...
    @classmethod
    def inRange(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> bool: ...
    @classmethod
    def indexOf(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float, double2: float) -> int: ...
    @classmethod
    def integrate(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> 'DiscreteFunction': ...
    @classmethod
    def interpolate(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> float: ...
    @classmethod
    @overload
    def isConstant(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> bool: ...
    @classmethod
    @overload
    def isConstant(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> bool: ...
    @classmethod
    @overload
    def isConstant(cls, immutableDiscreteFunctionsArray: 'ImmutableDiscreteFunctionsArray') -> bool: ...
    @classmethod
    @overload
    def isConstant(cls, immutableDiscreteFunctionsArray: 'ImmutableDiscreteFunctionsArray', double: float) -> bool: ...
    @classmethod
    @overload
    def isContinue(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', immutableDiscreteFunction2: 'ImmutableDiscreteFunction') -> bool: ...
    @classmethod
    @overload
    def isContinue(cls, immutableDiscreteFunctionsArray: 'ImmutableDiscreteFunctionsArray', immutableDiscreteFunctionsArray2: 'ImmutableDiscreteFunctionsArray') -> bool: ...
    @classmethod
    @overload
    def isContinueWith(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', immutableDiscreteFunction2: 'ImmutableDiscreteFunction', double: float) -> bool: ...
    @classmethod
    @overload
    def isContinueWith(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', immutableDiscreteFunction2: 'ImmutableDiscreteFunction', double: float, double2: float) -> bool: ...
    @classmethod
    @overload
    def isEmpty(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> bool: ...
    @classmethod
    @overload
    def isEmpty(cls, immutableDiscreteFunctionsArray: 'ImmutableDiscreteFunctionsArray') -> bool: ...
    @classmethod
    def isMonotonic(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> bool: ...
    @classmethod
    def isStriclyAscending(cls, doubleArray: _py_List[float]) -> bool: ...
    @classmethod
    def isStrictlyMonotonic(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> bool: ...
    @classmethod
    @overload
    def isZero(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> bool: ...
    @classmethod
    @overload
    def isZero(cls, immutableDiscreteFunctionsArray: 'ImmutableDiscreteFunctionsArray') -> bool: ...
    @classmethod
    def max(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> float: ...
    @classmethod
    def maxCoordinates(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> cern.accsoft.commons.util.value.Pair[float, java.util.SortedSet[float]]: ...
    @classmethod
    def min(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> float: ...
    @classmethod
    def minCoordinates(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction') -> cern.accsoft.commons.util.value.Pair[float, java.util.SortedSet[float]]: ...
    @classmethod
    def normalizeByXCoordinates(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float, double2: float) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def reduceFunctionPoints(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', int: int) -> 'ImmutableDiscreteFunction': ...
    @classmethod
    @overload
    def reduceFunctionPoints(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', int: int, double: float) -> 'ImmutableDiscreteFunction': ...
    @classmethod
    @overload
    def shift(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> 'ImmutableDiscreteFunction': ...
    @classmethod
    @overload
    def shift(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float, double2: float) -> 'ImmutableDiscreteFunction': ...
    @classmethod
    def toArray(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> _py_List[cern.japc.value.DiscreteFunction]: ...
    @classmethod
    def toXArray(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> _py_List[float]: ...
    @classmethod
    def toYArray(cls, discreteFunctionList: cern.japc.value.DiscreteFunctionList) -> _py_List[float]: ...
    class ApproximationMode(java.lang.Enum['DiscreteFunctions.ApproximationMode']):
        FORWARD: _py_ClassVar['DiscreteFunctions.ApproximationMode'] = ...
        BACKWARD: _py_ClassVar['DiscreteFunctions.ApproximationMode'] = ...
        CENTERED: _py_ClassVar['DiscreteFunctions.ApproximationMode'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'DiscreteFunctions.ApproximationMode': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['DiscreteFunctions.ApproximationMode']: ...
    class FilterResult(java.lang.Enum['DiscreteFunctions.FilterResult']):
        FILTERED: _py_ClassVar['DiscreteFunctions.FilterResult'] = ...
        NOT_FILTERED: _py_ClassVar['DiscreteFunctions.FilterResult'] = ...
        ONLY_FLAT_TOPS: _py_ClassVar['DiscreteFunctions.FilterResult'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'DiscreteFunctions.FilterResult': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['DiscreteFunctions.FilterResult']: ...

class FunctionOperationException(java.lang.RuntimeException):
    def __init__(self, string: str): ...

class Indexed:
    def execute(self, indexing: cern.accsoft.commons.value.spi.operation.Indexing) -> 'Scalar': ...

class Interpolable:
    def interpolate(self, double: float) -> float: ...

class Interval(java.io.Serializable):
    INFINITY: _py_ClassVar['Interval'] = ...
    BOUNDS_COMPARATOR: _py_ClassVar[java.util.Comparator] = ...
    def __init__(self, double: float, double2: float): ...
    def compareByBoundsTo(self, interval: 'Interval') -> int: ...
    def compareTo(self, interval: 'Interval') -> int: ...
    def contains(self, double: float) -> bool: ...
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    def gapIntervals(cls, intervalArray: _py_List['Interval']) -> _py_List['Interval']: ...
    def getLength(self) -> float: ...
    def getLowerBound(self) -> float: ...
    def getUpperBound(self) -> float: ...
    def hashCode(self) -> int: ...
    def intersects(self, interval: 'Interval') -> bool: ...
    def isAdjacentTo(self, interval: 'Interval') -> bool: ...
    @classmethod
    def of(cls, double: float, double2: float) -> 'Interval': ...
    def overlaps(self, interval: 'Interval') -> bool: ...
    @classmethod
    def span(cls, intervalArray: _py_List['Interval']) -> 'Interval': ...
    def toString(self) -> str: ...

class Operations:
    @classmethod
    def abs(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def absNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def acos(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def acosNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    @overload
    def add(cls, immutableValue: 'ImmutableValue', immutableValue2: 'ImmutableValue') -> 'Value': ...
    @classmethod
    @overload
    def add(cls, immutableValue: 'ImmutableValue', double: float) -> 'Value': ...
    @classmethod
    @overload
    def addNoCopy(cls, value: 'Value', immutableValue: 'ImmutableValue') -> None: ...
    @classmethod
    @overload
    def addNoCopy(cls, value: 'Value', double: float) -> None: ...
    @classmethod
    def asin(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def asinNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def atan(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def atanNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def ceil(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def ceilNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def cos(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def cosNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    @overload
    def divide(cls, immutableValue: 'ImmutableValue', immutableValue2: 'ImmutableValue') -> 'Value': ...
    @classmethod
    @overload
    def divide(cls, immutableValue: 'ImmutableValue', double: float) -> 'Value': ...
    @classmethod
    @overload
    def divideNoCopy(cls, value: 'Value', immutableValue: 'ImmutableValue') -> None: ...
    @classmethod
    @overload
    def divideNoCopy(cls, value: 'Value', double: float) -> None: ...
    @classmethod
    def floor(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def floorNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def log(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def log10(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def log10NoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def logNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def mathNoCopy(cls, value: 'Value', string: str) -> None: ...
    @classmethod
    @overload
    def multiply(cls, immutableValue: 'ImmutableValue', immutableValue2: 'ImmutableValue') -> 'Value': ...
    @classmethod
    @overload
    def multiply(cls, immutableValue: 'ImmutableValue', double: float) -> 'Value': ...
    @classmethod
    @overload
    def multiplyNoCopy(cls, value: 'Value', immutableValue: 'ImmutableValue') -> None: ...
    @classmethod
    @overload
    def multiplyNoCopy(cls, value: 'Value', double: float) -> None: ...
    @classmethod
    def pow2(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def pow2NoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    @overload
    def power(cls, immutableValue: 'ImmutableValue', immutableValue2: 'ImmutableValue') -> 'Value': ...
    @classmethod
    @overload
    def power(cls, immutableValue: 'ImmutableValue', double: float) -> 'Value': ...
    @classmethod
    @overload
    def powerNoCopy(cls, value: 'Value', immutableValue: 'ImmutableValue') -> None: ...
    @classmethod
    @overload
    def powerNoCopy(cls, value: 'Value', double: float) -> None: ...
    @classmethod
    def rint(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def rintNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def round(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def roundNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def sin(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def sinNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    def sqrt(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def sqrtNoCopy(cls, value: 'Value') -> None: ...
    @classmethod
    @overload
    def subtract(cls, immutableValue: 'ImmutableValue', immutableValue2: 'ImmutableValue') -> 'Value': ...
    @classmethod
    @overload
    def subtract(cls, immutableValue: 'ImmutableValue', double: float) -> 'Value': ...
    @classmethod
    @overload
    def subtractNoCopy(cls, value: 'Value', immutableValue: 'ImmutableValue') -> None: ...
    @classmethod
    @overload
    def subtractNoCopy(cls, value: 'Value', double: float) -> None: ...
    @classmethod
    def tan(cls, immutableValue: 'ImmutableValue') -> 'Value': ...
    @classmethod
    def tanNoCopy(cls, value: 'Value') -> None: ...

class ParabolicSplineFunction(cern.accsoft.commons.value.spi.function.AbstractMathFunction):
    def __init__(self, immutableDiscreteFunction: 'ImmutableDiscreteFunction'): ...
    def getFunction(self) -> 'ImmutableDiscreteFunction': ...
    def getSplineX(self, int: int) -> float: ...

class ScalarArrays:
    @classmethod
    def isContinueWith(cls, immutableScalarArray: 'ImmutableScalarArray', immutableScalarArray2: 'ImmutableScalarArray', double: float) -> bool: ...

class Type(java.lang.Enum['Type'], cern.accsoft.commons.util.Named):
    FUNCTION: _py_ClassVar['Type'] = ...
    POINT: _py_ClassVar['Type'] = ...
    EXPRESSION_BASED_FUNCTION: _py_ClassVar['Type'] = ...
    FUNCTION_LIST: _py_ClassVar['Type'] = ...
    FUNCTIONS_ARRAY: _py_ClassVar['Type'] = ...
    POLYNOMIAL: _py_ClassVar['Type'] = ...
    BOUNDED_POLYNOMIAL: _py_ClassVar['Type'] = ...
    BOUNDED_POLYNOMIAL_SEQUENCE: _py_ClassVar['Type'] = ...
    BOOLEAN: _py_ClassVar['Type'] = ...
    BYTE: _py_ClassVar['Type'] = ...
    DOUBLE: _py_ClassVar['Type'] = ...
    FLOAT: _py_ClassVar['Type'] = ...
    LONG: _py_ClassVar['Type'] = ...
    INT: _py_ClassVar['Type'] = ...
    SHORT: _py_ClassVar['Type'] = ...
    STRING: _py_ClassVar['Type'] = ...
    TEXT_DOCUMENT: _py_ClassVar['Type'] = ...
    BOOLEAN_ARRAY: _py_ClassVar['Type'] = ...
    BYTE_ARRAY: _py_ClassVar['Type'] = ...
    DOUBLE_ARRAY: _py_ClassVar['Type'] = ...
    FLOAT_ARRAY: _py_ClassVar['Type'] = ...
    INT_ARRAY: _py_ClassVar['Type'] = ...
    LONG_ARRAY: _py_ClassVar['Type'] = ...
    SHORT_ARRAY: _py_ClassVar['Type'] = ...
    STRING_ARRAY: _py_ClassVar['Type'] = ...
    BOOLEAN_ARRAY_2D: _py_ClassVar['Type'] = ...
    BYTE_ARRAY_2D: _py_ClassVar['Type'] = ...
    DOUBLE_ARRAY_2D: _py_ClassVar['Type'] = ...
    FLOAT_ARRAY_2D: _py_ClassVar['Type'] = ...
    INT_ARRAY_2D: _py_ClassVar['Type'] = ...
    LONG_ARRAY_2D: _py_ClassVar['Type'] = ...
    SHORT_ARRAY_2D: _py_ClassVar['Type'] = ...
    STRING_ARRAY_2D: _py_ClassVar['Type'] = ...
    ENUM: _py_ClassVar['Type'] = ...
    ENUM_ARRAY: _py_ClassVar['Type'] = ...
    ENUM_ARRAY_2D: _py_ClassVar['Type'] = ...
    ENUM_SET: _py_ClassVar['Type'] = ...
    ENUM_SET_ARRAY: _py_ClassVar['Type'] = ...
    ENUM_SET_ARRAY_2D: _py_ClassVar['Type'] = ...
    UNDEFINED: _py_ClassVar['Type'] = ...
    @classmethod
    def convertEnumTypeToPrimitiveType(cls, type: 'Type', enumType: cern.japc.value.EnumType) -> 'Type': ...
    @classmethod
    def convertToArray2DType(cls, type: 'Type') -> 'Type': ...
    @classmethod
    def convertToArrayType(cls, type: 'Type') -> 'Type': ...
    @classmethod
    def convertToScalarType(cls, type: 'Type') -> 'Type': ...
    def getName(self) -> str: ...
    @classmethod
    def getObjectType(cls, object: _py_Any) -> 'Type': ...
    def isArray(self) -> bool: ...
    def isArray2D(self) -> bool: ...
    @classmethod
    def isBooleanType(cls, type: 'Type') -> bool: ...
    def isDiscrete(self) -> bool: ...
    @classmethod
    def isDiscreteType(cls, type: 'Type') -> bool: ...
    def isEnum(self) -> bool: ...
    def isEnumSet(self) -> bool: ...
    @classmethod
    def isEnumSetType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isEnumType(cls, type: 'Type') -> bool: ...
    def isEnumeric(self) -> bool: ...
    @classmethod
    def isEnumericType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isFloatingType(cls, type: 'Type') -> bool: ...
    def isFunction(self) -> bool: ...
    def isFunctionList(self) -> bool: ...
    @classmethod
    def isFunctionListType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isFunctionType(cls, type: 'Type') -> bool: ...
    def isFunctionsArray(self) -> bool: ...
    @classmethod
    def isFunctionsArrayType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isNumberArray2DType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isNumberArrayType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isNumberType(cls, type: 'Type') -> bool: ...
    def isScalar(self) -> bool: ...
    @classmethod
    def isScalarArray2DType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isScalarArrayType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isScalarType(cls, type: 'Type') -> bool: ...
    @classmethod
    def isStringType(cls, type: 'Type') -> bool: ...
    @classmethod
    @overload
    def valueOf(cls, valueType: cern.japc.value.ValueType) -> 'Type': ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'Type': ...
    _valueOf_2__T = _py_TypeVar('_valueOf_2__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_2__T], string: str) -> _valueOf_2__T: ...
    @classmethod
    def values(cls) -> _py_List['Type']: ...

class Typed:
    def getType(self) -> Type: ...

class ValueDescriptor(java.io.Serializable, java.lang.Cloneable):
    def clone(self) -> 'ValueDescriptor': ...
    def containsMeanings(self) -> bool: ...
    def getAbsoluteTolerance(self) -> float: ...
    def getBooleanType(self) -> cern.japc.value.BooleanType: ...
    def getColumnCount(self) -> int: ...
    def getEnumType(self) -> cern.japc.value.EnumType: ...
    def getMax(self) -> float: ...
    def getMeaning(self, object: _py_Any) -> cern.japc.value.SimpleValueStandardMeaning: ...
    def getMin(self) -> float: ...
    def getRelativeTolerance(self) -> float: ...
    def getRowCount(self) -> int: ...
    def getXPrecision(self) -> int: ...
    def getXUnit(self) -> str: ...
    def getYPrecision(self) -> int: ...
    def getYUnit(self) -> str: ...
    def isSettable(self, object: _py_Any) -> bool: ...
    class ValueCompareType(java.lang.Enum['ValueDescriptor.ValueCompareType']):
        EXACT_MEANING: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        TOL_REL: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        TOL_ABS: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        EXACT_WITH_RES: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        EXACT: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        TOL_ABS_REL: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        TOL_ABS_MOD360: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        NONE: _py_ClassVar['ValueDescriptor.ValueCompareType'] = ...
        @classmethod
        @overload
        def valueOf(cls, string: str) -> 'ValueDescriptor.ValueCompareType': ...
        _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @classmethod
        @overload
        def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @classmethod
        def values(cls) -> _py_List['ValueDescriptor.ValueCompareType']: ...

class ValueFactory:
    @classmethod
    def convertToDiscreteFunction(cls, immutableScalarArray: 'ImmutableScalarArray') -> 'DiscreteFunction': ...
    @classmethod
    def createConstantFunction(cls, double: float, double2: float) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createDiscreteFunctionList(cls) -> 'DiscreteFunctionList': ...
    @classmethod
    @overload
    def createDiscreteFunctionList(cls, immutableDiscreteFunctionArray: _py_List['ImmutableDiscreteFunction']) -> 'DiscreteFunctionList': ...
    @classmethod
    @overload
    def createDiscreteFunctionList(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float], intArray: _py_List[int]) -> 'DiscreteFunctionList': ...
    @classmethod
    @overload
    def createDiscreteFunctionsArray(cls) -> 'DiscreteFunctionsArray': ...
    @classmethod
    @overload
    def createDiscreteFunctionsArray(cls, immutableDiscreteFunctionArray: _py_List['ImmutableDiscreteFunction']) -> 'DiscreteFunctionsArray': ...
    @classmethod
    @overload
    def createFunction(cls, immutablePointArray: _py_List['ImmutablePoint']) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, immutableValue: 'ImmutableValue') -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, interpolable: Interpolable, double: float, int2: int, double2: float, double3: float) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, interpolable: Interpolable, doubleArray: _py_List[float]) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, interpolable: Interpolable, int2: int, double: float, double2: float) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, interpolable: Interpolable, double: float, int2: int, double2: float, double3: float, integer: int, double4: float, double5: float) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, pointArray: _py_List['Point']) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float], boolean: bool) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, intArray: _py_List[int], doubleArray: _py_List[float]) -> 'DiscreteFunction': ...
    @classmethod
    @overload
    def createFunction(cls, string: str) -> cern.accsoft.commons.value.spi.function.ExpressionBasedFunction: ...
    @classmethod
    def createLinearBoundedPolynomialSequence(cls, doubleArray: _py_List[float], doubleArray2: _py_List[float]) -> 'BoundedPolynomialSequence': ...
    @classmethod
    @overload
    def createMonomial(cls, int: int) -> 'Polynomial': ...
    @classmethod
    @overload
    def createMonomial(cls, int: int, double: float) -> 'Polynomial': ...
    @classmethod
    @overload
    def createPoint(cls, immutableValue: 'ImmutableValue') -> 'Point': ...
    @classmethod
    @overload
    def createPoint(cls, double: float, double2: float) -> 'Point': ...
    @classmethod
    @overload
    def createPolynomial(cls, doubleArray: _py_List[float]) -> 'Polynomial': ...
    @classmethod
    @overload
    def createPolynomial(cls, collection: java.util.Collection[float]) -> 'Polynomial': ...
    @classmethod
    @overload
    def createPolynomial(cls, sortedMap: java.util.SortedMap[int, float]) -> 'Polynomial': ...
    @classmethod
    @overload
    def createScalar(cls, boolean: bool) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, byte: int) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, type: Type) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, type: Type, valueDescriptor: ValueDescriptor, object: _py_Any) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, type: Type, object: _py_Any) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, valueDescriptor: ValueDescriptor, object: _py_Any) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, double: float) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, double: float, type: Type) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, float: float) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, int: int) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, object: _py_Any) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, string: str) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, long: int) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, long: int, type: Type) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalar(cls, short: int) -> 'Scalar': ...
    @classmethod
    @overload
    def createScalarArray(cls, immutableValue: 'ImmutableValue') -> 'ScalarArray': ...
    @classmethod
    @overload
    def createScalarArray(cls, valueArray: _py_List['Value']) -> 'ScalarArray': ...
    @classmethod
    @overload
    def createScalarArray(cls, object: _py_Any) -> 'ScalarArray': ...
    @classmethod
    @overload
    def createScalarArray(cls, object: _py_Any, type: Type) -> 'ScalarArray': ...
    @classmethod
    @overload
    def createScalarArray2D(cls, immutableValue: 'ImmutableValue') -> 'ScalarArray2D': ...
    @classmethod
    @overload
    def createScalarArray2D(cls, object: _py_Any, int: int, int2: int) -> 'ScalarArray2D': ...
    @classmethod
    @overload
    def createScalarArray2D(cls, object: _py_Any, int: int, int2: int, type: Type) -> 'ScalarArray2D': ...
    @classmethod
    def createScalarFunction(cls, double: float) -> 'DiscreteFunction': ...
    @classmethod
    def createZeroFunction(cls, double: float) -> 'DiscreteFunction': ...

class Values:
    DEFAULT_DOUBLE_PRECISION: _py_ClassVar[float] = ...
    INFINITE_PRECISION: _py_ClassVar[float] = ...
    doublePrecision: _py_ClassVar[float] = ...
    @overload
    def equals(self, object: _py_Any) -> bool: ...
    @classmethod
    @overload
    def equals(cls, immutableValue: 'ImmutableValue', immutableValue2: 'ImmutableValue') -> bool: ...
    @classmethod
    @overload
    def equals(cls, double: float, double2: float) -> bool: ...
    @classmethod
    @overload
    def equals(cls, double: float, double2: float, double3: float) -> bool: ...
    @classmethod
    def getDisplayValue(cls, immutableValue: 'ImmutableValue') -> str: ...
    @classmethod
    def getPrecision(cls) -> float: ...
    @classmethod
    def hasAllowedValue(cls, immutableScalar: 'ImmutableScalar') -> bool: ...
    @classmethod
    def isInLimits(cls, immutableValue: 'ImmutableValue') -> bool: ...
    @classmethod
    def isZero(cls, double: float) -> bool: ...
    @classmethod
    @overload
    def round(cls, double: float, int: int) -> float: ...
    @classmethod
    @overload
    def round(cls, doubleArray: _py_List[float], int: int) -> _py_List[float]: ...
    @classmethod
    @overload
    def round(cls, float: float, int: int) -> float: ...
    @classmethod
    @overload
    def round(cls, floatArray: _py_List[float], int: int) -> _py_List[float]: ...
    @classmethod
    def roundArray(cls, immutableScalarArray: 'ImmutableScalarArray', int: int) -> 'ImmutableScalarArray': ...
    @classmethod
    def roundFunction(cls, immutableDiscreteFunction: 'ImmutableDiscreteFunction', integer: int, integer2: int) -> 'ImmutableDiscreteFunction': ...
    @classmethod
    def roundFunctionList(cls, immutableDiscreteFunctionList: 'ImmutableDiscreteFunctionList', integer: int, integer2: int) -> 'ImmutableValue': ...
    @classmethod
    def roundFunctionsArray(cls, immutableDiscreteFunctionsArray: 'ImmutableDiscreteFunctionsArray', integer: int, integer2: int) -> 'ImmutableValue': ...
    @classmethod
    def roundScalar(cls, immutableScalar: 'ImmutableScalar', int: int) -> 'ImmutableScalar': ...
    @classmethod
    def roundValue(cls, immutableValue: 'ImmutableValue') -> 'ImmutableValue': ...
    @classmethod
    def setPrecision(cls, double: float) -> None: ...

class Function(Typed):
    def isDiscrete(self) -> bool: ...

class ImmutableValue(java.lang.Cloneable, java.io.Serializable, Typed):
    def clone(self) -> _py_Any: ...
    def getString(self) -> str: ...
    def getValueDescriptor(self) -> ValueDescriptor: ...
    def isDefined(self) -> bool: ...
    def makeMutable(self) -> 'Value': ...

class ContinuousFunction(Function):
    _evaluate__T = _py_TypeVar('_evaluate__T', bound='Value')  # <T>
    def evaluate(self, valueMap: cern.accsoft.commons.value.expression.ValueMap, list: java.util.List[_evaluate__T]) -> _evaluate__T: ...

class ImmutableDiscreteFunctionsArray(ImmutableValue):
    def getFunction(self, int: int) -> 'ImmutableDiscreteFunction': ...
    def getFunctions(self) -> _py_List['ImmutableDiscreteFunction']: ...
    def getFunctionsCount(self) -> int: ...
    def getYs(self, double: float) -> _py_List[float]: ...
    def subView(self, double: float, double2: float) -> 'ImmutableDiscreteFunctionsArray': ...
    def toXArray(self) -> _py_List[float]: ...

class ImmutableScalar(ImmutableValue):
    def getBoolean(self) -> bool: ...
    def getByte(self) -> int: ...
    def getDouble(self) -> float: ...
    def getFloat(self) -> float: ...
    def getInt(self) -> int: ...
    def getLong(self) -> int: ...
    def getObject(self) -> _py_Any: ...
    def getShort(self) -> int: ...
    def toSimpleParameterValue(self) -> cern.japc.value.SimpleParameterValue: ...

class MathFunction(Function, Interpolable): ...

class Value(ImmutableValue):
    @overload
    def execute(self, binaryOperation: cern.accsoft.commons.value.operation.BinaryOperation, immutableValue: ImmutableValue) -> None: ...
    @overload
    def execute(self, unaryOperation: cern.accsoft.commons.value.operation.UnaryOperation) -> None: ...
    def setDefined(self, boolean: bool) -> None: ...
    def setValueDescriptor(self, valueDescriptor: ValueDescriptor) -> None: ...

class BoundedPolynomialSequence(MathFunction, Value):
    def getBoundedPolynomials(self) -> _py_List['BoundedPolynomial']: ...
    def interpolate(self, double: float) -> float: ...

class DiscreteFunctionsArray(ImmutableDiscreteFunctionsArray, Value):
    @overload
    def getFunction(self, int: int) -> 'DiscreteFunction': ...
    @overload
    def getFunction(self, int: int) -> 'ImmutableDiscreteFunction': ...
    @overload
    def getFunctions(self) -> _py_List['DiscreteFunction']: ...
    @overload
    def getFunctions(self) -> _py_List['ImmutableDiscreteFunction']: ...
    @overload
    def insert(self, double: float) -> bool: ...
    @overload
    def insert(self, int: int, double: float) -> bool: ...
    @overload
    def insert(self, int: int, double: float, double2: float) -> bool: ...
    @overload
    def insertAll(self, doubleArray: _py_List[float]) -> int: ...
    @overload
    def insertAll(self, int: int, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> int: ...
    @overload
    def insertAll(self, int: int, doubleArray: _py_List[float]) -> int: ...
    @overload
    def remove(self, double: float) -> bool: ...
    @overload
    def remove(self, int: int, double: float) -> bool: ...
    @overload
    def removeAll(self, doubleArray: _py_List[float]) -> int: ...
    @overload
    def removeAll(self, int: int, doubleArray: _py_List[float]) -> int: ...
    def retainAll(self, int: int, immutableDiscreteFunction: 'ImmutableDiscreteFunction', double: float) -> int: ...
    def setY(self, int: int, int2: int, double: float) -> None: ...
    @overload
    def subView(self, int: int, double: float, double2: float) -> 'DiscreteFunction': ...
    @overload
    def subView(self, double: float, double2: float) -> 'DiscreteFunctionsArray': ...
    @overload
    def subView(self, double: float, double2: float) -> ImmutableDiscreteFunctionsArray: ...
    @overload
    def translate(self, double: float) -> None: ...
    @overload
    def translate(self, int: int, double: float) -> None: ...

class ImmutableDiscreteFunction(Function, ImmutableScalar, Interpolable):
    def getLength(self) -> float: ...
    def getX(self, int: int) -> float: ...
    def getY(self, int: int) -> float: ...
    def indexOf(self, double: float) -> int: ...
    def size(self) -> int: ...
    def subFunction(self, double: float, double2: float) -> 'DiscreteFunction': ...
    @overload
    def toPointArray(self) -> _py_List['ImmutablePoint']: ...
    @overload
    def toPointArray(self, immutablePointArray: _py_List['ImmutablePoint']) -> _py_List['ImmutablePoint']: ...
    def toScalarArray2D(self) -> 'ScalarArray2D': ...
    def toXArray(self) -> _py_List[float]: ...
    def toYArray(self) -> _py_List[float]: ...

class ImmutablePoint(ImmutableScalar):
    def getX(self) -> float: ...
    def getY(self) -> float: ...

class ImmutableScalarArray(ImmutableScalar):
    def getArray2D(self) -> cern.japc.value.Array2D: ...
    @overload
    def getBoolean(self) -> bool: ...
    @overload
    def getBoolean(self, int: int) -> bool: ...
    @overload
    def getBooleans(self) -> _py_List[bool]: ...
    @overload
    def getBooleans(self, int: int, int2: int) -> _py_List[bool]: ...
    @overload
    def getByte(self) -> int: ...
    @overload
    def getByte(self, int: int) -> int: ...
    @overload
    def getBytes(self) -> _py_List[int]: ...
    @overload
    def getBytes(self, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getDouble(self) -> float: ...
    @overload
    def getDouble(self, int: int) -> float: ...
    @overload
    def getDoubles(self) -> _py_List[float]: ...
    @overload
    def getDoubles(self, int: int, int2: int) -> _py_List[float]: ...
    @overload
    def getFloat(self) -> float: ...
    @overload
    def getFloat(self, int: int) -> float: ...
    @overload
    def getFloats(self) -> _py_List[float]: ...
    @overload
    def getFloats(self, int: int, int2: int) -> _py_List[float]: ...
    @overload
    def getInt(self) -> int: ...
    @overload
    def getInt(self, int: int) -> int: ...
    @overload
    def getInts(self) -> _py_List[int]: ...
    @overload
    def getInts(self, int: int, int2: int) -> _py_List[int]: ...
    def getLength(self) -> int: ...
    @overload
    def getLong(self) -> int: ...
    @overload
    def getLong(self, int: int) -> int: ...
    @overload
    def getLongs(self) -> _py_List[int]: ...
    @overload
    def getLongs(self, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getObject(self) -> _py_Any: ...
    @overload
    def getObject(self, int: int) -> _py_Any: ...
    def getScalar(self, int: int) -> ImmutableScalar: ...
    def getScalars(self) -> _py_List[ImmutableScalar]: ...
    @overload
    def getShort(self) -> int: ...
    @overload
    def getShort(self, int: int) -> int: ...
    @overload
    def getShorts(self) -> _py_List[int]: ...
    @overload
    def getShorts(self, int: int, int2: int) -> _py_List[int]: ...
    @overload
    def getString(self, int: int) -> str: ...
    @overload
    def getString(self) -> str: ...
    @overload
    def getStrings(self) -> _py_List[str]: ...
    @overload
    def getStrings(self, int: int, int2: int) -> _py_List[str]: ...
    def indexOf(self, object: _py_Any) -> int: ...
    def subArray(self, int: int, int2: int) -> 'ScalarArray': ...

class Polynomial(MathFunction, Value):
    def getCoefficients(self) -> _py_List[float]: ...
    def getDegree(self) -> int: ...

class Scalar(Value, ImmutableScalar):
    def setBoolean(self, boolean: bool) -> None: ...
    def setByte(self, byte: int) -> None: ...
    def setDouble(self, double: float) -> None: ...
    def setFloat(self, float: float) -> None: ...
    def setInt(self, int: int) -> None: ...
    def setLong(self, long: int) -> None: ...
    def setObject(self, object: _py_Any) -> None: ...
    def setShort(self, short: int) -> None: ...
    def setString(self, string: str) -> None: ...

class BoundedPolynomial(Polynomial):
    def getInterval(self) -> Interval: ...
    def interpolate(self, double: float) -> float: ...

class DiscreteFunction(Scalar, ImmutableDiscreteFunction):
    @overload
    def insert(self, double: float) -> bool: ...
    @overload
    def insert(self, double: float, double2: float) -> bool: ...
    @overload
    def insertAll(self, immutableDiscreteFunction: ImmutableDiscreteFunction, double: float) -> int: ...
    @overload
    def insertAll(self, doubleArray: _py_List[float]) -> int: ...
    def remove(self, double: float) -> bool: ...
    def removeAll(self, doubleArray: _py_List[float]) -> int: ...
    def retainAll(self, immutableDiscreteFunction: ImmutableDiscreteFunction, double: float) -> int: ...
    def setY(self, int: int, double: float) -> None: ...
    def subView(self, double: float, double2: float) -> 'DiscreteFunction': ...
    def translate(self, double: float) -> None: ...

class ImmutableDiscreteFunctionList(ImmutableDiscreteFunction):
    def getAbsoluteFunction(self, int: int) -> ImmutableDiscreteFunction: ...
    def getFunction(self, int: int) -> ImmutableDiscreteFunction: ...
    def getFunctions(self) -> _py_List[ImmutableDiscreteFunction]: ...
    def getFunctionsCount(self) -> int: ...
    def getSizeIncludingStopPoints(self) -> int: ...
    def getStopPointsIndices(self) -> _py_List[int]: ...

class ImmutableScalarArray2D(ImmutableScalarArray):
    def getArray2D(self) -> cern.japc.value.Array2D: ...
    def getColumnCount(self) -> int: ...
    def getRowCount(self) -> int: ...

class Point(Scalar, ImmutablePoint):
    def setX(self, double: float) -> None: ...
    def setY(self, double: float) -> None: ...

class ScalarArray(Scalar, ImmutableScalarArray, Indexed):
    def insert(self, int: int, double: float) -> None: ...
    def insertAll(self, intArray: _py_List[int], doubleArray: _py_List[float]) -> None: ...
    def remove(self, int: int) -> None: ...
    def removeAll(self, intArray: _py_List[int]) -> None: ...
    @overload
    def setBoolean(self, boolean: bool) -> None: ...
    @overload
    def setBoolean(self, int: int, boolean: bool) -> None: ...
    def setBooleans(self, booleanArray: _py_List[bool]) -> None: ...
    @overload
    def setByte(self, byte: int) -> None: ...
    @overload
    def setByte(self, int: int, byte: int) -> None: ...
    def setBytes(self, byteArray: _py_List[int]) -> None: ...
    @overload
    def setDouble(self, double: float) -> None: ...
    @overload
    def setDouble(self, int: int, double: float) -> None: ...
    def setDoubles(self, doubleArray: _py_List[float]) -> None: ...
    @overload
    def setFloat(self, float: float) -> None: ...
    @overload
    def setFloat(self, int: int, float: float) -> None: ...
    def setFloats(self, floatArray: _py_List[float]) -> None: ...
    @overload
    def setInt(self, int: int) -> None: ...
    @overload
    def setInt(self, int: int, int2: int) -> None: ...
    def setInts(self, intArray: _py_List[int]) -> None: ...
    @overload
    def setLong(self, long: int) -> None: ...
    @overload
    def setLong(self, int: int, long: int) -> None: ...
    def setLongs(self, longArray: _py_List[int]) -> None: ...
    def setObject(self, object: _py_Any) -> None: ...
    def setScalar(self, int: int, immutableScalar: ImmutableScalar) -> None: ...
    def setScalars(self, immutableScalarArray: _py_List[ImmutableScalar]) -> None: ...
    @overload
    def setShort(self, short: int) -> None: ...
    @overload
    def setShort(self, int: int, short: int) -> None: ...
    def setShorts(self, shortArray: _py_List[int]) -> None: ...
    @overload
    def setString(self, string: str) -> None: ...
    @overload
    def setString(self, int: int, string: str) -> None: ...
    def setStrings(self, stringArray: _py_List[str]) -> None: ...

class DiscreteFunctionList(DiscreteFunction, ImmutableDiscreteFunctionList):
    def merge(self, int: int) -> None: ...
    def setStopPoints(self, intArray: _py_List[int]) -> None: ...
    def split(self, double: float) -> None: ...
    def subView(self, double: float, double2: float) -> DiscreteFunction: ...

class ScalarArray2D(ImmutableScalarArray2D, ScalarArray):
    def setBooleans2D(self, booleanArray: _py_List[bool], int: int, int2: int) -> None: ...
    def setBytes2D(self, byteArray: _py_List[int], int: int, int2: int) -> None: ...
    def setDoubles2D(self, doubleArray: _py_List[float], int: int, int2: int) -> None: ...
    def setFloats2D(self, floatArray: _py_List[float], int: int, int2: int) -> None: ...
    def setInts2D(self, intArray: _py_List[int], int2: int, int3: int) -> None: ...
    def setLongs2D(self, longArray: _py_List[int], int: int, int2: int) -> None: ...
    def setObjects2D(self, object: _py_Any, int: int, int2: int) -> None: ...
    def setShorts2D(self, shortArray: _py_List[int], int: int, int2: int) -> None: ...
    def setStrings2D(self, stringArray: _py_List[str], int: int, int2: int) -> None: ...
