# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ViewFilter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ViewFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'media_types': 'list[str]',
            'queue_ids': 'list[str]',
            'skill_ids': 'list[str]',
            'skill_groups': 'list[str]',
            'language_ids': 'list[str]',
            'language_groups': 'list[str]',
            'directions': 'list[str]',
            'originating_directions': 'list[str]',
            'wrap_up_codes': 'list[str]',
            'dnis_list': 'list[str]',
            'session_dnis_list': 'list[str]',
            'filter_queues_by_user_ids': 'list[str]',
            'filter_users_by_queue_ids': 'list[str]',
            'user_ids': 'list[str]',
            'address_tos': 'list[str]',
            'address_froms': 'list[str]',
            'outbound_campaign_ids': 'list[str]',
            'outbound_contact_list_ids': 'list[str]',
            'contact_ids': 'list[str]',
            'external_contact_ids': 'list[str]',
            'external_org_ids': 'list[str]',
            'ani_list': 'list[str]',
            'durations_milliseconds': 'list[NumericRange]',
            'acd_durations_milliseconds': 'list[NumericRange]',
            'talk_durations_milliseconds': 'list[NumericRange]',
            'acw_durations_milliseconds': 'list[NumericRange]',
            'handle_durations_milliseconds': 'list[NumericRange]',
            'hold_durations_milliseconds': 'list[NumericRange]',
            'abandon_durations_milliseconds': 'list[NumericRange]',
            'evaluation_score': 'NumericRange',
            'evaluation_critical_score': 'NumericRange',
            'evaluation_form_ids': 'list[str]',
            'evaluated_agent_ids': 'list[str]',
            'evaluator_ids': 'list[str]',
            'transferred': 'bool',
            'abandoned': 'bool',
            'message_types': 'list[str]',
            'division_ids': 'list[str]',
            'survey_form_ids': 'list[str]',
            'survey_total_score': 'NumericRange',
            'survey_nps_score': 'NumericRange',
            'show_secondary_status': 'bool',
            'agent_duration_sort_order': 'str',
            'waiting_duration_sort_order': 'str',
            'interacting_duration_sort_order': 'str',
            'agent_name': 'str',
            'skills_list': 'list[str]',
            'language_list': 'list[str]',
            'mos': 'NumericRange',
            'survey_question_group_score': 'NumericRange',
            'survey_promoter_score': 'NumericRange',
            'survey_form_context_ids': 'list[str]',
            'conversation_ids': 'list[str]',
            'sip_call_ids': 'list[str]',
            'is_ended': 'bool',
            'is_surveyed': 'bool',
            'survey_scores': 'list[NumericRange]',
            'promoter_scores': 'list[NumericRange]',
            'is_campaign': 'bool',
            'survey_statuses': 'list[str]',
            'conversation_properties': 'ConversationProperties',
            'is_blind_transferred': 'bool',
            'is_consulted': 'bool',
            'is_consult_transferred': 'bool',
            'remote_participants': 'list[str]',
            'status_list': 'list[str]',
            'flow_ids': 'list[str]',
            'flow_outcome_ids': 'list[str]',
            'flow_outcome_values': 'list[str]',
            'flow_destination_types': 'list[str]',
            'flow_disconnect_reasons': 'list[str]',
            'flow_types': 'list[str]',
            'flow_entry_types': 'list[str]',
            'flow_entry_reasons': 'list[str]',
            'flow_versions': 'list[str]',
            'group_ids': 'list[str]',
            'has_journey_customer_id': 'bool',
            'has_journey_action_map_id': 'bool',
            'has_journey_visit_id': 'bool',
            'oauth_client_ids': 'list[str]',
            'api_operations': 'list[str]',
            'has_media': 'bool',
            'role_ids': 'list[str]',
            'reports_tos': 'list[str]',
            'location_ids': 'list[str]'
        }

        self.attribute_map = {
            'media_types': 'mediaTypes',
            'queue_ids': 'queueIds',
            'skill_ids': 'skillIds',
            'skill_groups': 'skillGroups',
            'language_ids': 'languageIds',
            'language_groups': 'languageGroups',
            'directions': 'directions',
            'originating_directions': 'originatingDirections',
            'wrap_up_codes': 'wrapUpCodes',
            'dnis_list': 'dnisList',
            'session_dnis_list': 'sessionDnisList',
            'filter_queues_by_user_ids': 'filterQueuesByUserIds',
            'filter_users_by_queue_ids': 'filterUsersByQueueIds',
            'user_ids': 'userIds',
            'address_tos': 'addressTos',
            'address_froms': 'addressFroms',
            'outbound_campaign_ids': 'outboundCampaignIds',
            'outbound_contact_list_ids': 'outboundContactListIds',
            'contact_ids': 'contactIds',
            'external_contact_ids': 'externalContactIds',
            'external_org_ids': 'externalOrgIds',
            'ani_list': 'aniList',
            'durations_milliseconds': 'durationsMilliseconds',
            'acd_durations_milliseconds': 'acdDurationsMilliseconds',
            'talk_durations_milliseconds': 'talkDurationsMilliseconds',
            'acw_durations_milliseconds': 'acwDurationsMilliseconds',
            'handle_durations_milliseconds': 'handleDurationsMilliseconds',
            'hold_durations_milliseconds': 'holdDurationsMilliseconds',
            'abandon_durations_milliseconds': 'abandonDurationsMilliseconds',
            'evaluation_score': 'evaluationScore',
            'evaluation_critical_score': 'evaluationCriticalScore',
            'evaluation_form_ids': 'evaluationFormIds',
            'evaluated_agent_ids': 'evaluatedAgentIds',
            'evaluator_ids': 'evaluatorIds',
            'transferred': 'transferred',
            'abandoned': 'abandoned',
            'message_types': 'messageTypes',
            'division_ids': 'divisionIds',
            'survey_form_ids': 'surveyFormIds',
            'survey_total_score': 'surveyTotalScore',
            'survey_nps_score': 'surveyNpsScore',
            'show_secondary_status': 'showSecondaryStatus',
            'agent_duration_sort_order': 'agentDurationSortOrder',
            'waiting_duration_sort_order': 'waitingDurationSortOrder',
            'interacting_duration_sort_order': 'interactingDurationSortOrder',
            'agent_name': 'agentName',
            'skills_list': 'skillsList',
            'language_list': 'languageList',
            'mos': 'mos',
            'survey_question_group_score': 'surveyQuestionGroupScore',
            'survey_promoter_score': 'surveyPromoterScore',
            'survey_form_context_ids': 'surveyFormContextIds',
            'conversation_ids': 'conversationIds',
            'sip_call_ids': 'sipCallIds',
            'is_ended': 'isEnded',
            'is_surveyed': 'isSurveyed',
            'survey_scores': 'surveyScores',
            'promoter_scores': 'promoterScores',
            'is_campaign': 'isCampaign',
            'survey_statuses': 'surveyStatuses',
            'conversation_properties': 'conversationProperties',
            'is_blind_transferred': 'isBlindTransferred',
            'is_consulted': 'isConsulted',
            'is_consult_transferred': 'isConsultTransferred',
            'remote_participants': 'remoteParticipants',
            'status_list': 'statusList',
            'flow_ids': 'flowIds',
            'flow_outcome_ids': 'flowOutcomeIds',
            'flow_outcome_values': 'flowOutcomeValues',
            'flow_destination_types': 'flowDestinationTypes',
            'flow_disconnect_reasons': 'flowDisconnectReasons',
            'flow_types': 'flowTypes',
            'flow_entry_types': 'flowEntryTypes',
            'flow_entry_reasons': 'flowEntryReasons',
            'flow_versions': 'flowVersions',
            'group_ids': 'groupIds',
            'has_journey_customer_id': 'hasJourneyCustomerId',
            'has_journey_action_map_id': 'hasJourneyActionMapId',
            'has_journey_visit_id': 'hasJourneyVisitId',
            'oauth_client_ids': 'oauthClientIds',
            'api_operations': 'apiOperations',
            'has_media': 'hasMedia',
            'role_ids': 'roleIds',
            'reports_tos': 'reportsTos',
            'location_ids': 'locationIds'
        }

        self._media_types = None
        self._queue_ids = None
        self._skill_ids = None
        self._skill_groups = None
        self._language_ids = None
        self._language_groups = None
        self._directions = None
        self._originating_directions = None
        self._wrap_up_codes = None
        self._dnis_list = None
        self._session_dnis_list = None
        self._filter_queues_by_user_ids = None
        self._filter_users_by_queue_ids = None
        self._user_ids = None
        self._address_tos = None
        self._address_froms = None
        self._outbound_campaign_ids = None
        self._outbound_contact_list_ids = None
        self._contact_ids = None
        self._external_contact_ids = None
        self._external_org_ids = None
        self._ani_list = None
        self._durations_milliseconds = None
        self._acd_durations_milliseconds = None
        self._talk_durations_milliseconds = None
        self._acw_durations_milliseconds = None
        self._handle_durations_milliseconds = None
        self._hold_durations_milliseconds = None
        self._abandon_durations_milliseconds = None
        self._evaluation_score = None
        self._evaluation_critical_score = None
        self._evaluation_form_ids = None
        self._evaluated_agent_ids = None
        self._evaluator_ids = None
        self._transferred = None
        self._abandoned = None
        self._message_types = None
        self._division_ids = None
        self._survey_form_ids = None
        self._survey_total_score = None
        self._survey_nps_score = None
        self._show_secondary_status = None
        self._agent_duration_sort_order = None
        self._waiting_duration_sort_order = None
        self._interacting_duration_sort_order = None
        self._agent_name = None
        self._skills_list = None
        self._language_list = None
        self._mos = None
        self._survey_question_group_score = None
        self._survey_promoter_score = None
        self._survey_form_context_ids = None
        self._conversation_ids = None
        self._sip_call_ids = None
        self._is_ended = None
        self._is_surveyed = None
        self._survey_scores = None
        self._promoter_scores = None
        self._is_campaign = None
        self._survey_statuses = None
        self._conversation_properties = None
        self._is_blind_transferred = None
        self._is_consulted = None
        self._is_consult_transferred = None
        self._remote_participants = None
        self._status_list = None
        self._flow_ids = None
        self._flow_outcome_ids = None
        self._flow_outcome_values = None
        self._flow_destination_types = None
        self._flow_disconnect_reasons = None
        self._flow_types = None
        self._flow_entry_types = None
        self._flow_entry_reasons = None
        self._flow_versions = None
        self._group_ids = None
        self._has_journey_customer_id = None
        self._has_journey_action_map_id = None
        self._has_journey_visit_id = None
        self._oauth_client_ids = None
        self._api_operations = None
        self._has_media = None
        self._role_ids = None
        self._reports_tos = None
        self._location_ids = None

    @property
    def media_types(self):
        """
        Gets the media_types of this ViewFilter.
        The media types are used to filter the view

        :return: The media_types of this ViewFilter.
        :rtype: list[str]
        """
        return self._media_types

    @media_types.setter
    def media_types(self, media_types):
        """
        Sets the media_types of this ViewFilter.
        The media types are used to filter the view

        :param media_types: The media_types of this ViewFilter.
        :type: list[str]
        """
        
        self._media_types = media_types

    @property
    def queue_ids(self):
        """
        Gets the queue_ids of this ViewFilter.
        The queue ids are used to filter the view

        :return: The queue_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._queue_ids

    @queue_ids.setter
    def queue_ids(self, queue_ids):
        """
        Sets the queue_ids of this ViewFilter.
        The queue ids are used to filter the view

        :param queue_ids: The queue_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._queue_ids = queue_ids

    @property
    def skill_ids(self):
        """
        Gets the skill_ids of this ViewFilter.
        The skill ids are used to filter the view

        :return: The skill_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._skill_ids

    @skill_ids.setter
    def skill_ids(self, skill_ids):
        """
        Sets the skill_ids of this ViewFilter.
        The skill ids are used to filter the view

        :param skill_ids: The skill_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._skill_ids = skill_ids

    @property
    def skill_groups(self):
        """
        Gets the skill_groups of this ViewFilter.
        The skill groups used to filter the view

        :return: The skill_groups of this ViewFilter.
        :rtype: list[str]
        """
        return self._skill_groups

    @skill_groups.setter
    def skill_groups(self, skill_groups):
        """
        Sets the skill_groups of this ViewFilter.
        The skill groups used to filter the view

        :param skill_groups: The skill_groups of this ViewFilter.
        :type: list[str]
        """
        
        self._skill_groups = skill_groups

    @property
    def language_ids(self):
        """
        Gets the language_ids of this ViewFilter.
        The language ids are used to filter the view

        :return: The language_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._language_ids

    @language_ids.setter
    def language_ids(self, language_ids):
        """
        Sets the language_ids of this ViewFilter.
        The language ids are used to filter the view

        :param language_ids: The language_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._language_ids = language_ids

    @property
    def language_groups(self):
        """
        Gets the language_groups of this ViewFilter.
        The language groups used to filter the view

        :return: The language_groups of this ViewFilter.
        :rtype: list[str]
        """
        return self._language_groups

    @language_groups.setter
    def language_groups(self, language_groups):
        """
        Sets the language_groups of this ViewFilter.
        The language groups used to filter the view

        :param language_groups: The language_groups of this ViewFilter.
        :type: list[str]
        """
        
        self._language_groups = language_groups

    @property
    def directions(self):
        """
        Gets the directions of this ViewFilter.
        The directions are used to filter the view

        :return: The directions of this ViewFilter.
        :rtype: list[str]
        """
        return self._directions

    @directions.setter
    def directions(self, directions):
        """
        Sets the directions of this ViewFilter.
        The directions are used to filter the view

        :param directions: The directions of this ViewFilter.
        :type: list[str]
        """
        
        self._directions = directions

    @property
    def originating_directions(self):
        """
        Gets the originating_directions of this ViewFilter.
        The list of orginating directions used to filter the view

        :return: The originating_directions of this ViewFilter.
        :rtype: list[str]
        """
        return self._originating_directions

    @originating_directions.setter
    def originating_directions(self, originating_directions):
        """
        Sets the originating_directions of this ViewFilter.
        The list of orginating directions used to filter the view

        :param originating_directions: The originating_directions of this ViewFilter.
        :type: list[str]
        """
        
        self._originating_directions = originating_directions

    @property
    def wrap_up_codes(self):
        """
        Gets the wrap_up_codes of this ViewFilter.
        The wrap up codes are used to filter the view

        :return: The wrap_up_codes of this ViewFilter.
        :rtype: list[str]
        """
        return self._wrap_up_codes

    @wrap_up_codes.setter
    def wrap_up_codes(self, wrap_up_codes):
        """
        Sets the wrap_up_codes of this ViewFilter.
        The wrap up codes are used to filter the view

        :param wrap_up_codes: The wrap_up_codes of this ViewFilter.
        :type: list[str]
        """
        
        self._wrap_up_codes = wrap_up_codes

    @property
    def dnis_list(self):
        """
        Gets the dnis_list of this ViewFilter.
        The dnis list is used to filter the view

        :return: The dnis_list of this ViewFilter.
        :rtype: list[str]
        """
        return self._dnis_list

    @dnis_list.setter
    def dnis_list(self, dnis_list):
        """
        Sets the dnis_list of this ViewFilter.
        The dnis list is used to filter the view

        :param dnis_list: The dnis_list of this ViewFilter.
        :type: list[str]
        """
        
        self._dnis_list = dnis_list

    @property
    def session_dnis_list(self):
        """
        Gets the session_dnis_list of this ViewFilter.
        The list of session dnis used to filter the view

        :return: The session_dnis_list of this ViewFilter.
        :rtype: list[str]
        """
        return self._session_dnis_list

    @session_dnis_list.setter
    def session_dnis_list(self, session_dnis_list):
        """
        Sets the session_dnis_list of this ViewFilter.
        The list of session dnis used to filter the view

        :param session_dnis_list: The session_dnis_list of this ViewFilter.
        :type: list[str]
        """
        
        self._session_dnis_list = session_dnis_list

    @property
    def filter_queues_by_user_ids(self):
        """
        Gets the filter_queues_by_user_ids of this ViewFilter.
        The user ids are used to fetch associated queues for the view

        :return: The filter_queues_by_user_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._filter_queues_by_user_ids

    @filter_queues_by_user_ids.setter
    def filter_queues_by_user_ids(self, filter_queues_by_user_ids):
        """
        Sets the filter_queues_by_user_ids of this ViewFilter.
        The user ids are used to fetch associated queues for the view

        :param filter_queues_by_user_ids: The filter_queues_by_user_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._filter_queues_by_user_ids = filter_queues_by_user_ids

    @property
    def filter_users_by_queue_ids(self):
        """
        Gets the filter_users_by_queue_ids of this ViewFilter.
        The queue ids are used to fetch associated users for the view

        :return: The filter_users_by_queue_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._filter_users_by_queue_ids

    @filter_users_by_queue_ids.setter
    def filter_users_by_queue_ids(self, filter_users_by_queue_ids):
        """
        Sets the filter_users_by_queue_ids of this ViewFilter.
        The queue ids are used to fetch associated users for the view

        :param filter_users_by_queue_ids: The filter_users_by_queue_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._filter_users_by_queue_ids = filter_users_by_queue_ids

    @property
    def user_ids(self):
        """
        Gets the user_ids of this ViewFilter.
        The user ids are used to filter the view

        :return: The user_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._user_ids

    @user_ids.setter
    def user_ids(self, user_ids):
        """
        Sets the user_ids of this ViewFilter.
        The user ids are used to filter the view

        :param user_ids: The user_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._user_ids = user_ids

    @property
    def address_tos(self):
        """
        Gets the address_tos of this ViewFilter.
        The address To values are used to filter the view

        :return: The address_tos of this ViewFilter.
        :rtype: list[str]
        """
        return self._address_tos

    @address_tos.setter
    def address_tos(self, address_tos):
        """
        Sets the address_tos of this ViewFilter.
        The address To values are used to filter the view

        :param address_tos: The address_tos of this ViewFilter.
        :type: list[str]
        """
        
        self._address_tos = address_tos

    @property
    def address_froms(self):
        """
        Gets the address_froms of this ViewFilter.
        The address from values are used to filter the view

        :return: The address_froms of this ViewFilter.
        :rtype: list[str]
        """
        return self._address_froms

    @address_froms.setter
    def address_froms(self, address_froms):
        """
        Sets the address_froms of this ViewFilter.
        The address from values are used to filter the view

        :param address_froms: The address_froms of this ViewFilter.
        :type: list[str]
        """
        
        self._address_froms = address_froms

    @property
    def outbound_campaign_ids(self):
        """
        Gets the outbound_campaign_ids of this ViewFilter.
        The outbound campaign ids are used to filter the view

        :return: The outbound_campaign_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._outbound_campaign_ids

    @outbound_campaign_ids.setter
    def outbound_campaign_ids(self, outbound_campaign_ids):
        """
        Sets the outbound_campaign_ids of this ViewFilter.
        The outbound campaign ids are used to filter the view

        :param outbound_campaign_ids: The outbound_campaign_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._outbound_campaign_ids = outbound_campaign_ids

    @property
    def outbound_contact_list_ids(self):
        """
        Gets the outbound_contact_list_ids of this ViewFilter.
        The outbound contact list ids are used to filter the view

        :return: The outbound_contact_list_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._outbound_contact_list_ids

    @outbound_contact_list_ids.setter
    def outbound_contact_list_ids(self, outbound_contact_list_ids):
        """
        Sets the outbound_contact_list_ids of this ViewFilter.
        The outbound contact list ids are used to filter the view

        :param outbound_contact_list_ids: The outbound_contact_list_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._outbound_contact_list_ids = outbound_contact_list_ids

    @property
    def contact_ids(self):
        """
        Gets the contact_ids of this ViewFilter.
        The contact ids are used to filter the view

        :return: The contact_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._contact_ids

    @contact_ids.setter
    def contact_ids(self, contact_ids):
        """
        Sets the contact_ids of this ViewFilter.
        The contact ids are used to filter the view

        :param contact_ids: The contact_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._contact_ids = contact_ids

    @property
    def external_contact_ids(self):
        """
        Gets the external_contact_ids of this ViewFilter.
        The external contact ids are used to filter the view

        :return: The external_contact_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._external_contact_ids

    @external_contact_ids.setter
    def external_contact_ids(self, external_contact_ids):
        """
        Sets the external_contact_ids of this ViewFilter.
        The external contact ids are used to filter the view

        :param external_contact_ids: The external_contact_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._external_contact_ids = external_contact_ids

    @property
    def external_org_ids(self):
        """
        Gets the external_org_ids of this ViewFilter.
        The external org ids are used to filter the view

        :return: The external_org_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._external_org_ids

    @external_org_ids.setter
    def external_org_ids(self, external_org_ids):
        """
        Sets the external_org_ids of this ViewFilter.
        The external org ids are used to filter the view

        :param external_org_ids: The external_org_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._external_org_ids = external_org_ids

    @property
    def ani_list(self):
        """
        Gets the ani_list of this ViewFilter.
        The ani list ids are used to filter the view

        :return: The ani_list of this ViewFilter.
        :rtype: list[str]
        """
        return self._ani_list

    @ani_list.setter
    def ani_list(self, ani_list):
        """
        Sets the ani_list of this ViewFilter.
        The ani list ids are used to filter the view

        :param ani_list: The ani_list of this ViewFilter.
        :type: list[str]
        """
        
        self._ani_list = ani_list

    @property
    def durations_milliseconds(self):
        """
        Gets the durations_milliseconds of this ViewFilter.
        The durations in milliseconds used to filter the view

        :return: The durations_milliseconds of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._durations_milliseconds

    @durations_milliseconds.setter
    def durations_milliseconds(self, durations_milliseconds):
        """
        Sets the durations_milliseconds of this ViewFilter.
        The durations in milliseconds used to filter the view

        :param durations_milliseconds: The durations_milliseconds of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._durations_milliseconds = durations_milliseconds

    @property
    def acd_durations_milliseconds(self):
        """
        Gets the acd_durations_milliseconds of this ViewFilter.
        The acd durations in milliseconds used to filter the view

        :return: The acd_durations_milliseconds of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._acd_durations_milliseconds

    @acd_durations_milliseconds.setter
    def acd_durations_milliseconds(self, acd_durations_milliseconds):
        """
        Sets the acd_durations_milliseconds of this ViewFilter.
        The acd durations in milliseconds used to filter the view

        :param acd_durations_milliseconds: The acd_durations_milliseconds of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._acd_durations_milliseconds = acd_durations_milliseconds

    @property
    def talk_durations_milliseconds(self):
        """
        Gets the talk_durations_milliseconds of this ViewFilter.
        The talk durations in milliseconds used to filter the view

        :return: The talk_durations_milliseconds of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._talk_durations_milliseconds

    @talk_durations_milliseconds.setter
    def talk_durations_milliseconds(self, talk_durations_milliseconds):
        """
        Sets the talk_durations_milliseconds of this ViewFilter.
        The talk durations in milliseconds used to filter the view

        :param talk_durations_milliseconds: The talk_durations_milliseconds of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._talk_durations_milliseconds = talk_durations_milliseconds

    @property
    def acw_durations_milliseconds(self):
        """
        Gets the acw_durations_milliseconds of this ViewFilter.
        The acw durations in milliseconds used to filter the view

        :return: The acw_durations_milliseconds of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._acw_durations_milliseconds

    @acw_durations_milliseconds.setter
    def acw_durations_milliseconds(self, acw_durations_milliseconds):
        """
        Sets the acw_durations_milliseconds of this ViewFilter.
        The acw durations in milliseconds used to filter the view

        :param acw_durations_milliseconds: The acw_durations_milliseconds of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._acw_durations_milliseconds = acw_durations_milliseconds

    @property
    def handle_durations_milliseconds(self):
        """
        Gets the handle_durations_milliseconds of this ViewFilter.
        The handle durations in milliseconds used to filter the view

        :return: The handle_durations_milliseconds of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._handle_durations_milliseconds

    @handle_durations_milliseconds.setter
    def handle_durations_milliseconds(self, handle_durations_milliseconds):
        """
        Sets the handle_durations_milliseconds of this ViewFilter.
        The handle durations in milliseconds used to filter the view

        :param handle_durations_milliseconds: The handle_durations_milliseconds of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._handle_durations_milliseconds = handle_durations_milliseconds

    @property
    def hold_durations_milliseconds(self):
        """
        Gets the hold_durations_milliseconds of this ViewFilter.
        The hold durations in milliseconds used to filter the view

        :return: The hold_durations_milliseconds of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._hold_durations_milliseconds

    @hold_durations_milliseconds.setter
    def hold_durations_milliseconds(self, hold_durations_milliseconds):
        """
        Sets the hold_durations_milliseconds of this ViewFilter.
        The hold durations in milliseconds used to filter the view

        :param hold_durations_milliseconds: The hold_durations_milliseconds of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._hold_durations_milliseconds = hold_durations_milliseconds

    @property
    def abandon_durations_milliseconds(self):
        """
        Gets the abandon_durations_milliseconds of this ViewFilter.
        The abandon durations in milliseconds used to filter the view

        :return: The abandon_durations_milliseconds of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._abandon_durations_milliseconds

    @abandon_durations_milliseconds.setter
    def abandon_durations_milliseconds(self, abandon_durations_milliseconds):
        """
        Sets the abandon_durations_milliseconds of this ViewFilter.
        The abandon durations in milliseconds used to filter the view

        :param abandon_durations_milliseconds: The abandon_durations_milliseconds of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._abandon_durations_milliseconds = abandon_durations_milliseconds

    @property
    def evaluation_score(self):
        """
        Gets the evaluation_score of this ViewFilter.
        The evaluationScore is used to filter the view

        :return: The evaluation_score of this ViewFilter.
        :rtype: NumericRange
        """
        return self._evaluation_score

    @evaluation_score.setter
    def evaluation_score(self, evaluation_score):
        """
        Sets the evaluation_score of this ViewFilter.
        The evaluationScore is used to filter the view

        :param evaluation_score: The evaluation_score of this ViewFilter.
        :type: NumericRange
        """
        
        self._evaluation_score = evaluation_score

    @property
    def evaluation_critical_score(self):
        """
        Gets the evaluation_critical_score of this ViewFilter.
        The evaluationCriticalScore is used to filter the view

        :return: The evaluation_critical_score of this ViewFilter.
        :rtype: NumericRange
        """
        return self._evaluation_critical_score

    @evaluation_critical_score.setter
    def evaluation_critical_score(self, evaluation_critical_score):
        """
        Sets the evaluation_critical_score of this ViewFilter.
        The evaluationCriticalScore is used to filter the view

        :param evaluation_critical_score: The evaluation_critical_score of this ViewFilter.
        :type: NumericRange
        """
        
        self._evaluation_critical_score = evaluation_critical_score

    @property
    def evaluation_form_ids(self):
        """
        Gets the evaluation_form_ids of this ViewFilter.
        The evaluation form ids are used to filter the view

        :return: The evaluation_form_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._evaluation_form_ids

    @evaluation_form_ids.setter
    def evaluation_form_ids(self, evaluation_form_ids):
        """
        Sets the evaluation_form_ids of this ViewFilter.
        The evaluation form ids are used to filter the view

        :param evaluation_form_ids: The evaluation_form_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._evaluation_form_ids = evaluation_form_ids

    @property
    def evaluated_agent_ids(self):
        """
        Gets the evaluated_agent_ids of this ViewFilter.
        The evaluated agent ids are used to filter the view

        :return: The evaluated_agent_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._evaluated_agent_ids

    @evaluated_agent_ids.setter
    def evaluated_agent_ids(self, evaluated_agent_ids):
        """
        Sets the evaluated_agent_ids of this ViewFilter.
        The evaluated agent ids are used to filter the view

        :param evaluated_agent_ids: The evaluated_agent_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._evaluated_agent_ids = evaluated_agent_ids

    @property
    def evaluator_ids(self):
        """
        Gets the evaluator_ids of this ViewFilter.
        The evaluator ids are used to filter the view

        :return: The evaluator_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._evaluator_ids

    @evaluator_ids.setter
    def evaluator_ids(self, evaluator_ids):
        """
        Sets the evaluator_ids of this ViewFilter.
        The evaluator ids are used to filter the view

        :param evaluator_ids: The evaluator_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._evaluator_ids = evaluator_ids

    @property
    def transferred(self):
        """
        Gets the transferred of this ViewFilter.
        Indicates filtering for transfers

        :return: The transferred of this ViewFilter.
        :rtype: bool
        """
        return self._transferred

    @transferred.setter
    def transferred(self, transferred):
        """
        Sets the transferred of this ViewFilter.
        Indicates filtering for transfers

        :param transferred: The transferred of this ViewFilter.
        :type: bool
        """
        
        self._transferred = transferred

    @property
    def abandoned(self):
        """
        Gets the abandoned of this ViewFilter.
        Indicates filtering for abandons

        :return: The abandoned of this ViewFilter.
        :rtype: bool
        """
        return self._abandoned

    @abandoned.setter
    def abandoned(self, abandoned):
        """
        Sets the abandoned of this ViewFilter.
        Indicates filtering for abandons

        :param abandoned: The abandoned of this ViewFilter.
        :type: bool
        """
        
        self._abandoned = abandoned

    @property
    def message_types(self):
        """
        Gets the message_types of this ViewFilter.
        The message media types used to filter the view

        :return: The message_types of this ViewFilter.
        :rtype: list[str]
        """
        return self._message_types

    @message_types.setter
    def message_types(self, message_types):
        """
        Sets the message_types of this ViewFilter.
        The message media types used to filter the view

        :param message_types: The message_types of this ViewFilter.
        :type: list[str]
        """
        
        self._message_types = message_types

    @property
    def division_ids(self):
        """
        Gets the division_ids of this ViewFilter.
        The divison Ids used to filter the view

        :return: The division_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._division_ids

    @division_ids.setter
    def division_ids(self, division_ids):
        """
        Sets the division_ids of this ViewFilter.
        The divison Ids used to filter the view

        :param division_ids: The division_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._division_ids = division_ids

    @property
    def survey_form_ids(self):
        """
        Gets the survey_form_ids of this ViewFilter.
        The survey form ids used to filter the view

        :return: The survey_form_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._survey_form_ids

    @survey_form_ids.setter
    def survey_form_ids(self, survey_form_ids):
        """
        Sets the survey_form_ids of this ViewFilter.
        The survey form ids used to filter the view

        :param survey_form_ids: The survey_form_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._survey_form_ids = survey_form_ids

    @property
    def survey_total_score(self):
        """
        Gets the survey_total_score of this ViewFilter.
        The survey total score used to filter the view

        :return: The survey_total_score of this ViewFilter.
        :rtype: NumericRange
        """
        return self._survey_total_score

    @survey_total_score.setter
    def survey_total_score(self, survey_total_score):
        """
        Sets the survey_total_score of this ViewFilter.
        The survey total score used to filter the view

        :param survey_total_score: The survey_total_score of this ViewFilter.
        :type: NumericRange
        """
        
        self._survey_total_score = survey_total_score

    @property
    def survey_nps_score(self):
        """
        Gets the survey_nps_score of this ViewFilter.
        The survey NPS score used to filter the view

        :return: The survey_nps_score of this ViewFilter.
        :rtype: NumericRange
        """
        return self._survey_nps_score

    @survey_nps_score.setter
    def survey_nps_score(self, survey_nps_score):
        """
        Sets the survey_nps_score of this ViewFilter.
        The survey NPS score used to filter the view

        :param survey_nps_score: The survey_nps_score of this ViewFilter.
        :type: NumericRange
        """
        
        self._survey_nps_score = survey_nps_score

    @property
    def show_secondary_status(self):
        """
        Gets the show_secondary_status of this ViewFilter.
        Indicates if the Secondary Status should be shown

        :return: The show_secondary_status of this ViewFilter.
        :rtype: bool
        """
        return self._show_secondary_status

    @show_secondary_status.setter
    def show_secondary_status(self, show_secondary_status):
        """
        Sets the show_secondary_status of this ViewFilter.
        Indicates if the Secondary Status should be shown

        :param show_secondary_status: The show_secondary_status of this ViewFilter.
        :type: bool
        """
        
        self._show_secondary_status = show_secondary_status

    @property
    def agent_duration_sort_order(self):
        """
        Gets the agent_duration_sort_order of this ViewFilter.
        Provides the agent duration sort order

        :return: The agent_duration_sort_order of this ViewFilter.
        :rtype: str
        """
        return self._agent_duration_sort_order

    @agent_duration_sort_order.setter
    def agent_duration_sort_order(self, agent_duration_sort_order):
        """
        Sets the agent_duration_sort_order of this ViewFilter.
        Provides the agent duration sort order

        :param agent_duration_sort_order: The agent_duration_sort_order of this ViewFilter.
        :type: str
        """
        allowed_values = ["ascending", "descending"]
        if agent_duration_sort_order.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for agent_duration_sort_order -> " + agent_duration_sort_order
            self._agent_duration_sort_order = "outdated_sdk_version"
        else:
            self._agent_duration_sort_order = agent_duration_sort_order

    @property
    def waiting_duration_sort_order(self):
        """
        Gets the waiting_duration_sort_order of this ViewFilter.
        Provides the waiting duration sort order

        :return: The waiting_duration_sort_order of this ViewFilter.
        :rtype: str
        """
        return self._waiting_duration_sort_order

    @waiting_duration_sort_order.setter
    def waiting_duration_sort_order(self, waiting_duration_sort_order):
        """
        Sets the waiting_duration_sort_order of this ViewFilter.
        Provides the waiting duration sort order

        :param waiting_duration_sort_order: The waiting_duration_sort_order of this ViewFilter.
        :type: str
        """
        allowed_values = ["ascending", "descending"]
        if waiting_duration_sort_order.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for waiting_duration_sort_order -> " + waiting_duration_sort_order
            self._waiting_duration_sort_order = "outdated_sdk_version"
        else:
            self._waiting_duration_sort_order = waiting_duration_sort_order

    @property
    def interacting_duration_sort_order(self):
        """
        Gets the interacting_duration_sort_order of this ViewFilter.
        Provides the interacting duration sort order

        :return: The interacting_duration_sort_order of this ViewFilter.
        :rtype: str
        """
        return self._interacting_duration_sort_order

    @interacting_duration_sort_order.setter
    def interacting_duration_sort_order(self, interacting_duration_sort_order):
        """
        Sets the interacting_duration_sort_order of this ViewFilter.
        Provides the interacting duration sort order

        :param interacting_duration_sort_order: The interacting_duration_sort_order of this ViewFilter.
        :type: str
        """
        allowed_values = ["ascending", "descending"]
        if interacting_duration_sort_order.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for interacting_duration_sort_order -> " + interacting_duration_sort_order
            self._interacting_duration_sort_order = "outdated_sdk_version"
        else:
            self._interacting_duration_sort_order = interacting_duration_sort_order

    @property
    def agent_name(self):
        """
        Gets the agent_name of this ViewFilter.
        Displays the Agent name as provided by the user

        :return: The agent_name of this ViewFilter.
        :rtype: str
        """
        return self._agent_name

    @agent_name.setter
    def agent_name(self, agent_name):
        """
        Sets the agent_name of this ViewFilter.
        Displays the Agent name as provided by the user

        :param agent_name: The agent_name of this ViewFilter.
        :type: str
        """
        
        self._agent_name = agent_name

    @property
    def skills_list(self):
        """
        Gets the skills_list of this ViewFilter.
        The list of skill strings as free form text

        :return: The skills_list of this ViewFilter.
        :rtype: list[str]
        """
        return self._skills_list

    @skills_list.setter
    def skills_list(self, skills_list):
        """
        Sets the skills_list of this ViewFilter.
        The list of skill strings as free form text

        :param skills_list: The skills_list of this ViewFilter.
        :type: list[str]
        """
        
        self._skills_list = skills_list

    @property
    def language_list(self):
        """
        Gets the language_list of this ViewFilter.
        The list of language strings as free form text

        :return: The language_list of this ViewFilter.
        :rtype: list[str]
        """
        return self._language_list

    @language_list.setter
    def language_list(self, language_list):
        """
        Sets the language_list of this ViewFilter.
        The list of language strings as free form text

        :param language_list: The language_list of this ViewFilter.
        :type: list[str]
        """
        
        self._language_list = language_list

    @property
    def mos(self):
        """
        Gets the mos of this ViewFilter.
        The desired range for mos values

        :return: The mos of this ViewFilter.
        :rtype: NumericRange
        """
        return self._mos

    @mos.setter
    def mos(self, mos):
        """
        Sets the mos of this ViewFilter.
        The desired range for mos values

        :param mos: The mos of this ViewFilter.
        :type: NumericRange
        """
        
        self._mos = mos

    @property
    def survey_question_group_score(self):
        """
        Gets the survey_question_group_score of this ViewFilter.
        The survey question group score used to filter the view

        :return: The survey_question_group_score of this ViewFilter.
        :rtype: NumericRange
        """
        return self._survey_question_group_score

    @survey_question_group_score.setter
    def survey_question_group_score(self, survey_question_group_score):
        """
        Sets the survey_question_group_score of this ViewFilter.
        The survey question group score used to filter the view

        :param survey_question_group_score: The survey_question_group_score of this ViewFilter.
        :type: NumericRange
        """
        
        self._survey_question_group_score = survey_question_group_score

    @property
    def survey_promoter_score(self):
        """
        Gets the survey_promoter_score of this ViewFilter.
        The survey promoter score used to filter the view

        :return: The survey_promoter_score of this ViewFilter.
        :rtype: NumericRange
        """
        return self._survey_promoter_score

    @survey_promoter_score.setter
    def survey_promoter_score(self, survey_promoter_score):
        """
        Sets the survey_promoter_score of this ViewFilter.
        The survey promoter score used to filter the view

        :param survey_promoter_score: The survey_promoter_score of this ViewFilter.
        :type: NumericRange
        """
        
        self._survey_promoter_score = survey_promoter_score

    @property
    def survey_form_context_ids(self):
        """
        Gets the survey_form_context_ids of this ViewFilter.
        The list of survey form context ids used to filter the view

        :return: The survey_form_context_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._survey_form_context_ids

    @survey_form_context_ids.setter
    def survey_form_context_ids(self, survey_form_context_ids):
        """
        Sets the survey_form_context_ids of this ViewFilter.
        The list of survey form context ids used to filter the view

        :param survey_form_context_ids: The survey_form_context_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._survey_form_context_ids = survey_form_context_ids

    @property
    def conversation_ids(self):
        """
        Gets the conversation_ids of this ViewFilter.
        The list of conversation ids used to filter the view

        :return: The conversation_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._conversation_ids

    @conversation_ids.setter
    def conversation_ids(self, conversation_ids):
        """
        Sets the conversation_ids of this ViewFilter.
        The list of conversation ids used to filter the view

        :param conversation_ids: The conversation_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._conversation_ids = conversation_ids

    @property
    def sip_call_ids(self):
        """
        Gets the sip_call_ids of this ViewFilter.
        The list of SIP call ids used to filter the view

        :return: The sip_call_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._sip_call_ids

    @sip_call_ids.setter
    def sip_call_ids(self, sip_call_ids):
        """
        Sets the sip_call_ids of this ViewFilter.
        The list of SIP call ids used to filter the view

        :param sip_call_ids: The sip_call_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._sip_call_ids = sip_call_ids

    @property
    def is_ended(self):
        """
        Gets the is_ended of this ViewFilter.
        Indicates filtering for ended

        :return: The is_ended of this ViewFilter.
        :rtype: bool
        """
        return self._is_ended

    @is_ended.setter
    def is_ended(self, is_ended):
        """
        Sets the is_ended of this ViewFilter.
        Indicates filtering for ended

        :param is_ended: The is_ended of this ViewFilter.
        :type: bool
        """
        
        self._is_ended = is_ended

    @property
    def is_surveyed(self):
        """
        Gets the is_surveyed of this ViewFilter.
        Indicates filtering for survey

        :return: The is_surveyed of this ViewFilter.
        :rtype: bool
        """
        return self._is_surveyed

    @is_surveyed.setter
    def is_surveyed(self, is_surveyed):
        """
        Sets the is_surveyed of this ViewFilter.
        Indicates filtering for survey

        :param is_surveyed: The is_surveyed of this ViewFilter.
        :type: bool
        """
        
        self._is_surveyed = is_surveyed

    @property
    def survey_scores(self):
        """
        Gets the survey_scores of this ViewFilter.
        The list of survey score ranges used to filter the view

        :return: The survey_scores of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._survey_scores

    @survey_scores.setter
    def survey_scores(self, survey_scores):
        """
        Sets the survey_scores of this ViewFilter.
        The list of survey score ranges used to filter the view

        :param survey_scores: The survey_scores of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._survey_scores = survey_scores

    @property
    def promoter_scores(self):
        """
        Gets the promoter_scores of this ViewFilter.
        The list of promoter score ranges used to filter the view

        :return: The promoter_scores of this ViewFilter.
        :rtype: list[NumericRange]
        """
        return self._promoter_scores

    @promoter_scores.setter
    def promoter_scores(self, promoter_scores):
        """
        Sets the promoter_scores of this ViewFilter.
        The list of promoter score ranges used to filter the view

        :param promoter_scores: The promoter_scores of this ViewFilter.
        :type: list[NumericRange]
        """
        
        self._promoter_scores = promoter_scores

    @property
    def is_campaign(self):
        """
        Gets the is_campaign of this ViewFilter.
        Indicates filtering for campaign

        :return: The is_campaign of this ViewFilter.
        :rtype: bool
        """
        return self._is_campaign

    @is_campaign.setter
    def is_campaign(self, is_campaign):
        """
        Sets the is_campaign of this ViewFilter.
        Indicates filtering for campaign

        :param is_campaign: The is_campaign of this ViewFilter.
        :type: bool
        """
        
        self._is_campaign = is_campaign

    @property
    def survey_statuses(self):
        """
        Gets the survey_statuses of this ViewFilter.
        The list of survey statuses used to filter the view

        :return: The survey_statuses of this ViewFilter.
        :rtype: list[str]
        """
        return self._survey_statuses

    @survey_statuses.setter
    def survey_statuses(self, survey_statuses):
        """
        Sets the survey_statuses of this ViewFilter.
        The list of survey statuses used to filter the view

        :param survey_statuses: The survey_statuses of this ViewFilter.
        :type: list[str]
        """
        
        self._survey_statuses = survey_statuses

    @property
    def conversation_properties(self):
        """
        Gets the conversation_properties of this ViewFilter.
        A grouping of conversation level filters

        :return: The conversation_properties of this ViewFilter.
        :rtype: ConversationProperties
        """
        return self._conversation_properties

    @conversation_properties.setter
    def conversation_properties(self, conversation_properties):
        """
        Sets the conversation_properties of this ViewFilter.
        A grouping of conversation level filters

        :param conversation_properties: The conversation_properties of this ViewFilter.
        :type: ConversationProperties
        """
        
        self._conversation_properties = conversation_properties

    @property
    def is_blind_transferred(self):
        """
        Gets the is_blind_transferred of this ViewFilter.
        Indicates filtering for blind transferred

        :return: The is_blind_transferred of this ViewFilter.
        :rtype: bool
        """
        return self._is_blind_transferred

    @is_blind_transferred.setter
    def is_blind_transferred(self, is_blind_transferred):
        """
        Sets the is_blind_transferred of this ViewFilter.
        Indicates filtering for blind transferred

        :param is_blind_transferred: The is_blind_transferred of this ViewFilter.
        :type: bool
        """
        
        self._is_blind_transferred = is_blind_transferred

    @property
    def is_consulted(self):
        """
        Gets the is_consulted of this ViewFilter.
        Indicates filtering for consulted

        :return: The is_consulted of this ViewFilter.
        :rtype: bool
        """
        return self._is_consulted

    @is_consulted.setter
    def is_consulted(self, is_consulted):
        """
        Sets the is_consulted of this ViewFilter.
        Indicates filtering for consulted

        :param is_consulted: The is_consulted of this ViewFilter.
        :type: bool
        """
        
        self._is_consulted = is_consulted

    @property
    def is_consult_transferred(self):
        """
        Gets the is_consult_transferred of this ViewFilter.
        Indicates filtering for consult transferred

        :return: The is_consult_transferred of this ViewFilter.
        :rtype: bool
        """
        return self._is_consult_transferred

    @is_consult_transferred.setter
    def is_consult_transferred(self, is_consult_transferred):
        """
        Sets the is_consult_transferred of this ViewFilter.
        Indicates filtering for consult transferred

        :param is_consult_transferred: The is_consult_transferred of this ViewFilter.
        :type: bool
        """
        
        self._is_consult_transferred = is_consult_transferred

    @property
    def remote_participants(self):
        """
        Gets the remote_participants of this ViewFilter.
        The list of remote participants used to filter the view

        :return: The remote_participants of this ViewFilter.
        :rtype: list[str]
        """
        return self._remote_participants

    @remote_participants.setter
    def remote_participants(self, remote_participants):
        """
        Sets the remote_participants of this ViewFilter.
        The list of remote participants used to filter the view

        :param remote_participants: The remote_participants of this ViewFilter.
        :type: list[str]
        """
        
        self._remote_participants = remote_participants

    @property
    def status_list(self):
        """
        Gets the status_list of this ViewFilter.
        A list of status for the configuration view

        :return: The status_list of this ViewFilter.
        :rtype: list[str]
        """
        return self._status_list

    @status_list.setter
    def status_list(self, status_list):
        """
        Sets the status_list of this ViewFilter.
        A list of status for the configuration view

        :param status_list: The status_list of this ViewFilter.
        :type: list[str]
        """
        
        self._status_list = status_list

    @property
    def flow_ids(self):
        """
        Gets the flow_ids of this ViewFilter.
        The list of flow Ids

        :return: The flow_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_ids

    @flow_ids.setter
    def flow_ids(self, flow_ids):
        """
        Sets the flow_ids of this ViewFilter.
        The list of flow Ids

        :param flow_ids: The flow_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_ids = flow_ids

    @property
    def flow_outcome_ids(self):
        """
        Gets the flow_outcome_ids of this ViewFilter.
        A list of outcome ids of the flow

        :return: The flow_outcome_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_outcome_ids

    @flow_outcome_ids.setter
    def flow_outcome_ids(self, flow_outcome_ids):
        """
        Sets the flow_outcome_ids of this ViewFilter.
        A list of outcome ids of the flow

        :param flow_outcome_ids: The flow_outcome_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_outcome_ids = flow_outcome_ids

    @property
    def flow_outcome_values(self):
        """
        Gets the flow_outcome_values of this ViewFilter.
        A list of outcome values of the flow

        :return: The flow_outcome_values of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_outcome_values

    @flow_outcome_values.setter
    def flow_outcome_values(self, flow_outcome_values):
        """
        Sets the flow_outcome_values of this ViewFilter.
        A list of outcome values of the flow

        :param flow_outcome_values: The flow_outcome_values of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_outcome_values = flow_outcome_values

    @property
    def flow_destination_types(self):
        """
        Gets the flow_destination_types of this ViewFilter.
        The list of destination types of the flow

        :return: The flow_destination_types of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_destination_types

    @flow_destination_types.setter
    def flow_destination_types(self, flow_destination_types):
        """
        Sets the flow_destination_types of this ViewFilter.
        The list of destination types of the flow

        :param flow_destination_types: The flow_destination_types of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_destination_types = flow_destination_types

    @property
    def flow_disconnect_reasons(self):
        """
        Gets the flow_disconnect_reasons of this ViewFilter.
        The list of reasons for the flow to disconnect

        :return: The flow_disconnect_reasons of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_disconnect_reasons

    @flow_disconnect_reasons.setter
    def flow_disconnect_reasons(self, flow_disconnect_reasons):
        """
        Sets the flow_disconnect_reasons of this ViewFilter.
        The list of reasons for the flow to disconnect

        :param flow_disconnect_reasons: The flow_disconnect_reasons of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_disconnect_reasons = flow_disconnect_reasons

    @property
    def flow_types(self):
        """
        Gets the flow_types of this ViewFilter.
        A list of types of the flow

        :return: The flow_types of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_types

    @flow_types.setter
    def flow_types(self, flow_types):
        """
        Sets the flow_types of this ViewFilter.
        A list of types of the flow

        :param flow_types: The flow_types of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_types = flow_types

    @property
    def flow_entry_types(self):
        """
        Gets the flow_entry_types of this ViewFilter.
        A list of types of the flow entry

        :return: The flow_entry_types of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_entry_types

    @flow_entry_types.setter
    def flow_entry_types(self, flow_entry_types):
        """
        Sets the flow_entry_types of this ViewFilter.
        A list of types of the flow entry

        :param flow_entry_types: The flow_entry_types of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_entry_types = flow_entry_types

    @property
    def flow_entry_reasons(self):
        """
        Gets the flow_entry_reasons of this ViewFilter.
        A list of reasons of flow entry

        :return: The flow_entry_reasons of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_entry_reasons

    @flow_entry_reasons.setter
    def flow_entry_reasons(self, flow_entry_reasons):
        """
        Sets the flow_entry_reasons of this ViewFilter.
        A list of reasons of flow entry

        :param flow_entry_reasons: The flow_entry_reasons of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_entry_reasons = flow_entry_reasons

    @property
    def flow_versions(self):
        """
        Gets the flow_versions of this ViewFilter.
        A list of versions of a flow

        :return: The flow_versions of this ViewFilter.
        :rtype: list[str]
        """
        return self._flow_versions

    @flow_versions.setter
    def flow_versions(self, flow_versions):
        """
        Sets the flow_versions of this ViewFilter.
        A list of versions of a flow

        :param flow_versions: The flow_versions of this ViewFilter.
        :type: list[str]
        """
        
        self._flow_versions = flow_versions

    @property
    def group_ids(self):
        """
        Gets the group_ids of this ViewFilter.
        A list of directory group ids

        :return: The group_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._group_ids

    @group_ids.setter
    def group_ids(self, group_ids):
        """
        Sets the group_ids of this ViewFilter.
        A list of directory group ids

        :param group_ids: The group_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._group_ids = group_ids

    @property
    def has_journey_customer_id(self):
        """
        Gets the has_journey_customer_id of this ViewFilter.
        Indicates filtering for journey customer id

        :return: The has_journey_customer_id of this ViewFilter.
        :rtype: bool
        """
        return self._has_journey_customer_id

    @has_journey_customer_id.setter
    def has_journey_customer_id(self, has_journey_customer_id):
        """
        Sets the has_journey_customer_id of this ViewFilter.
        Indicates filtering for journey customer id

        :param has_journey_customer_id: The has_journey_customer_id of this ViewFilter.
        :type: bool
        """
        
        self._has_journey_customer_id = has_journey_customer_id

    @property
    def has_journey_action_map_id(self):
        """
        Gets the has_journey_action_map_id of this ViewFilter.
        Indicates filtering for Journey action map id

        :return: The has_journey_action_map_id of this ViewFilter.
        :rtype: bool
        """
        return self._has_journey_action_map_id

    @has_journey_action_map_id.setter
    def has_journey_action_map_id(self, has_journey_action_map_id):
        """
        Sets the has_journey_action_map_id of this ViewFilter.
        Indicates filtering for Journey action map id

        :param has_journey_action_map_id: The has_journey_action_map_id of this ViewFilter.
        :type: bool
        """
        
        self._has_journey_action_map_id = has_journey_action_map_id

    @property
    def has_journey_visit_id(self):
        """
        Gets the has_journey_visit_id of this ViewFilter.
        Indicates filtering for Journey visit id

        :return: The has_journey_visit_id of this ViewFilter.
        :rtype: bool
        """
        return self._has_journey_visit_id

    @has_journey_visit_id.setter
    def has_journey_visit_id(self, has_journey_visit_id):
        """
        Sets the has_journey_visit_id of this ViewFilter.
        Indicates filtering for Journey visit id

        :param has_journey_visit_id: The has_journey_visit_id of this ViewFilter.
        :type: bool
        """
        
        self._has_journey_visit_id = has_journey_visit_id

    @property
    def oauth_client_ids(self):
        """
        Gets the oauth_client_ids of this ViewFilter.
        A list of OAuth client IDs

        :return: The oauth_client_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._oauth_client_ids

    @oauth_client_ids.setter
    def oauth_client_ids(self, oauth_client_ids):
        """
        Sets the oauth_client_ids of this ViewFilter.
        A list of OAuth client IDs

        :param oauth_client_ids: The oauth_client_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._oauth_client_ids = oauth_client_ids

    @property
    def api_operations(self):
        """
        Gets the api_operations of this ViewFilter.
        A list of API operations (ex: [\"GET /api/v2/users/{userId}/queues\"])

        :return: The api_operations of this ViewFilter.
        :rtype: list[str]
        """
        return self._api_operations

    @api_operations.setter
    def api_operations(self, api_operations):
        """
        Sets the api_operations of this ViewFilter.
        A list of API operations (ex: [\"GET /api/v2/users/{userId}/queues\"])

        :param api_operations: The api_operations of this ViewFilter.
        :type: list[str]
        """
        
        self._api_operations = api_operations

    @property
    def has_media(self):
        """
        Gets the has_media of this ViewFilter.
        Indicates filtering for presence of MMS media

        :return: The has_media of this ViewFilter.
        :rtype: bool
        """
        return self._has_media

    @has_media.setter
    def has_media(self, has_media):
        """
        Sets the has_media of this ViewFilter.
        Indicates filtering for presence of MMS media

        :param has_media: The has_media of this ViewFilter.
        :type: bool
        """
        
        self._has_media = has_media

    @property
    def role_ids(self):
        """
        Gets the role_ids of this ViewFilter.
        The role Ids used to filter the view

        :return: The role_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._role_ids

    @role_ids.setter
    def role_ids(self, role_ids):
        """
        Sets the role_ids of this ViewFilter.
        The role Ids used to filter the view

        :param role_ids: The role_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._role_ids = role_ids

    @property
    def reports_tos(self):
        """
        Gets the reports_tos of this ViewFilter.
        The report to user IDs used to filter the view

        :return: The reports_tos of this ViewFilter.
        :rtype: list[str]
        """
        return self._reports_tos

    @reports_tos.setter
    def reports_tos(self, reports_tos):
        """
        Sets the reports_tos of this ViewFilter.
        The report to user IDs used to filter the view

        :param reports_tos: The reports_tos of this ViewFilter.
        :type: list[str]
        """
        
        self._reports_tos = reports_tos

    @property
    def location_ids(self):
        """
        Gets the location_ids of this ViewFilter.
        The location Ids used to filter the view

        :return: The location_ids of this ViewFilter.
        :rtype: list[str]
        """
        return self._location_ids

    @location_ids.setter
    def location_ids(self, location_ids):
        """
        Sets the location_ids of this ViewFilter.
        The location Ids used to filter the view

        :param location_ids: The location_ids of this ViewFilter.
        :type: list[str]
        """
        
        self._location_ids = location_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

