# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UnscheduledAgentWarning(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UnscheduledAgentWarning - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'agent': 'UserReference',
            'unscheduled_reason': 'str'
        }

        self.attribute_map = {
            'agent': 'agent',
            'unscheduled_reason': 'unscheduledReason'
        }

        self._agent = None
        self._unscheduled_reason = None

    @property
    def agent(self):
        """
        Gets the agent of this UnscheduledAgentWarning.
        The agent for which this warning applies

        :return: The agent of this UnscheduledAgentWarning.
        :rtype: UserReference
        """
        return self._agent

    @agent.setter
    def agent(self, agent):
        """
        Sets the agent of this UnscheduledAgentWarning.
        The agent for which this warning applies

        :param agent: The agent of this UnscheduledAgentWarning.
        :type: UserReference
        """
        
        self._agent = agent

    @property
    def unscheduled_reason(self):
        """
        Gets the unscheduled_reason of this UnscheduledAgentWarning.
        The reason this agent was not scheduled

        :return: The unscheduled_reason of this UnscheduledAgentWarning.
        :rtype: str
        """
        return self._unscheduled_reason

    @unscheduled_reason.setter
    def unscheduled_reason(self, unscheduled_reason):
        """
        Sets the unscheduled_reason of this UnscheduledAgentWarning.
        The reason this agent was not scheduled

        :param unscheduled_reason: The unscheduled_reason of this UnscheduledAgentWarning.
        :type: str
        """
        allowed_values = ["NoWorkPlan", "WorkPlanNotFound", "UnableToProduceSchedule"]
        if unscheduled_reason.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for unscheduled_reason -> " + unscheduled_reason
            self._unscheduled_reason = "outdated_sdk_version"
        else:
            self._unscheduled_reason = unscheduled_reason

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

