# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ImportWeekScheduleRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ImportWeekScheduleRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'description': 'str',
            'user_schedules': 'dict(str, UserSchedule)',
            'published': 'bool',
            'short_term_forecast_id': 'str',
            'partial_upload_ids': 'list[str]'
        }

        self.attribute_map = {
            'description': 'description',
            'user_schedules': 'userSchedules',
            'published': 'published',
            'short_term_forecast_id': 'shortTermForecastId',
            'partial_upload_ids': 'partialUploadIds'
        }

        self._description = None
        self._user_schedules = None
        self._published = None
        self._short_term_forecast_id = None
        self._partial_upload_ids = None

    @property
    def description(self):
        """
        Gets the description of this ImportWeekScheduleRequest.
        Description for the schedule

        :return: The description of this ImportWeekScheduleRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ImportWeekScheduleRequest.
        Description for the schedule

        :param description: The description of this ImportWeekScheduleRequest.
        :type: str
        """
        
        self._description = description

    @property
    def user_schedules(self):
        """
        Gets the user_schedules of this ImportWeekScheduleRequest.
        User schedules

        :return: The user_schedules of this ImportWeekScheduleRequest.
        :rtype: dict(str, UserSchedule)
        """
        return self._user_schedules

    @user_schedules.setter
    def user_schedules(self, user_schedules):
        """
        Sets the user_schedules of this ImportWeekScheduleRequest.
        User schedules

        :param user_schedules: The user_schedules of this ImportWeekScheduleRequest.
        :type: dict(str, UserSchedule)
        """
        
        self._user_schedules = user_schedules

    @property
    def published(self):
        """
        Gets the published of this ImportWeekScheduleRequest.
        Whether the schedule is published

        :return: The published of this ImportWeekScheduleRequest.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this ImportWeekScheduleRequest.
        Whether the schedule is published

        :param published: The published of this ImportWeekScheduleRequest.
        :type: bool
        """
        
        self._published = published

    @property
    def short_term_forecast_id(self):
        """
        Gets the short_term_forecast_id of this ImportWeekScheduleRequest.
        Short term forecast that should be associated with this schedule

        :return: The short_term_forecast_id of this ImportWeekScheduleRequest.
        :rtype: str
        """
        return self._short_term_forecast_id

    @short_term_forecast_id.setter
    def short_term_forecast_id(self, short_term_forecast_id):
        """
        Sets the short_term_forecast_id of this ImportWeekScheduleRequest.
        Short term forecast that should be associated with this schedule

        :param short_term_forecast_id: The short_term_forecast_id of this ImportWeekScheduleRequest.
        :type: str
        """
        
        self._short_term_forecast_id = short_term_forecast_id

    @property
    def partial_upload_ids(self):
        """
        Gets the partial_upload_ids of this ImportWeekScheduleRequest.
        IDs of partial uploads of user schedules to import week schedule. It is applicable only for large schedules where activity count in schedule is greater than 17500

        :return: The partial_upload_ids of this ImportWeekScheduleRequest.
        :rtype: list[str]
        """
        return self._partial_upload_ids

    @partial_upload_ids.setter
    def partial_upload_ids(self, partial_upload_ids):
        """
        Sets the partial_upload_ids of this ImportWeekScheduleRequest.
        IDs of partial uploads of user schedules to import week schedule. It is applicable only for large schedules where activity count in schedule is greater than 17500

        :param partial_upload_ids: The partial_upload_ids of this ImportWeekScheduleRequest.
        :type: list[str]
        """
        
        self._partial_upload_ids = partial_upload_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

