# -*- coding: utf-8 -*-

"""This module provides common exception classes used throughout the application.

Copyright:
    (c) 2022 Illumio

License:
    Apache2, see LICENSE for more details.
"""
class IllumioException(Exception):
    """Superclass for Illumio library exceptions"""


class IllumioApiException(IllumioException):
    """Superclass for exceptions generated by the Illumio API code"""


class IllumioIntegerValidationException(IllumioException):
    """Raised when invalid values are provided to """
    def __init__(self, val, minimum: int, maximum: int, message="") -> None:
        if not message:
            message = "Invalid value {} - must be integer between {} and {}".format(
                val, minimum, maximum
            )
        super().__init__(message)
