# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flask_filealchemy']

package_data = \
{'': ['*']}

install_requires = \
['flask-sqlalchemy>=2.4,<3.0', 'flask>=1.0,<2.0', 'ruamel-yaml>=0.16,<0.17']

setup_kwargs = {
    'name': 'flask-filealchemy',
    'version': '0.4.0',
    'description': 'YAML-formatted plain-text file based models for Flask backed by Flask-SQLAlchemy',
    'long_description': 'Flask-FileAlchemy\n=================\n\n.. image:: https://github.com/siddhantgoel/flask-filealchemy/workflows/flask-filealchemy/badge.svg\n    :target: https://github.com/siddhantgoel/flask-filealchemy/workflows/flask-filealchemy/badge.svg\n\n.. image:: https://badge.fury.io/py/flask-filealchemy.svg\n    :target: https://pypi.python.org/pypi/flask-filealchemy\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://github.com/psf/black\n\n:code:`Flask-FileAlchemy` lets you use YAML-formatted plain-text files as the\ndata store for your Flask_ app.\n\nInstallation\n------------\n\n.. code-block:: bash\n\n   $ pip install flask-filealchemy\n\nBackground\n----------\n\nWhile there are better data stores to use in production than plain-text, the\nconstraints on data stores for applications that only have to run locally are\nmuch more relaxed. For such applications, it\'s normally OK to sacrifice on\nperformance for ease of use.\n\nOne very strong use case here is generating static sites. While you can use\n`Frozen-Flask`_ to "freeze" an entire Flask application to a set of HTML files,\nyour application still needs to read data from somewhere. This means you\'ll need\nto set up a data store, which (locally) tends to be file based SQLite. While\nthat does the job extremely well, this also means executing SQL statements to\ninput data.\n\nDepending on how many data models you have and what types they contain, this\ncan quickly get out of hand (imagine having to write an :code:`INSERT` statement\nfor a blog post).\n\nIn addition, you can\'t version control your data. Well, technically you can,\nbut the diffs won\'t make any sense to a human.\n\nFlask-FileAlchemy lets you use an alternative data store - plain text files.\n\nPlain text files have the advantage of being much easier to handle for a human.\nPlus, you can version control them so your application data and code are both\nchecked in together and share history.\n\nFlask-FileAlchemy lets you enter your data in YAML formatted plain text files\nand loads them according to the SQLAlchemy_ models you\'ve defined using\n`Flask-SQLAlchemy`_ This data is then put into whatever data store you\'re using\n(in-memory SQLite works best) and is then ready for your app to query however it\npleases.\n\nThis lets you retain the comfort of dynamic sites without compromising on the\nsimplicity of static sites.\n\nUsage\n-----\n\nDefine your data models using the standard (Flask-)SQLAlchemy API.\n\n.. code-block:: python\n\n   app = Flask(__name__)\n\n   # configure Flask-SQLAlchemy\n   app.config[\'SQLALCHEMY_DATABASE_URI\'] = \'sqlite:///:memory:\'\n\n   db = SQLAlchemy(app)\n\n   class BlogPost(db.Model):\n       __tablename__ = \'blog_posts\'\n\n       slug = Column(String(255), primary_key=True)\n       title = Column(String(255), nullable=False)\n       contents = Column(Text, nullable=False)\n\nThen, create a :code:`data/` directory somewhere on your disk (to keep things\nsimple, it\'s recommended to have this directory in the application root). For\neach model you\'ve defined, create a directory under this :code:`data/` directory\nwith the same name as the :code:`__tablename__` attribute.\n\nIn this example, we\'ll add the following contents to\n:code:`data/blog_posts/first-post-ever.yml`.\n\n.. code-block:: yaml\n\n   slug: first-post-ever\n   title: First post ever!\n   contents: |\n      This blog post talks about how it\'s the first post ever!\n\nFor "smaller" models which don\'t have more than 2-3 fields, Flask-FileAlchemy\nsupports reading from an :code:`_all.yml` file. In such a case, instead of\nadding one file for every row, simply add all the rows in the :code:`_all.yml`\nfile inside the table directory.\n\nIn this example, this could look like the following.\n\n.. code-block:: yaml\n\n   - slug: first-post-ever\n     title: First post ever!\n     contents: This blog post talks about how it\'s the first post ever!\n   - slug: second-post-ever\n     title: second post ever!\n     contents: This blog post talks about how it\'s the second post ever!\n\nFinally, configure :code:`Flask-FileAlchemy` with your setup and ask it to load\nall your data.\n\n.. code-block:: python\n\n   # configure Flask-FileAlchemy\n   app.config[\'FILEALCHEMY_DATA_DIR\'] = os.path.join(\n       os.path.dirname(os.path.realpath(__file__)), \'data\'\n   )\n   app.config[\'FILEALCHEMY_MODELS\'] = (BlogPost,)\n\n   # load tables\n   FileAlchemy(app, db).load_tables()\n\n:code:`Flask-FileAlchemy` then reads your data from the given directory, and\nstores them in the data store of your choice that you configured\n:code:`Flask-FileAlchemy` with (the preference being\n:code:`sqlite:///:memory:`).\n\nPlease note that it\'s not possible to write to this database using\n:code:`db.session`. Well, technically it\'s allowed, but the changes your app\nmakes will only be reflected in the in-memory data store but won\'t be persisted\nto disk.\n\nContributing\n------------\n\nContributions are most welcome!\n\nPlease make sure you have Python 3.5+ and Poetry_ installed.\n\n1. Git clone the repository -\n   :code:`git clone https://github.com/siddhantgoel/flask-filealchemy`.\n\n2. Install the packages required for development -\n   :code:`poetry install`.\n\n3. That\'s basically it. You should now be able to run the test suite -\n   :code:`poetry run py.test`.\n\n.. _Flask: http://flask.pocoo.org\n.. _Flask-SQLAlchemy: http://flask-sqlalchemy.pocoo.org/\n.. _Frozen-Flask: https://pythonhosted.org/Frozen-Flask/\n.. _Poetry: https://poetry.eustace.io/\n.. _SQLAlchemy: https://www.sqlalchemy.org/\n',
    'author': 'Siddhant Goel',
    'author_email': 'me@sgoel.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/siddhantgoel/flask-filealchemy',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
