# hdfio
![GitHub license](https://img.shields.io/github/license/RealPolitiX/hdfio) ![Downloads](https://pepy.tech/badge/hdfio) ![PyPI version](https://badge.fury.io/py/hdfio.svg)

All the useful python I/O utility functions for HDF5 files

## Rationale
Writing this software package aggregator is motivated by the multitude of read/write functions currently existing in the python open source community. The package combines existing mature hdf(5) I/O source code and a few similar isolated functions into a single simple and user-friendly platform to save the labor of writing newer functions of similar capabilities. It's also the basis for building more sophisticate I/O operations.


## Resources
The major resources gathered here include the following packages that covers generic I/O and interconversions between HDF and other popular key-value-pair file formats, such as **dictionary** (Python), **json**, **mat** (MATLAB).

- [h5py](https://github.com/h5py/h5py)
- [silx](https://github.com/silx-kit/silx)
- [deepdish](https://github.com/uchicago-cs/deepdish)
- [h5io](https://github.com/h5io/h5io)

## Installation

- Install and upgrade to the latest updates
    <pre><code class="console"> pip install --upgrade git+https://github.com/RealPolitiX/hdfio.git </code></pre>


- Install the latest build from PyPI
    <pre><code class="console"> pip install hdfio </code></pre>