"""
    @kin-kinetic/api

    The OpenAPI definition of the Kinetic API  # noqa: E501

    The version of the OpenAPI document: 1.0.0-rc.13
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from kinetic_sdk.generated.client.api_client import ApiClient
from kinetic_sdk.generated.client.api_client import Endpoint as _Endpoint
from kinetic_sdk.generated.client.model.account_info import AccountInfo
from kinetic_sdk.generated.client.model.balance_response import BalanceResponse
from kinetic_sdk.generated.client.model.close_account_request import CloseAccountRequest
from kinetic_sdk.generated.client.model.commitment import Commitment
from kinetic_sdk.generated.client.model.create_account_request import CreateAccountRequest
from kinetic_sdk.generated.client.model.history_response import HistoryResponse
from kinetic_sdk.generated.client.model.transaction import Transaction
from kinetic_sdk.generated.client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class AccountApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.close_account_endpoint = _Endpoint(
            settings={
                "response_type": (Transaction,),
                "auth": [],
                "endpoint_path": "/api/account/close",
                "operation_id": "close_account",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "close_account_request",
                ],
                "required": [
                    "close_account_request",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "close_account_request": (CloseAccountRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "close_account_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )
        self.create_account_endpoint = _Endpoint(
            settings={
                "response_type": (Transaction,),
                "auth": [],
                "endpoint_path": "/api/account/create",
                "operation_id": "create_account",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "create_account_request",
                ],
                "required": [
                    "create_account_request",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "create_account_request": (CreateAccountRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "create_account_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={"accept": ["application/json"], "content_type": ["application/json"]},
            api_client=api_client,
        )
        self.get_account_info_endpoint = _Endpoint(
            settings={
                "response_type": (AccountInfo,),
                "auth": [],
                "endpoint_path": "/api/account/info/{environment}/{index}/{accountId}/{mint}",
                "operation_id": "get_account_info",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "environment",
                    "index",
                    "account_id",
                    "mint",
                    "commitment",
                ],
                "required": [
                    "environment",
                    "index",
                    "account_id",
                    "mint",
                    "commitment",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "environment": (str,),
                    "index": (int,),
                    "account_id": (str,),
                    "mint": (str,),
                    "commitment": (Commitment,),
                },
                "attribute_map": {
                    "environment": "environment",
                    "index": "index",
                    "account_id": "accountId",
                    "mint": "mint",
                    "commitment": "commitment",
                },
                "location_map": {
                    "environment": "path",
                    "index": "path",
                    "account_id": "path",
                    "mint": "path",
                    "commitment": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_balance_endpoint = _Endpoint(
            settings={
                "response_type": (BalanceResponse,),
                "auth": [],
                "endpoint_path": "/api/account/balance/{environment}/{index}/{accountId}",
                "operation_id": "get_balance",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "environment",
                    "index",
                    "account_id",
                    "commitment",
                ],
                "required": [
                    "environment",
                    "index",
                    "account_id",
                    "commitment",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "environment": (str,),
                    "index": (int,),
                    "account_id": (str,),
                    "commitment": (Commitment,),
                },
                "attribute_map": {
                    "environment": "environment",
                    "index": "index",
                    "account_id": "accountId",
                    "commitment": "commitment",
                },
                "location_map": {
                    "environment": "path",
                    "index": "path",
                    "account_id": "path",
                    "commitment": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_history_endpoint = _Endpoint(
            settings={
                "response_type": ([HistoryResponse],),
                "auth": [],
                "endpoint_path": "/api/account/history/{environment}/{index}/{accountId}/{mint}",
                "operation_id": "get_history",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "environment",
                    "index",
                    "account_id",
                    "mint",
                    "commitment",
                ],
                "required": [
                    "environment",
                    "index",
                    "account_id",
                    "mint",
                    "commitment",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "environment": (str,),
                    "index": (int,),
                    "account_id": (str,),
                    "mint": (str,),
                    "commitment": (Commitment,),
                },
                "attribute_map": {
                    "environment": "environment",
                    "index": "index",
                    "account_id": "accountId",
                    "mint": "mint",
                    "commitment": "commitment",
                },
                "location_map": {
                    "environment": "path",
                    "index": "path",
                    "account_id": "path",
                    "mint": "path",
                    "commitment": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )
        self.get_token_accounts_endpoint = _Endpoint(
            settings={
                "response_type": ([str],),
                "auth": [],
                "endpoint_path": "/api/account/token-accounts/{environment}/{index}/{accountId}/{mint}",
                "operation_id": "get_token_accounts",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "environment",
                    "index",
                    "account_id",
                    "mint",
                    "commitment",
                ],
                "required": [
                    "environment",
                    "index",
                    "account_id",
                    "mint",
                    "commitment",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "environment": (str,),
                    "index": (int,),
                    "account_id": (str,),
                    "mint": (str,),
                    "commitment": (Commitment,),
                },
                "attribute_map": {
                    "environment": "environment",
                    "index": "index",
                    "account_id": "accountId",
                    "mint": "mint",
                    "commitment": "commitment",
                },
                "location_map": {
                    "environment": "path",
                    "index": "path",
                    "account_id": "path",
                    "mint": "path",
                    "commitment": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def close_account(self, close_account_request, **kwargs):
        """# noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.close_account(close_account_request, async_req=True)
        >>> result = thread.get()

        Args:
            close_account_request (CloseAccountRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Transaction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["close_account_request"] = close_account_request
        return self.close_account_endpoint.call_with_http_info(**kwargs)

    def create_account(self, create_account_request, **kwargs):
        """# noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account(create_account_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_account_request (CreateAccountRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Transaction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["create_account_request"] = create_account_request
        return self.create_account_endpoint.call_with_http_info(**kwargs)

    def get_account_info(self, environment, index, account_id, mint, commitment, **kwargs):
        """# noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account_info(environment, index, account_id, mint, commitment, async_req=True)
        >>> result = thread.get()

        Args:
            environment (str):
            index (int):
            account_id (str):
            mint (str):
            commitment (Commitment):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountInfo
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["environment"] = environment
        kwargs["index"] = index
        kwargs["account_id"] = account_id
        kwargs["mint"] = mint
        kwargs["commitment"] = commitment
        return self.get_account_info_endpoint.call_with_http_info(**kwargs)

    def get_balance(self, environment, index, account_id, commitment, **kwargs):
        """# noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_balance(environment, index, account_id, commitment, async_req=True)
        >>> result = thread.get()

        Args:
            environment (str):
            index (int):
            account_id (str):
            commitment (Commitment):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BalanceResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["environment"] = environment
        kwargs["index"] = index
        kwargs["account_id"] = account_id
        kwargs["commitment"] = commitment
        return self.get_balance_endpoint.call_with_http_info(**kwargs)

    def get_history(self, environment, index, account_id, mint, commitment, **kwargs):
        """# noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_history(environment, index, account_id, mint, commitment, async_req=True)
        >>> result = thread.get()

        Args:
            environment (str):
            index (int):
            account_id (str):
            mint (str):
            commitment (Commitment):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [HistoryResponse]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["environment"] = environment
        kwargs["index"] = index
        kwargs["account_id"] = account_id
        kwargs["mint"] = mint
        kwargs["commitment"] = commitment
        return self.get_history_endpoint.call_with_http_info(**kwargs)

    def get_token_accounts(self, environment, index, account_id, mint, commitment, **kwargs):
        """# noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_token_accounts(environment, index, account_id, mint, commitment, async_req=True)
        >>> result = thread.get()

        Args:
            environment (str):
            index (int):
            account_id (str):
            mint (str):
            commitment (Commitment):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [str]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["environment"] = environment
        kwargs["index"] = index
        kwargs["account_id"] = account_id
        kwargs["mint"] = mint
        kwargs["commitment"] = commitment
        return self.get_token_accounts_endpoint.call_with_http_info(**kwargs)
