"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessKeyFunctionCodeCache = exports.AccessKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AccessKey extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const secretName = `${aws_cdk_lib_1.Names.uniqueId(this)}${props.user.userName}`;
        aws_cdk_lib_1.Tags.of(props.user).add('CfnStackIdForAccessKeyLibrary', aws_cdk_lib_1.Stack.of(this).stackId);
        const lambdaPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'SecretsManagerPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'SecretsManagerPolicy',
                    actions: [
                        'secretsmanager:PutSecretValue',
                        'secretsmanager:CreateSecret',
                        'secretsmanager:DeleteSecret',
                        'secretsmanager:UpdateSecret',
                        'secretsmanager:TagResource',
                        'secretsmanager:RestoreSecret',
                    ],
                    resources: [`arn:aws:secretsmanager:${aws_cdk_lib_1.Stack.of(this).region}:${aws_cdk_lib_1.Stack.of(this).account}:secret:${secretName}-*`],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'IamAllowKeyManagementPolicy',
                    actions: [
                        'iam:CreateAccessKey',
                        'iam:DeleteAccessKey',
                        'iam:ListAccessKeys',
                    ],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'iam:ResourceTag/CfnStackIdForAccessKeyLibrary': aws_cdk_lib_1.Stack.of(this).stackId,
                        },
                    },
                }),
            ],
        });
        if (props.kmsKey) {
            lambdaPolicy.addStatements(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                sid: 'KmsAllowKeyManagementPolicy',
                actions: [
                    'kms:Encrypt',
                    'kms:Decrypt',
                    'kms:ReEncrypt*',
                    'kms:GenerateDataKey*',
                ],
                resources: [props.kmsKey.keyArn],
            }));
        }
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                lambdaPolicy,
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'OnEventHandler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            handler: 'index.handler',
            code: props.lambdaCode ?? aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            role,
        });
        const secret = new aws_cdk_lib_1.CustomResource(this, 'SecretArn', {
            serviceToken: onEventHandler.functionArn,
            properties: {
                UserName: props.user.userName,
                SecretName: secretName,
                Region: aws_cdk_lib_1.Stack.of(this).region,
                Override: props.overwriteSecret ?? true,
                Restore: props.restoreSecret ?? true,
                KmsKeyId: props.kmsKey == undefined ? 'alias/aws/secretsmanager' : props.kmsKey.keyId,
            },
        });
        this.secret = aws_cdk_lib_1.aws_secretsmanager.Secret.fromSecretCompleteArn(this, 'Secret', secret.getAttString('SecretArn'));
    }
}
exports.AccessKey = AccessKey;
_a = JSII_RTTI_SYMBOL_1;
AccessKey[_a] = { fqn: "@renovosolutions/cdk-library-aws-iam-access-key.AccessKey", version: "0.0.15" };
class AccessKeyFunctionCodeCache extends aws_cdk_lib_1.aws_s3.Bucket {
    constructor(scope, id, props) {
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.DESTROY;
        const autoDeleteObjects = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        super(scope, id, {
            removalPolicy,
            autoDeleteObjects,
            ...props,
        });
        /** Force the final unzipped asset to be a zip by nesting zips */
        const bundlingCmds = [
            'mkdir -p /asset-output',
            'mkdir -p temp',
            'pip install -r /asset-input/requirements.txt -t /asset-input/temp',
            'cp index.py /asset-input/temp/index.py',
            'cd temp',
            'zip -r lambda.zip .',
            'zip -r /asset-output/temp.zip lambda.zip',
            'cd ..',
            'rm -rf ./temp',
        ];
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'Deployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(path.join(__dirname, '../lambda'), {
                    bundling: {
                        image: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9.bundlingImage,
                        command: [
                            'bash', '-c', bundlingCmds.join(' && '),
                        ],
                    },
                })],
            destinationBucket: this,
            exclude: ['__pycache__/*', '*.pyc'],
            include: ['*.py'],
        });
        this.lambdaCode = aws_cdk_lib_1.aws_lambda.Code.fromBucket(this, 'index.py');
    }
    /**
     * Add access to the whole organization to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgId The organization ID to require for any accounts accessing the bucket.
     */
    addOrgWideAccessPolicy(principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: [
                's3:GetObject',
            ],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified accounts to get
     * the lambda function code from the bucket.
     *
     * @param principalAccountId The account ID to add access for.
     * @param principalOrgId (Optional) The organization ID to require for the account accessing the bucket.
     */
    addAccountAccessPolicy(principalAccountId, principalOrgId) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.AccountPrincipal(principalAccountId)],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: principalOrgId === undefined ? undefined : {
                StringEquals: {
                    'aws:PrincipalOrgID': principalOrgId,
                },
            },
        }));
    }
    ;
    /**
     * Add access to the specified organizational units to get
     * the lambda function code from the bucket.
     *
     * @param principalOrgPaths The organizational unit paths to add access for.
     */
    addOrgOuAccessPolicy(principalOrgPaths) {
        return this.addToResourcePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            principals: [new aws_cdk_lib_1.aws_iam.StarPrincipal],
            actions: ['s3:GetObject'],
            resources: [this.arnForObjects('*')],
            conditions: {
                StringLike: {
                    'aws:PrincipalOrgPaths': principalOrgPaths,
                },
            },
        }));
    }
}
exports.AccessKeyFunctionCodeCache = AccessKeyFunctionCodeCache;
_b = JSII_RTTI_SYMBOL_1;
AccessKeyFunctionCodeCache[_b] = { fqn: "@renovosolutions/cdk-library-aws-iam-access-key.AccessKeyFunctionCodeCache", version: "0.0.15" };
;
//# sourceMappingURL=data:application/json;base64,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