# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['beetsplug', 'beetsplug.bandcamp']

package_data = \
{'': ['*']}

install_requires = \
['beets>=1.4',
 'ordered-set>=4.0',
 'pycountry>=20.7.3',
 'python-dateutil>=2.8.2',
 'requests>=2.27']

extras_require = \
{':python_version < "3.8"': ['cached-property>=1.5.2']}

entry_points = \
{'console_scripts': ['beetcamp = beetsplug.bandcamp:main']}

setup_kwargs = {
    'name': 'beetcamp',
    'version': '0.16.0',
    'description': 'Bandcamp autotagger source for beets (http://beets.io).',
    'long_description': '[![Stand With Ukraine](https://raw.githubusercontent.com/vshymanskyy/StandWithUkraine/main/banner2-direct.svg)](https://vshymanskyy.github.io/StandWithUkraine)\n\n---\n\n[![image](http://img.shields.io/pypi/v/beetcamp.svg)](https://pypi.python.org/pypi/beetcamp)\n[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=snejus_beets-bandcamp&metric=alert_status)](https://sonarcloud.io/dashboard?id=snejus_beets-bandcamp)\n[![Coverage Status](https://coveralls.io/repos/github/snejus/beetcamp/badge.svg?branch=master)](https://coveralls.io/github/snejus/beetcamp?branch=master)\n[ ![Hits](https://hits.seeyoufarm.com/api/count/incr/badge.svg?url=https%3A%2F%2Fgithub.com%2Fsnejus%2Fbeetcamp&count_bg=%23842424&title_bg=%23846060&icon=postwoman.svg&icon_color=%23CF4D4D&title=hits&edge_flat=true)](https://hits.seeyoufarm.com)\n\nBandcamp autotagger plugin for [beets]. It mostly focuses on\n\n- Staying up-to-date with information Bandcamp provide in the JSON metadata\n- Parsing **all possible** (if relevant) metadata from various places\n  - For example, a catalog number given in the release or media description\n- Correctness of the data\n  - For example, determining artist names from various artists releases\n- Compliance with MusicBrainz fields format, to remove the need for pre-processing if, for\n  example, one wishes to upload the metadata to MB.\n\nThanks to [unrblt] for [beets-bandcamp] providing the idea and initial implementation.\n\n[beets]: https://github.com/beetbox/beets\n[unrblt]: https://github.com/unrblt\n[beets-bandcamp]: https://github.com/unrblt/beets-bandcamp\n\n# Installation\n\n## Recommended method\n\n1. Install `beets` with `pipx` so that it\'s isolated from your system and other projects\n\n```bash\npipx install beets\n```\n\n2. Inject `beetcamp` and other dependencies that you need\n\n```bash\npipx inject beets beetcamp [python-mpd2 ...]\n```\n\n3. Add `bandcamp` to the `plugins` list to your beets configuration file.\n\n## Otherwise\n\nNavigate to your `beets` virtual environment and install the plug-in with\n\n```bash\n   pip install beetcamp\n```\n\n# CLI\nThe plugin exposes some of its functionality through a command-line application `beetcamp`:\n\n```xml\nusage: beetcamp [-h] [-a] [-l] [-t] [release_url | query]\n\nGet bandcamp release metadata from the given <release-url> or perform \nbandcamp search with <query>. Anything that does not start with https:// \nwill be assumed to be a query. Search type flags: -a for albums, -l for \nlabels and artists, -t for tracks. By default, all types are searched.\n\npositional arguments:\n  release_url  Release URL, starting with https:// OR\n  query        Search query\n\noptions:\n  -h, --help   show this help message and exit\n  -a, --album  Search albums\n  -l, --label  Search labels and artists\n  -t, --track  Search tracks\n```\n\n* Use `beetcamp <bandcamp-release-url>` to return release metadata in JSON format.\n* Use `beetcamp [-alt] <query>` to search albums, labels and tracks on Bandcamp and return\n  results in JSON. You can get the general idea of the kind of data the search returns below (the\n  output is prettified with [rich] externally)\n\n![image](images/search.png)\n\n[rich]: https://github.com/Textualize/rich\n\n# Configuration\n\n## Default\n\n```yaml\nbandcamp:\n  include_digital_only_tracks: true\n  search_max: 2\n  art: yes\n  comments_separator: "\\n---\\n"\n  exclude_extra_fields: []\n  genre:\n    capitalize: no\n    maximum: 0\n    always_include: []\n    mode: progressive # classical, progressive or psychedelic\n```\n\n---\n\n#### `include_digital_only_tracks`\n\n- Type: **bool**\n- Default: `true`\n\nFor media that isn\'t `Digital Media`, include all tracks, even if their titles contain\n**digital only** (or alike).\n\nIf you have `False` here, then, for example, a `Vinyl` media of an album will only include\nthe tracks that are supposed to be found in that media.\n\n---\n\n#### `search_max`\n\n- Type: **int**\n- Default: `2`.\n\nNumber of items to fetch through search, maximum is 18. Usually, a matching release should\nbe found among the first two items.\n\n---\n\n#### `art`\n\n- Type: **bool**\n- Default: `false`.\n\nAdd a source to the\n[FetchArt](http://beets.readthedocs.org/en/latest/plugins/fetchart.html) plug-in to\ndownload album art for Bandcamp albums (requires `FetchArt` plug-in enabled).\n\n---\n\n#### `comments_separator`\n\n- Type: **string**\n- Default: `"\\n---\\n"`.\n\nThe separator that divides release, media descriptions and credits within the `comments`\nfield. By default you would get\n\n    Description\n    ---\n    Media description\n    ---\n    Credits\n\n#### `exclude_extra_fields`\n\n- Type: **list**\n- Default: _`empty`_\n\nList of fields that you _do not_ want to see in the metadata. For example, if you find the\ninclusion of `comments` irrelevant and are not interested in lyrics, you could specify\n\n```yaml\nbandcamp:\n  search_max: 5\n  exclude_extra_fields:\n    - lyrics\n    - comments\n```\n\nand the plugin will skip them.\n\nYou cannot exclude `album`, `album_id`, `artist_id`, `media` and `data_url` album fields.\n\n---\n\n#### `genre` (new since 0.11.0)\n\n- Type: **object**\n- Default:\n  ```yaml\n  genre:\n    capitalize: no\n    maximum: 0 # no maximum\n    mode: progressive\n    always_include: []\n  ```\n\n**genre.capitalize**: **Classical, Techno** instead of default **classical, techno**.\nFor consistency, this option also applies to the `style` field.\n\n**genre.maximum** caps the maximum number of included genres. This may be of\nvalue in those cases where artists/labels begin the list with the most relevant keywords,\nhowever be aware it is rarely the case.\n\n**genre.mode** accepts one of the following options: **classical** (less genres) or **progressive** or\n**psychedelic** (more genres). Each later one is more flexible regarding what is a valid\ngenre and what is not. See below (we use the list of [musicbrainz genres] for reference).\n\n**genre.always_include**: genre patterns that override the mode and always match\nsuccessfully. For example, if you want to bypass checks for every keyword that ends with\n`core`, you could specify\n\n```yaml\ngenre:\n  always_include:\n    - "core$"\n```\n\n##### `genre` modes\n\nWe can place all keywords into the following buckets:\n\n| type  |                                      |                                                                      |\n| :---: | ------------------------------------ | -------------------------------------------------------------------- |\n| **1** | **`genre`**                          | a valid single-word musicbrainz genre                                |\n| **1** | **`more specific genre`**            | a valid musicbrainz genre made of multiple words                     |\n| **2** | **`somegenre`** **`someothergenre`** | each of the words is a valid musicbrainz genre, but the combo is not |\n| **3** | very specific **`genre`**            | not all words are valid genres, but the very last one is             |\n| **4** | maybe **`genre`** but                | but it is followed by noise at the end                               |\n| **4** | some sort of location                | irrelevant                                                           |\n\n- **classical** mode strictly follows the musicbrainz list of genres, therefore it covers\n  **type 1** only\n- **progressive** mode, in addition to the above, takes into account each of the words that\n  make up the keyword and will be fine as long as each of those words maps to some sort of\n  genre from the musicbrainz list. It covers **types 1 and 2**.\n- **psychedelic** (or **noise**) mode, in addition to the above, treats the keyword as a\n  valid genre as long as **the last word** in it maps to some genre - covering **types 1 to 3**.\n  This one should include the hottest genre naming trends but is also liable to covering the\n  latest `<some-label>-<genre>` or `<some-city>-<some-very-generic-genre>` trends which may\n  not be ideal. It should though be the best option for those who enjoy detailed, fine-grained\n  stats.\n- **type 4** is ignored in each case (can be overridden and included through the `genre.include` option).\n\nSee below for some examples and a comparison between the modes.\n\n|  type | keyword                 | classical | progressive | psychedelic |\n| ----: | ----------------------- | :-------: | :---------: | :---------: |\n| **1** | **`techno`**            |     ✔     |      ✔      |      ✔      |\n| **1** | **`funk`**              |     ✔     |      ✔      |      ✔      |\n| **1** | **`ambient`**           |     ✔     |      ✔      |      ✔      |\n| **1** | **`noise`**             |     ✔     |      ✔      |      ✔      |\n| **1** | **`ambient techno`**    |     ✔     |      ✔      |      ✔      |\n| **2** | **`techno`** **`funk`** |     ✖     |      ✔      |      ✔      |\n| **4** | funky                   |     ✖     |      ✖      |      ✖      |\n| **4** | bleep                   |     ✖     |      ✖      |      ✖      |\n| **3** | funky **`techno`**      |     ✖     |      ✖      |      ✔      |\n| **4** | bleepy beep             |     ✖     |      ✖      |      ✖      |\n| **3** | bleepy beep **`noise`** |     ✖     |      ✖      |      ✔      |\n| **4** | bleepy **`noise`** beep |     ✖     |      ✖      |      ✖      |\n\n# Usage\n\nThis plug-in uses Bandcamp release URL as `album_id` (`.../album/...` for albums and\n`.../track/...` for singletons). If no matching release is found during the import you can\nselect `enter Id` and paste the URL that you have.\n\n## Supported metadata\n\n| field          | singleton | album track | album | note                                                                                |\n| -------------: | :-------: | :---------: | :---: | :---------------------------------------------------------------------------------: |\n| `album`        |           |             | ✔     |                                                                                     |\n| `album_id`     |           |             | ✔     | release Bandcamp URL                                                                |\n| `albumartist`  |           |             | ✔     |                                                                                     |\n| `albumstatus`  |           |             | ✔     |                                                                                     |\n| `albumtype`    | \\*✔       |             | ✔     |                                                                                     |\n| `albumtypes`   | \\*✔       |             | \\*✔   |                                                                                     |\n| `artist`       | ✔         | ✔           | ✔     |                                                                                     |\n| `artist_id`    | ✔         |             | ✔     | label / publisher Bandcamp URL                                                      |\n| `catalognum`   | \\*✔       |             | ✔     |                                                                                     |\n| `comments`     | \\*✔       |             | \\*✔   | release and media descriptions, and credits                                         |\n| `country`      | \\*✔       |             | ✔     |                                                                                     |\n| `day`          | \\*✔       |             | ✔     |                                                                                     |\n| `disctitle`    | \\*✔       | ✔           |       |                                                                                     |\n| `genre`        | \\*✔       |             | \\*✔   | comma-delimited list of **release keywords** which match [musicbrainz genres]       |\n| `index`        |           | ✔           |       |                                                                                     |\n| `label`        | \\*✔       |             | ✔     |                                                                                     |\n| `length`       | ✔         | ✔           |       |                                                                                     |\n| `lyrics`       | \\*✔       | \\*✔         |       |                                                                                     |\n| `media`        | \\*✔       | ✔           | ✔     |                                                                                     |\n| `medium`       |           | ✔           |       | likely to be inaccurate, since it depends on information in the release description |\n| `mediums`      |           |             | ✔     |                                                                                     |\n| `medium_index` |           | ✔           |       | for now, same as `index`                                                            |\n| `medium_total` |           | ✔           |       | total number of tracks in the release                                               |\n| `month`        | \\*✔       |             | ✔     |                                                                                     |\n| `style`        | \\*✔       |             | \\*✔   | Bandcamp genre tag                                                                  |\n| `title`        | ✔         | ✔           |       |                                                                                     |\n| `track_alt`    | ✔         | ✔           |       |                                                                                     |\n| `track_id`     |           | ✔           |       | track URL                                                                           |\n| `va`           |           |             | ✔     |                                                                                     |\n| `year`         | \\*✔       |             | ✔     |                                                                                     |\n\n**\\*** Available with `beets` versions `1.5` or higher.\n\n[musicbrainz genres]: https://beta.musicbrainz.org/genres\n',
    'author': 'Šarūnas Nejus',
    'author_email': 'snejus@pm.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/snejus/beetcamp',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4',
}


setup(**setup_kwargs)
