randmac.py
==========

a utility that generates 12-digit mac addresses; either the NIC portion or full 12-digit MAC. 

the optional `-f` argument will return a random 12-digit MAC address that can be identified by the locally administrated address (LAA) format. This means you will always see `x2`, `x6`, `xA`, or `xE` at the beginning of a MAC address generated by randmac.

# installation

to install with pip:

`pip install randmac`

# requirements

Python >3.2 required.

# mac address formats

Supported MAC address formats:
 - MM:MM:MM:SS:SS:SS
 - MM-MM-MM-SS-SS-SS
 - MM.MM.MM.SS.SS.SS
 - MMMM.MMSS.SSSS
 - MMMMMMSSSSSS

where `M` stands for the manufacturer or vendor, and `S` stands for the NIC specific portion. 

# usage

you can `from randmac import RandMac` and use it like `RandMac()`.

if you wish to change the mac address format. provide a sample mac so `randmac` knows what the output format should be.

you can `from randmac import RandMac` and use it like `RandMac("0000.0000.0000")`.

from a terminal (if the the console scripts entry point `randmac` is in your path and executable) you can use `randmac` to get a generate a new 12-digit LAA address, or `randmac 00:00:00:00:00:00 -p` to generate a MAC with the same OUI, but a different NIC portion.

# example usage

```
>>> from randmac import RandMac
>>> RandMac()
'a6:9b:6b:8e:b3:42'
>>> RandMac("00:00:00:00:00:00", True)
'00:00:00:3f:8a:06'
>>> RandMac("0000:0000:0000", True)
'0000007ce662'
>>> RandMac("0000:0000:0000")
'06eb4584d1e3'
```

or

```
> randmac
fa:bf:7c:5d:65:3e
> randmac 00-00-00-00-00-00 -p
00-00-00-dd-5f-16
``` 

# license

license can be found [here](https://github.com/joshschmelzle/randmac/blob/master/LICENSE).
