"use strict";
// @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobPermission = void 0;
/**
 * Access level for workflow permission scopes.
 */
var JobPermission;
(function (JobPermission) {
    /** Read-only access */
    JobPermission["READ"] = "read";
    /** Read-write access */
    JobPermission["WRITE"] = "write";
    /** No access at all */
    JobPermission["NONE"] = "none";
})(JobPermission = exports.JobPermission || (exports.JobPermission = {}));
//#endregion
//# sourceMappingURL=data:application/json;base64,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