"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAccessToken = exports.toJson_CfnAccessTokenProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnAccessTokenProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnAccessTokenProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'ProjectId': obj.projectId,
        'AccessLevel': obj.accessLevel,
        'Scopes': obj.scopes?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnAccessTokenProps = toJson_CfnAccessTokenProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `GitLab::Projects::AccessToken`
 *
 * @cloudformationResource GitLab::Projects::AccessToken
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
class CfnAccessToken extends cdk.CfnResource {
    /**
     * Create a new `GitLab::Projects::AccessToken`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAccessToken.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnAccessTokenProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asNumber(this.getAtt('Id'));
    }
}
exports.CfnAccessToken = CfnAccessToken;
_a = JSII_RTTI_SYMBOL_1;
CfnAccessToken[_a] = { fqn: "@cdk-cloudformation/gitlab-projects-accesstoken.CfnAccessToken", version: "1.2.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnAccessToken.CFN_RESOURCE_TYPE_NAME = "GitLab::Projects::AccessToken";
//# sourceMappingURL=data:application/json;base64,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