# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TwingateConnectorTokensArgs', 'TwingateConnectorTokens']

@pulumi.input_type
class TwingateConnectorTokensArgs:
    def __init__(__self__, *,
                 connector_id: pulumi.Input[str],
                 keepers: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a TwingateConnectorTokens resource.
        :param pulumi.Input[str] connector_id: The ID of the parent Connector
        :param pulumi.Input[Mapping[str, Any]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. Use this to automatically rotate Connector tokens on a schedule.
        """
        pulumi.set(__self__, "connector_id", connector_id)
        if keepers is not None:
            pulumi.set(__self__, "keepers", keepers)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Input[str]:
        """
        The ID of the parent Connector
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter
    def keepers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. Use this to automatically rotate Connector tokens on a schedule.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "keepers", value)


@pulumi.input_type
class _TwingateConnectorTokensState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TwingateConnectorTokens resources.
        :param pulumi.Input[str] access_token: The Access Token of the parent Connector
        :param pulumi.Input[str] connector_id: The ID of the parent Connector
        :param pulumi.Input[Mapping[str, Any]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. Use this to automatically rotate Connector tokens on a schedule.
        :param pulumi.Input[str] refresh_token: The Refresh Token of the parent Connector
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if keepers is not None:
            pulumi.set(__self__, "keepers", keepers)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Access Token of the parent Connector
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the parent Connector
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter
    def keepers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. Use this to automatically rotate Connector tokens on a schedule.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "keepers", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        The Refresh Token of the parent Connector
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)


class TwingateConnectorTokens(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        This resource type will generate tokens for a Connector, which are needed to successfully provision one on your network. The Connector itself has its own resource type and must be created before you can provision tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_twingate as twingate

        aws_network = twingate.TwingateRemoteNetwork("awsNetwork", name="aws_remote_network")
        aws_connector = twingate.TwingateConnector("awsConnector", remote_network_id=aws_network.id)
        aws_connector_tokens = twingate.TwingateConnectorTokens("awsConnectorTokens", connector_id=aws_connector.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connector_id: The ID of the parent Connector
        :param pulumi.Input[Mapping[str, Any]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. Use this to automatically rotate Connector tokens on a schedule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TwingateConnectorTokensArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource type will generate tokens for a Connector, which are needed to successfully provision one on your network. The Connector itself has its own resource type and must be created before you can provision tokens.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_twingate as twingate

        aws_network = twingate.TwingateRemoteNetwork("awsNetwork", name="aws_remote_network")
        aws_connector = twingate.TwingateConnector("awsConnector", remote_network_id=aws_network.id)
        aws_connector_tokens = twingate.TwingateConnectorTokens("awsConnectorTokens", connector_id=aws_connector.id)
        ```

        :param str resource_name: The name of the resource.
        :param TwingateConnectorTokensArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TwingateConnectorTokensArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TwingateConnectorTokensArgs.__new__(TwingateConnectorTokensArgs)

            if connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'connector_id'")
            __props__.__dict__["connector_id"] = connector_id
            __props__.__dict__["keepers"] = keepers
            __props__.__dict__["access_token"] = None
            __props__.__dict__["refresh_token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessToken", "refreshToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TwingateConnectorTokens, __self__).__init__(
            'twingate:index/twingateConnectorTokens:TwingateConnectorTokens',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[str]] = None,
            connector_id: Optional[pulumi.Input[str]] = None,
            keepers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            refresh_token: Optional[pulumi.Input[str]] = None) -> 'TwingateConnectorTokens':
        """
        Get an existing TwingateConnectorTokens resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: The Access Token of the parent Connector
        :param pulumi.Input[str] connector_id: The ID of the parent Connector
        :param pulumi.Input[Mapping[str, Any]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. Use this to automatically rotate Connector tokens on a schedule.
        :param pulumi.Input[str] refresh_token: The Refresh Token of the parent Connector
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TwingateConnectorTokensState.__new__(_TwingateConnectorTokensState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["keepers"] = keepers
        __props__.__dict__["refresh_token"] = refresh_token
        return TwingateConnectorTokens(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[str]:
        """
        The Access Token of the parent Connector
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[str]:
        """
        The ID of the parent Connector
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter
    def keepers(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. Use this to automatically rotate Connector tokens on a schedule.
        """
        return pulumi.get(self, "keepers")

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> pulumi.Output[str]:
        """
        The Refresh Token of the parent Connector
        """
        return pulumi.get(self, "refresh_token")

