# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetTwingateConnectorResult',
    'AwaitableGetTwingateConnectorResult',
    'get_twingate_connector',
    'get_twingate_connector_output',
]

@pulumi.output_type
class GetTwingateConnectorResult:
    """
    A collection of values returned by getTwingateConnector.
    """
    def __init__(__self__, id=None, name=None, remote_network_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if remote_network_id and not isinstance(remote_network_id, str):
            raise TypeError("Expected argument 'remote_network_id' to be a str")
        pulumi.set(__self__, "remote_network_id", remote_network_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Connector. The ID for the Connector must be obtained from the Admin API.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Connector
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="remoteNetworkId")
    def remote_network_id(self) -> str:
        """
        The ID of the Remote Network the Connector is attached to
        """
        return pulumi.get(self, "remote_network_id")


class AwaitableGetTwingateConnectorResult(GetTwingateConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTwingateConnectorResult(
            id=self.id,
            name=self.name,
            remote_network_id=self.remote_network_id)


def get_twingate_connector(id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTwingateConnectorResult:
    """
    Connectors provide connectivity to Remote Networks. For more information, see Twingate's [documentation](https://docs.twingate.com/docs/understanding-access-nodes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_twingate as twingate

    foo = twingate.get_twingate_connector(id="<your connector's id>")
    ```


    :param str id: The ID of the Connector. The ID for the Connector must be obtained from the Admin API.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('twingate:index/getTwingateConnector:getTwingateConnector', __args__, opts=opts, typ=GetTwingateConnectorResult).value

    return AwaitableGetTwingateConnectorResult(
        id=__ret__.id,
        name=__ret__.name,
        remote_network_id=__ret__.remote_network_id)


@_utilities.lift_output_func(get_twingate_connector)
def get_twingate_connector_output(id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTwingateConnectorResult]:
    """
    Connectors provide connectivity to Remote Networks. For more information, see Twingate's [documentation](https://docs.twingate.com/docs/understanding-access-nodes).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_twingate as twingate

    foo = twingate.get_twingate_connector(id="<your connector's id>")
    ```


    :param str id: The ID of the Connector. The ID for the Connector must be obtained from the Admin API.
    """
    ...
