# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'TwingateResourceAccessArgs',
    'TwingateResourceProtocolsArgs',
    'TwingateResourceProtocolsTcpArgs',
    'TwingateResourceProtocolsUdpArgs',
    'GetTwingateConnectorsConnectorArgs',
    'GetTwingateGroupsGroupArgs',
    'GetTwingateRemoteNetworksRemoteNetworkArgs',
    'GetTwingateResourceProtocolArgs',
    'GetTwingateResourceProtocolTcpArgs',
    'GetTwingateResourceProtocolUdpArgs',
    'GetTwingateResourcesResourceArgs',
    'GetTwingateResourcesResourceProtocolArgs',
    'GetTwingateResourcesResourceProtocolTcpArgs',
    'GetTwingateResourcesResourceProtocolUdpArgs',
    'GetTwingateSecurityPoliciesSecurityPolicyArgs',
    'GetTwingateServiceAccountsServiceAccountArgs',
    'GetTwingateUsersUserArgs',
]

@pulumi.input_type
class TwingateResourceAccessArgs:
    def __init__(__self__, *,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_ids: List of Group IDs that will have permission to access the Resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_ids: List of Service Account IDs that will have permission to access the Resource.
        """
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if service_account_ids is not None:
            pulumi.set(__self__, "service_account_ids", service_account_ids)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Group IDs that will have permission to access the Resource.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter(name="serviceAccountIds")
    def service_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Service Account IDs that will have permission to access the Resource.
        """
        return pulumi.get(self, "service_account_ids")

    @service_account_ids.setter
    def service_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_account_ids", value)


@pulumi.input_type
class TwingateResourceProtocolsArgs:
    def __init__(__self__, *,
                 tcp: pulumi.Input['TwingateResourceProtocolsTcpArgs'],
                 udp: pulumi.Input['TwingateResourceProtocolsUdpArgs'],
                 allow_icmp: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] allow_icmp: Whether to allow ICMP (ping) traffic
        """
        pulumi.set(__self__, "tcp", tcp)
        pulumi.set(__self__, "udp", udp)
        if allow_icmp is not None:
            pulumi.set(__self__, "allow_icmp", allow_icmp)

    @property
    @pulumi.getter
    def tcp(self) -> pulumi.Input['TwingateResourceProtocolsTcpArgs']:
        return pulumi.get(self, "tcp")

    @tcp.setter
    def tcp(self, value: pulumi.Input['TwingateResourceProtocolsTcpArgs']):
        pulumi.set(self, "tcp", value)

    @property
    @pulumi.getter
    def udp(self) -> pulumi.Input['TwingateResourceProtocolsUdpArgs']:
        return pulumi.get(self, "udp")

    @udp.setter
    def udp(self, value: pulumi.Input['TwingateResourceProtocolsUdpArgs']):
        pulumi.set(self, "udp", value)

    @property
    @pulumi.getter(name="allowIcmp")
    def allow_icmp(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow ICMP (ping) traffic
        """
        return pulumi.get(self, "allow_icmp")

    @allow_icmp.setter
    def allow_icmp(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_icmp", value)


@pulumi.input_type
class TwingateResourceProtocolsTcpArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[str],
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        pulumi.set(__self__, "policy", policy)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class TwingateResourceProtocolsUdpArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[str],
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        pulumi.set(__self__, "policy", policy)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class GetTwingateConnectorsConnectorArgs:
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 remote_network_id: str):
        """
        :param str id: The ID of the Connector
        :param str name: The Name of the Connector
        :param str remote_network_id: The ID of the Remote Network attached to the Connector
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "remote_network_id", remote_network_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Connector
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Name of the Connector
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="remoteNetworkId")
    def remote_network_id(self) -> str:
        """
        The ID of the Remote Network attached to the Connector
        """
        return pulumi.get(self, "remote_network_id")

    @remote_network_id.setter
    def remote_network_id(self, value: str):
        pulumi.set(self, "remote_network_id", value)


@pulumi.input_type
class GetTwingateGroupsGroupArgs:
    def __init__(__self__, *,
                 id: str,
                 is_active: bool,
                 name: str,
                 type: str):
        """
        :param str id: The ID of the Group
        :param bool is_active: Indicates if the Group is active
        :param str name: The name of the Group
        :param str type: The type of the Group
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_active", is_active)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Group
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> bool:
        """
        Indicates if the Group is active
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: bool):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the Group
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: str):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GetTwingateRemoteNetworksRemoteNetworkArgs:
    def __init__(__self__, *,
                 id: str,
                 location: str,
                 name: str):
        """
        :param str id: The ID of the Remote Network
        :param str location: The location of the Remote Network. Must be one of the following: AWS, AZURE, GOOGLE*CLOUD, ON*PREMISE, OTHER.
        :param str name: The name of the Remote Network
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Remote Network
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location of the Remote Network. Must be one of the following: AWS, AZURE, GOOGLE*CLOUD, ON*PREMISE, OTHER.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: str):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Remote Network
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GetTwingateResourceProtocolArgs:
    def __init__(__self__, *,
                 allow_icmp: bool,
                 tcps: Optional[Sequence['GetTwingateResourceProtocolTcpArgs']] = None,
                 udps: Optional[Sequence['GetTwingateResourceProtocolUdpArgs']] = None):
        """
        :param bool allow_icmp: Whether to allow ICMP (ping) traffic
        """
        pulumi.set(__self__, "allow_icmp", allow_icmp)
        if tcps is not None:
            pulumi.set(__self__, "tcps", tcps)
        if udps is not None:
            pulumi.set(__self__, "udps", udps)

    @property
    @pulumi.getter(name="allowIcmp")
    def allow_icmp(self) -> bool:
        """
        Whether to allow ICMP (ping) traffic
        """
        return pulumi.get(self, "allow_icmp")

    @allow_icmp.setter
    def allow_icmp(self, value: bool):
        pulumi.set(self, "allow_icmp", value)

    @property
    @pulumi.getter
    def tcps(self) -> Optional[Sequence['GetTwingateResourceProtocolTcpArgs']]:
        return pulumi.get(self, "tcps")

    @tcps.setter
    def tcps(self, value: Optional[Sequence['GetTwingateResourceProtocolTcpArgs']]):
        pulumi.set(self, "tcps", value)

    @property
    @pulumi.getter
    def udps(self) -> Optional[Sequence['GetTwingateResourceProtocolUdpArgs']]:
        return pulumi.get(self, "udps")

    @udps.setter
    def udps(self, value: Optional[Sequence['GetTwingateResourceProtocolUdpArgs']]):
        pulumi.set(self, "udps", value)


@pulumi.input_type
class GetTwingateResourceProtocolTcpArgs:
    def __init__(__self__, *,
                 policy: str,
                 ports: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: str):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Sequence[str]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class GetTwingateResourceProtocolUdpArgs:
    def __init__(__self__, *,
                 policy: str,
                 ports: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: str):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Sequence[str]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class GetTwingateResourcesResourceArgs:
    def __init__(__self__, *,
                 address: str,
                 id: str,
                 name: str,
                 remote_network_id: str,
                 protocols: Optional[Sequence['GetTwingateResourcesResourceProtocolArgs']] = None):
        """
        :param str address: The Resource's IP/CIDR or FQDN/DNS zone
        :param str id: The id of the Resource
        :param str name: The name of the Resource
        :param str remote_network_id: Remote Network ID where the Resource lives
        :param Sequence['GetTwingateResourcesResourceProtocolArgs'] protocols: Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no restriction, and all protocols and ports are allowed.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "remote_network_id", remote_network_id)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The Resource's IP/CIDR or FQDN/DNS zone
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: str):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Resource
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="remoteNetworkId")
    def remote_network_id(self) -> str:
        """
        Remote Network ID where the Resource lives
        """
        return pulumi.get(self, "remote_network_id")

    @remote_network_id.setter
    def remote_network_id(self, value: str):
        pulumi.set(self, "remote_network_id", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence['GetTwingateResourcesResourceProtocolArgs']]:
        """
        Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no restriction, and all protocols and ports are allowed.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[Sequence['GetTwingateResourcesResourceProtocolArgs']]):
        pulumi.set(self, "protocols", value)


@pulumi.input_type
class GetTwingateResourcesResourceProtocolArgs:
    def __init__(__self__, *,
                 allow_icmp: bool,
                 tcps: Optional[Sequence['GetTwingateResourcesResourceProtocolTcpArgs']] = None,
                 udps: Optional[Sequence['GetTwingateResourcesResourceProtocolUdpArgs']] = None):
        pulumi.set(__self__, "allow_icmp", allow_icmp)
        if tcps is not None:
            pulumi.set(__self__, "tcps", tcps)
        if udps is not None:
            pulumi.set(__self__, "udps", udps)

    @property
    @pulumi.getter(name="allowIcmp")
    def allow_icmp(self) -> bool:
        return pulumi.get(self, "allow_icmp")

    @allow_icmp.setter
    def allow_icmp(self, value: bool):
        pulumi.set(self, "allow_icmp", value)

    @property
    @pulumi.getter
    def tcps(self) -> Optional[Sequence['GetTwingateResourcesResourceProtocolTcpArgs']]:
        return pulumi.get(self, "tcps")

    @tcps.setter
    def tcps(self, value: Optional[Sequence['GetTwingateResourcesResourceProtocolTcpArgs']]):
        pulumi.set(self, "tcps", value)

    @property
    @pulumi.getter
    def udps(self) -> Optional[Sequence['GetTwingateResourcesResourceProtocolUdpArgs']]:
        return pulumi.get(self, "udps")

    @udps.setter
    def udps(self, value: Optional[Sequence['GetTwingateResourcesResourceProtocolUdpArgs']]):
        pulumi.set(self, "udps", value)


@pulumi.input_type
class GetTwingateResourcesResourceProtocolTcpArgs:
    def __init__(__self__, *,
                 policy: str,
                 ports: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: str):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Sequence[str]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class GetTwingateResourcesResourceProtocolUdpArgs:
    def __init__(__self__, *,
                 policy: str,
                 ports: Sequence[str]):
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def policy(self) -> str:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: str):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def ports(self) -> Sequence[str]:
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Sequence[str]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class GetTwingateSecurityPoliciesSecurityPolicyArgs:
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str id: Return a matching Security Policy by its ID. The ID for the Security Policy must be obtained from the Admin API.
        :param str name: Return a Security Policy that exactly matches this name.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Return a matching Security Policy by its ID. The ID for the Security Policy must be obtained from the Admin API.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Return a Security Policy that exactly matches this name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GetTwingateServiceAccountsServiceAccountArgs:
    def __init__(__self__, *,
                 id: str,
                 key_ids: Sequence[str],
                 name: str,
                 resource_ids: Sequence[str]):
        """
        :param str id: ID of the Service Account resource
        :param Sequence[str] key_ids: List of twingate*service*account_key IDs that are assigned to the Service Account.
        :param str name: Name of the Service Account
        :param Sequence[str] resource_ids: List of TwingateResource IDs that the Service Account is assigned to.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_ids", key_ids)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_ids", resource_ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the Service Account resource
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="keyIds")
    def key_ids(self) -> Sequence[str]:
        """
        List of twingate*service*account_key IDs that are assigned to the Service Account.
        """
        return pulumi.get(self, "key_ids")

    @key_ids.setter
    def key_ids(self, value: Sequence[str]):
        pulumi.set(self, "key_ids", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Service Account
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Sequence[str]:
        """
        List of TwingateResource IDs that the Service Account is assigned to.
        """
        return pulumi.get(self, "resource_ids")

    @resource_ids.setter
    def resource_ids(self, value: Sequence[str]):
        pulumi.set(self, "resource_ids", value)


@pulumi.input_type
class GetTwingateUsersUserArgs:
    def __init__(__self__, *,
                 email: str,
                 first_name: str,
                 id: str,
                 is_admin: bool,
                 last_name: str,
                 role: str):
        """
        :param str email: The email address of the User
        :param str first_name: The first name of the User
        :param str id: The ID of the User
        :param bool is_admin: Indicates whether the User is an admin
        :param str last_name: The last name of the User
        :param str role: Indicates the User's role. Either ADMIN, DEVOPS, SUPPORT, or MEMBER.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_admin", is_admin)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email address of the User
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: str):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        The first name of the User
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: str):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the User
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Indicates whether the User is an admin
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: bool):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        The last name of the User
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: str):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Indicates the User's role. Either ADMIN, DEVOPS, SUPPORT, or MEMBER.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: str):
        pulumi.set(self, "role", value)


