/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlCastOperator;
import org.apache.calcite.sql.fun.SqlJsonDepthFunction;
import org.apache.calcite.sql.fun.SqlJsonKeysFunction;
import org.apache.calcite.sql.fun.SqlJsonLengthFunction;
import org.apache.calcite.sql.fun.SqlJsonPrettyFunction;
import org.apache.calcite.sql.fun.SqlJsonRemoveFunction;
import org.apache.calcite.sql.fun.SqlJsonStorageSizeFunction;
import org.apache.calcite.sql.fun.SqlJsonTypeFunction;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlRegexpReplaceFunction;
import org.apache.calcite.sql.fun.SqlTranslate3Function;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;

public abstract class SqlLibraryOperators {
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONVERT_TIMEZONE = new SqlFunction("CONVERT_TIMEZONE", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.CHARACTER_CHARACTER_DATETIME, SqlFunctionCategory.TIMEDATE);
    private static final SqlReturnTypeInference DECODE_RETURN_TYPE = opBinding -> {
        ArrayList<RelDataType> list = new ArrayList<RelDataType>();
        int n = opBinding.getOperandCount();
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                ++i;
            }
            list.add(opBinding.getOperandType(i));
        }
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.leastRestrictive(list);
        if (opBinding.getOperandCount() % 2 == 1) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction DECODE = new SqlFunction("DECODE", SqlKind.DECODE, DECODE_RETURN_TYPE, null, OperandTypes.VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction NVL = new SqlFunction("NVL", SqlKind.NVL, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE_ALL), null, OperandTypes.SAME_SAME, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction LTRIM = new SqlFunction("LTRIM", SqlKind.LTRIM, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction RTRIM = new SqlFunction("RTRIM", SqlKind.RTRIM, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction SUBSTR = new SqlFunction("SUBSTR", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction GREATEST = new SqlFunction("GREATEST", SqlKind.GREATEST, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction LEAST = new SqlFunction("LEAST", SqlKind.LEAST, ReturnTypes.cascade(ReturnTypes.LEAST_RESTRICTIVE, SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL})
    public static final SqlFunction TRANSLATE3 = new SqlTranslate3Function();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_TYPE = new SqlJsonTypeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_DEPTH = new SqlJsonDepthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_LENGTH = new SqlJsonLengthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_KEYS = new SqlJsonKeysFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_PRETTY = new SqlJsonPrettyFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_REMOVE = new SqlJsonRemoveFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_STORAGE_SIZE = new SqlJsonStorageSizeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.ORACLE})
    public static final SqlFunction REGEXP_REPLACE = new SqlRegexpReplaceFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction COMPRESS = new SqlFunction("COMPRESS", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARBINARY), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction EXTRACT_VALUE = new SqlFunction("EXTRACTVALUE", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.VARCHAR_2000, SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction XML_TRANSFORM = new SqlFunction("XMLTRANSFORM", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.VARCHAR_2000, SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXTRACT_XML = new SqlFunction("EXTRACT", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.VARCHAR_2000, SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXISTS_NODE = new SqlFunction("EXISTSNODE", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.INTEGER_NULLABLE, SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction MONTHNAME = new SqlFunction("MONTHNAME", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, null, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction DAYNAME = new SqlFunction("DAYNAME", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, null, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction LEFT = new SqlFunction("LEFT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction REPEAT = new SqlFunction("REPEAT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.STRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction RIGHT = new SqlFunction("RIGHT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction SPACE = new SqlFunction("SPACE", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction STRCMP = new SqlFunction("STRCMP", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction SOUNDEX = new SqlFunction("SOUNDEX", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_4_NULLABLE, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction DIFFERENCE = new SqlFunction("DIFFERENCE", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONCAT_FUNCTION = new SqlFunction("CONCAT", SqlKind.OTHER_FUNCTION, ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, null, OperandTypes.repeat(SqlOperandCountRanges.from(2), OperandTypes.STRING), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction CONCAT2 = new SqlFunction("CONCAT", SqlKind.OTHER_FUNCTION, ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, null, OperandTypes.STRING_SAME_SAME, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction REVERSE = new SqlFunction("REVERSE", SqlKind.REVERSE, ReturnTypes.ARG0_NULLABLE_VARYING, null, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction FROM_BASE64 = new SqlFunction("FROM_BASE64", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARBINARY), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction TO_BASE64 = new SqlFunction("TO_BASE64", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.or(OperandTypes.STRING, OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_DATE = new SqlFunction("TO_DATE", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_TIMESTAMP = new SqlFunction("TO_TIMESTAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.DATE_NULLABLE, null, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction CHR = new SqlFunction("CHR", SqlKind.OTHER_FUNCTION, ReturnTypes.CHAR, null, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction TANH = new SqlFunction("TANH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction COSH = new SqlFunction("COSH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction SINH = new SqlFunction("SINH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction MD5 = new SqlFunction("MD5", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.or(OperandTypes.STRING, OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction SHA1 = new SqlFunction("SHA1", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.or(OperandTypes.STRING, OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlOperator INFIX_CAST = new SqlCastOperator();

    private SqlLibraryOperators() {
    }
}

