/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.JaninoRexCompiler;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Nodes;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.interpreter.Source;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.TransformedEnumerator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.CalcSplitRule;
import org.apache.calcite.rel.rules.FilterTableScanRule;
import org.apache.calcite.rel.rules.ProjectTableScanRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitDispatcher;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;

public class Interpreter
extends AbstractEnumerable<Object[]>
implements AutoCloseable {
    private final Map<RelNode, NodeInfo> nodes;
    private final DataContext dataContext;
    private final RelNode rootRel;

    public Interpreter(DataContext dataContext, RelNode rootRel) {
        this.dataContext = Objects.requireNonNull(dataContext);
        RelNode rel = this.optimize(rootRel);
        Nodes.CoreCompiler compiler = new Nodes.CoreCompiler(this, rootRel.getCluster());
        Pair<RelNode, Map<RelNode, NodeInfo>> pair = compiler.visitRoot(rel);
        this.rootRel = (RelNode)pair.left;
        this.nodes = ImmutableMap.copyOf((Map)pair.right);
    }

    private RelNode optimize(RelNode rootRel) {
        HepProgram hepProgram = new HepProgramBuilder().addRuleInstance(CalcSplitRule.INSTANCE).addRuleInstance(FilterTableScanRule.INSTANCE).addRuleInstance(FilterTableScanRule.INTERPRETER).addRuleInstance(ProjectTableScanRule.INSTANCE).addRuleInstance(ProjectTableScanRule.INTERPRETER).addRuleInstance(AggregateReduceFunctionsRule.INSTANCE).build();
        HepPlanner planner = new HepPlanner(hepProgram);
        planner.setRoot(rootRel);
        rootRel = planner.findBestExp();
        return rootRel;
    }

    @Override
    public Enumerator<Object[]> enumerator() {
        Enumerator<Object> rows;
        this.start();
        NodeInfo nodeInfo = this.nodes.get(this.rootRel);
        if (nodeInfo.rowEnumerable != null) {
            rows = nodeInfo.rowEnumerable.enumerator();
        } else {
            ArrayDeque<Row> queue = Iterables.getOnlyElement(nodeInfo.sinks.values()).list;
            rows = Linq4j.iterableEnumerator(queue);
        }
        return new TransformedEnumerator<Row, Object[]>(rows){

            @Override
            protected Object[] transform(Row row) {
                return row.getValues();
            }
        };
    }

    private void start() {
        for (Map.Entry<RelNode, NodeInfo> entry : this.nodes.entrySet()) {
            NodeInfo nodeInfo = entry.getValue();
            try {
                nodeInfo.node.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
    }

    static interface ScalarCompiler {
        public Scalar compile(List<RexNode> var1, RelDataType var2);
    }

    static class Edge
    extends Pair<RelNode, Integer> {
        Edge(RelNode parent, int ordinal) {
            super(parent, ordinal);
        }
    }

    static class CompilerImpl
    extends RelVisitor
    implements Compiler,
    ReflectiveVisitor {
        final ScalarCompiler scalarCompiler;
        private final ReflectiveVisitDispatcher<CompilerImpl, RelNode> dispatcher = ReflectUtil.createDispatcher(CompilerImpl.class, RelNode.class);
        protected final Interpreter interpreter;
        protected RelNode rootRel;
        protected RelNode rel;
        protected Node node;
        final Map<RelNode, NodeInfo> nodes = new LinkedHashMap<RelNode, NodeInfo>();
        final Map<RelNode, List<RelNode>> relInputs = new HashMap<RelNode, List<RelNode>>();
        final Multimap<RelNode, Edge> outEdges = LinkedHashMultimap.create();
        private static final String REWRITE_METHOD_NAME = "rewrite";
        private static final String VISIT_METHOD_NAME = "visit";

        CompilerImpl(Interpreter interpreter, RelOptCluster cluster) {
            this.interpreter = interpreter;
            this.scalarCompiler = new JaninoRexCompiler(cluster.getRexBuilder());
        }

        Pair<RelNode, Map<RelNode, NodeInfo>> visitRoot(RelNode p) {
            this.rootRel = p;
            this.visit(p, 0, null);
            return Pair.of(this.rootRel, this.nodes);
        }

        @Override
        public void visit(RelNode p, int ordinal, RelNode parent) {
            while (true) {
                this.rel = null;
                boolean found = this.dispatcher.invokeVisitor(this, p, REWRITE_METHOD_NAME);
                if (!found) {
                    throw new AssertionError((Object)"interpreter: no implementation for rewrite");
                }
                if (this.rel == null) break;
                if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                    System.out.println("Interpreter: rewrite " + p + " to " + this.rel);
                }
                p = this.rel;
                if (parent != null) {
                    List<RelNode> inputs = this.relInputs.get(parent);
                    if (inputs == null) {
                        inputs = Lists.newArrayList(parent.getInputs());
                        this.relInputs.put(parent, inputs);
                    }
                    inputs.set(ordinal, p);
                    continue;
                }
                this.rootRel = p;
            }
            List<RelNode> inputs = this.relInputs.get(p);
            RelNode finalP = p;
            Ord.forEach((Iterable)Util.first(inputs, p.getInputs()), (r, i) -> this.outEdges.put((RelNode)r, new Edge(finalP, i)));
            if (inputs != null) {
                for (int i2 = 0; i2 < inputs.size(); ++i2) {
                    RelNode input = inputs.get(i2);
                    this.visit(input, i2, p);
                }
            } else {
                p.childrenAccept(this);
            }
            this.node = null;
            boolean found = this.dispatcher.invokeVisitor(this, p, VISIT_METHOD_NAME);
            if (!found) {
                if (p instanceof InterpretableRel) {
                    InterpretableRel interpretableRel = (InterpretableRel)p;
                    this.node = interpretableRel.implement(new InterpretableRel.InterpreterImplementor(this, null, null));
                } else {
                    throw new AssertionError((Object)("interpreter: no implementation for " + p.getClass()));
                }
            }
            NodeInfo nodeInfo = this.nodes.get(p);
            assert (nodeInfo != null);
            nodeInfo.node = this.node;
            if (inputs != null) {
                for (int i3 = 0; i3 < inputs.size(); ++i3) {
                    RelNode input = inputs.get(i3);
                    this.visit(input, i3, p);
                }
            }
        }

        public void rewrite(RelNode r) {
        }

        @Override
        public Scalar compile(List<RexNode> nodes, RelDataType inputRowType) {
            if (inputRowType == null) {
                inputRowType = this.interpreter.dataContext.getTypeFactory().builder().build();
            }
            return this.scalarCompiler.compile(nodes, inputRowType);
        }

        @Override
        public RelDataType combinedRowType(List<RelNode> inputs) {
            RelDataTypeFactory.FieldInfoBuilder builder = this.interpreter.dataContext.getTypeFactory().builder();
            for (RelNode input : inputs) {
                ((RelDataTypeFactory.Builder)builder).addAll(input.getRowType().getFieldList());
            }
            return builder.build();
        }

        @Override
        public Source source(RelNode rel, int ordinal) {
            RelNode input = this.getInput(rel, ordinal);
            Edge edge = new Edge(rel, ordinal);
            Collection<Edge> edges = this.outEdges.get(input);
            NodeInfo nodeInfo = this.nodes.get(input);
            if (nodeInfo == null) {
                throw new AssertionError((Object)("should be registered: " + rel));
            }
            if (nodeInfo.rowEnumerable != null) {
                return new EnumeratorSource(nodeInfo.rowEnumerable.enumerator());
            }
            assert (nodeInfo.sinks.size() == edges.size());
            ListSink sink = nodeInfo.sinks.get(edge);
            if (sink != null) {
                return new ListSource(sink.list);
            }
            throw new IllegalStateException("Got a sink " + sink + " to which there is no match source type!");
        }

        private RelNode getInput(RelNode rel, int ordinal) {
            List<RelNode> inputs = this.relInputs.get(rel);
            if (inputs != null) {
                return inputs.get(ordinal);
            }
            return rel.getInput(ordinal);
        }

        @Override
        public Sink sink(RelNode rel) {
            Collection<Edge> edges = this.outEdges.get(rel);
            Collection<Edge> edges2 = edges.isEmpty() ? ImmutableList.of(new Edge(null, 0)) : edges;
            NodeInfo nodeInfo = this.nodes.get(rel);
            if (nodeInfo == null) {
                nodeInfo = new NodeInfo(rel, null);
                this.nodes.put(rel, nodeInfo);
                for (Edge edge : edges2) {
                    nodeInfo.sinks.put(edge, new ListSink(new ArrayDeque()));
                }
            } else {
                for (Edge edge : edges2) {
                    if (nodeInfo.sinks.containsKey(edge)) continue;
                    nodeInfo.sinks.put(edge, new ListSink(new ArrayDeque()));
                }
            }
            if (edges.size() == 1) {
                return Iterables.getOnlyElement(nodeInfo.sinks.values());
            }
            ArrayList<ArrayDeque<Row>> queues = new ArrayList<ArrayDeque<Row>>();
            for (ListSink sink : nodeInfo.sinks.values()) {
                queues.add(sink.list);
            }
            return new DuplicatingSink(queues);
        }

        @Override
        public void enumerable(RelNode rel, Enumerable<Row> rowEnumerable) {
            NodeInfo nodeInfo = new NodeInfo(rel, rowEnumerable);
            this.nodes.put(rel, nodeInfo);
        }

        @Override
        public Context createContext() {
            return new Context(this.getDataContext());
        }

        @Override
        public DataContext getDataContext() {
            return this.interpreter.dataContext;
        }
    }

    private static class DuplicatingSink
    implements Sink {
        private List<ArrayDeque<Row>> queues;

        private DuplicatingSink(List<ArrayDeque<Row>> queues) {
            this.queues = ImmutableList.copyOf(queues);
        }

        @Override
        public void send(Row row) throws InterruptedException {
            for (ArrayDeque<Row> queue : this.queues) {
                queue.add(row);
            }
        }

        @Override
        public void end() throws InterruptedException {
        }

        @Override
        public void setSourceEnumerable(Enumerable<Row> enumerable) throws InterruptedException {
            Enumerator enumerator = enumerable.enumerator();
            while (enumerator.moveNext()) {
                this.send((Row)enumerator.current());
            }
            enumerator.close();
        }
    }

    private static class ListSource
    implements Source {
        private final ArrayDeque<Row> list;
        private Iterator<Row> iterator = null;

        ListSource(ArrayDeque<Row> list) {
            this.list = list;
        }

        @Override
        public Row receive() {
            try {
                if (this.iterator == null) {
                    this.iterator = this.list.iterator();
                }
                return this.iterator.next();
            }
            catch (NoSuchElementException e) {
                this.iterator = null;
                return null;
            }
        }

        @Override
        public void close() {
        }
    }

    private static class ListSink
    implements Sink {
        final ArrayDeque<Row> list;

        private ListSink(ArrayDeque<Row> list) {
            this.list = list;
        }

        @Override
        public void send(Row row) throws InterruptedException {
            this.list.add(row);
        }

        @Override
        public void end() throws InterruptedException {
        }

        @Override
        public void setSourceEnumerable(Enumerable<Row> enumerable) throws InterruptedException {
            Enumerator enumerator = enumerable.enumerator();
            while (enumerator.moveNext()) {
                this.send((Row)enumerator.current());
            }
            enumerator.close();
        }
    }

    private static class EnumeratorSource
    implements Source {
        private final Enumerator<Row> enumerator;

        EnumeratorSource(Enumerator<Row> enumerator) {
            this.enumerator = Objects.requireNonNull(enumerator);
        }

        @Override
        public Row receive() {
            if (this.enumerator.moveNext()) {
                return this.enumerator.current();
            }
            this.enumerator.close();
            return null;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    private static class NodeInfo {
        final RelNode rel;
        final Map<Edge, ListSink> sinks = new LinkedHashMap<Edge, ListSink>();
        final Enumerable<Row> rowEnumerable;
        Node node;

        NodeInfo(RelNode rel, Enumerable<Row> rowEnumerable) {
            this.rel = rel;
            this.rowEnumerable = rowEnumerable;
        }
    }

    private class FooCompiler
    implements ScalarCompiler {
        private FooCompiler() {
        }

        @Override
        public Scalar compile(List<RexNode> nodes, RelDataType inputRowType) {
            final RexNode node = nodes.get(0);
            if (node instanceof RexCall) {
                final RexCall call = (RexCall)node;
                final Scalar argScalar = this.compile(call.getOperands(), inputRowType);
                return new Scalar(){
                    final Object[] args;
                    {
                        this.args = new Object[call.getOperands().size()];
                    }

                    @Override
                    public void execute(Context context, Object[] results) {
                        results[0] = this.execute(context);
                    }

                    @Override
                    public Object execute(Context context) {
                        switch (call.getKind()) {
                            case LESS_THAN: 
                            case LESS_THAN_OR_EQUAL: 
                            case GREATER_THAN: 
                            case GREATER_THAN_OR_EQUAL: 
                            case EQUALS: 
                            case NOT_EQUALS: {
                                argScalar.execute(context, this.args);
                                Comparable o0 = (Comparable)this.args[0];
                                if (o0 == null) {
                                    return null;
                                }
                                Comparable o1 = (Comparable)this.args[1];
                                if (o1 == null) {
                                    return null;
                                }
                                if (o0 instanceof BigDecimal) {
                                    o1 = o1 instanceof Double || o1 instanceof Float ? new BigDecimal(((Number)((Object)o1)).doubleValue()) : new BigDecimal(((Number)((Object)o1)).longValue());
                                }
                                if (o1 instanceof BigDecimal) {
                                    o0 = o0 instanceof Double || o0 instanceof Float ? new BigDecimal(((Number)((Object)o0)).doubleValue()) : new BigDecimal(((Number)((Object)o0)).longValue());
                                }
                                int c = o0.compareTo(o1);
                                switch (call.getKind()) {
                                    case LESS_THAN: {
                                        return c < 0;
                                    }
                                    case LESS_THAN_OR_EQUAL: {
                                        return c <= 0;
                                    }
                                    case GREATER_THAN: {
                                        return c > 0;
                                    }
                                    case GREATER_THAN_OR_EQUAL: {
                                        return c >= 0;
                                    }
                                    case EQUALS: {
                                        return c == 0;
                                    }
                                    case NOT_EQUALS: {
                                        return c != 0;
                                    }
                                }
                                throw new AssertionError((Object)("unknown expression " + call));
                            }
                        }
                        if (call.getOperator() == SqlStdOperatorTable.UPPER) {
                            argScalar.execute(context, this.args);
                            String s0 = (String)this.args[0];
                            if (s0 == null) {
                                return null;
                            }
                            return s0.toUpperCase(Locale.ROOT);
                        }
                        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
                            argScalar.execute(context, this.args);
                            String s0 = (String)this.args[0];
                            Number i1 = (Number)this.args[1];
                            Number i2 = (Number)this.args[2];
                            if (s0 == null || i1 == null || i2 == null) {
                                return null;
                            }
                            return s0.substring(i1.intValue() - 1, i1.intValue() - 1 + i2.intValue());
                        }
                        throw new AssertionError((Object)("unknown expression " + call));
                    }
                };
            }
            return new Scalar(){

                @Override
                public void execute(Context context, Object[] results) {
                    results[0] = this.execute(context);
                }

                @Override
                public Object execute(Context context) {
                    switch (node.getKind()) {
                        case LITERAL: {
                            return ((RexLiteral)node).getValueAs(Comparable.class);
                        }
                        case INPUT_REF: {
                            return context.values[((RexInputRef)node).getIndex()];
                        }
                    }
                    throw new RuntimeException("unknown expression type " + node);
                }
            };
        }
    }
}

