"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRoute = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const authorizer_1 = require("./authorizer");
/**
 * Route class that creates the Route for API Gateway WebSocket API
 * @resource AWS::ApiGatewayV2::Route
 */
class WebSocketRoute extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteProps(props);
        if (props.routeKey != '$connect' && props.authorizer) {
            throw new Error('You can only set a WebSocket authorizer to a $connect route.');
        }
        this.webSocketApi = props.webSocketApi;
        this.routeKey = props.routeKey;
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        const authorizer = (_b = props.authorizer) !== null && _b !== void 0 ? _b : new authorizer_1.WebSocketNoneAuthorizer(); // must be explicitly NONE (not undefined) for stack updates to work correctly
        const authBindResult = authorizer.bind({
            route: this,
            scope: this.webSocketApi instanceof constructs_1.Construct ? this.webSocketApi : this,
        });
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            apiKeyRequired: props.apiKeyRequired,
            routeKey: props.routeKey,
            target: `integrations/${config.integrationId}`,
            authorizerId: authBindResult.authorizerId,
            authorizationType: authBindResult.authorizationType,
        });
        this.routeId = route.ref;
    }
}
exports.WebSocketRoute = WebSocketRoute;
_a = JSII_RTTI_SYMBOL_1;
WebSocketRoute[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRoute", version: "2.17.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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